/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XObjectnodeTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import java.io.IOException;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.util.JDom;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;
import org.jdom.Element;
import org.jdom.JDOMException;


/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XObjectnodeTest extends TestCase {
    private static final String STR =
        "<data>\n" +
        "  <objectnode uri='/'>\n" +
        "    <objectnode uri='/foo'>\n" +
        "      <objectnode uri='/foo/bar'></objectnode>\n" +
        "    </objectnode>\n" +
        "  </objectnode>\n" +
        "</data>\n";

    private static class Result {
        public Element start;
        public Element end;
    }

    private Result on;

    public XObjectnodeTest(String name) {
        super(name);
    }

    public void testLocateEmpty() throws XException {
        on = locate(new XUri("/"), STR);
        assertSame(on.end, get(on.start, 1));
    }

    public void testLocateTwo() throws XException {
        on = locate(new XUri("/foo/bar"), STR);
        assertSame(on.end, get(on.start, 3));
    }

    public void testNotFound() throws XException {
        assertNull(locate(new XUri("no/such/path"), STR).end);
        assertNull(locate(new XUri("/foo/bar/additional"), STR).end);
    }

    public void testCreateNewChild() throws XException {
        on = create(new XUri("/foo/bar/additional"), STR);
        assertEquals(on.end, get(on.start, 4));
        assertEquals(1, on.end.getParent().getContent().size());
        assertEquals(0, on.end.getContent().size());
    }

    public void testCreateSibling() throws XException {
        List lst;

        on = create(new XUri("/xx"), STR);
        lst = get(on.start, 1).getChildren(XDomainConstants.OBJECTNODE);
        assertEquals(2, lst.size());
        assertSame(on.end, lst.get(1));
    }

    public void testRemoveEmpty() throws XException {
        on = locate(new XUri("/foo/bar"), STR);
        XObjectnode.removeRecursive(on.end);
        assertEquals(0, get(on.start, 1).getChildren(XDomainConstants.OBJECTNODE).size());
    }
    public void testRemoveNoneEmpty() throws XException {
        on = create(new XUri("/xx"), STR);
        XObjectnode.removeRecursive(on.end);
        assertTrue(on.end != get(on.start, 3));
    }

    private Element get(Element root, int count) throws XException {
        int i;

        for (i = 0; i < count; i++) {
            root = JDom.getElement(root, XDomainConstants.OBJECTNODE);
        }
        return root;
    }

    private Result locate(XUri uri, String str) throws XException {
        return locate(uri, str, null);
    }

    private Result create(XUri uri, String str) throws XException {
        return locate(uri, str, "com.foo.Bar");
    }

    private Result locate(XUri uri, String str, String createClassName) throws XException {
        Result result;

        try {
            result = new Result();
            result.start = JDom.forString(str).getRootElement();
            result.end = XObjectnode.locate(uri, result.start, createClassName);
            return result;
        } catch (IOException e) {
            fail(e.getMessage());
            return null; // dummy
        } catch (JDOMException e) {
            fail(e.getMessage());
            return null; // dummy
        }
    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }

    public static Test suite() {
        return new TestSuite(XObjectnodeTest.class);
    }
}

