/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XStoreAspectsTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.util.XException;
import org.jdom.Element;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XStoreAspectsTest extends TestCase {
    public XStoreAspectsTest(String name) {
        super(name);
    }

    public void testEquals() {
        assertEquals(XStoreAspects.FILE_ASPECTS, XStoreAspects.FILE_ASPECTS);
        assertEquals(XStoreAspects.TAMINO_ASPECTS, XStoreAspects.TAMINO_ASPECTS);
        assertFalse(XStoreAspects.FILE_ASPECTS.equals(XStoreAspects.TAMINO_ASPECTS));
        assertFalse(XStoreAspects.TXFILE_ASPECTS.equals(XStoreAspects.TAMINO_ASPECTS));
    }

    public void testXml() throws XException {
        checkEquals(XStoreAspects.FILE_ASPECTS);
        checkEquals(XStoreAspects.TXFILE_ASPECTS);
        checkEquals(XStoreAspects.TAMINO_ASPECTS);
    }

    public void checkEquals(XStoreAspects orig) throws XException {
        Element store;
        XStoreAspects clone;
        
        store = new Element("store");
        orig.addXml(store);
        clone = XStoreAspects.extractFromXml(store);
        assertEquals(orig, clone);
    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(XStoreAspectsTest.class);
    }
}

