/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XStoreTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.store.XParentStore;
import org.apache.slide.util.JDom;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;
import org.jdom.Element;
import org.jdom.JDOMException;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XStoreTest extends TestCase {
    private XStore store;
    
    public XStoreTest(String name) {
        super(name);
    }
    
    public void testAccessMethods() throws XException {
        final XUri SCOPE = new XUri("/foo");
        Parameters parms;
        
        parms = new Parameters();
        parms.set(XGlobals.TAMINO_BASE, "foo");
        parms.set(XGlobals.TAMINO_COLLECTION, "bar");
        parms.set(XGlobals.TAMINO_DATABASE, "db");
        parms.set(XGlobals.USE_BINDING, "false");
        
        store = new XStore("storeName", "className",
                                      XStoreAspects.TAMINO_ASPECTS, parms, SCOPE);
        assertEquals("storeName", store.getName());
        assertEquals("className", store.getParentStoreClass());
        assertEquals(SCOPE, store.getScope());
        assertEquals("foo", store.getTaminoBase());
        assertEquals("bar", store.getTaminoCollection());
        assertEquals("db", store.getTaminoDatabase());
        assertFalse(store.useBinding());
    }

    public void testFromXml() throws JDOMException, XException, IOException {
        final String STORE =
          "<store name='myName' classname='myClass'>\n" +
          "  <parameter name='foo'>bar</parameter>\n" +
          "</store>";
        final String SCOPES =
          "<scopes>\n" +
          "  <scope store='myName' match='/myScope'/>\n" +
          "</scopes>";
            
        Element element;
        XStore store;
        int oldCount;
        Element scopes;
        
        element = JDom.forString(STORE).getRootElement();
        scopes = JDom.forString(SCOPES).getRootElement();
        XStoreAspects.TAMINO_ASPECTS.addXml(element);
        oldCount = element.getChildren().size();
        store = XStore.extractFromXml(element, scopes.getChildren());
        assertEquals(oldCount, element.getChildren().size());
        assertEquals("myName", store.getName());
        assertEquals("myClass", store.getParentStoreClass());
        assertEquals("bar", store.getParameter("foo"));
        assertEquals("/myScope", store.getScope().toString());
        assertEquals(XStoreAspects.TAMINO_ASPECTS, store.getAspects());
    }
    
    public void testFromXmlNoScope() throws JDOMException, XException, IOException {
        final String STORE =
          "<store name='myName' classname='myClass'>\n" +
          "  <parameter name='foo'>bar</parameter>\n" +
          "</store>";
            
        Element element;
        
        element = JDom.forString(STORE).getRootElement();
        XStoreAspects.TAMINO_ASPECTS.addXml(element);
        try {
            store = XStore.extractFromXml(element, new ArrayList());
            fail();
        } catch (XException e) {
            // ok
        }
    }
    
    public void testAddXml() throws XException {
        Element data;
        Element on;
        Element definition;
        XUri scope;
        
        data = new Element("data");
        on = new Element("objectnode");
        on.setAttribute("uri", "/");
        data.addContent(on);
        definition = new Element("definition");
        scope = new XUri("foo/bar");
        store = new XStore("someStoreName", XParentStore.class.getName(),
                                  XStoreAspects.TAMINO_ASPECTS, new Parameters(), scope);
        store.addXmlDefinition(definition);
        store.addXmlData(data);
        assertNull(XObjectnode.locate(scope, data, null));
        assertEquals(1, definition.getChildren("store").size());
        assertEquals(1, definition.getChildren("scope").size());
    }
    
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(XStoreTest.class);
    }
    
}

