/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XStoreTypeTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XStoreTypeTest extends TestCase {
    private XStoreTypeList types;
    private XStore store;
    
    public XStoreTypeTest(String name) {
        super(name);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
        types = XDomainConfig.createDefault().createTypes().types;
    }
    
    public void testLookup() throws XException {
        int i;
        XStoreType type;
        
        for (i = 0; i < types.all.length; i++) {
            type = types.all[i];
            assertSame(type, types.lookup(type.create("foo")));
        }
    }
    
    public void testScope() throws XException {
        assertEquals(new XUri("foo"), types.userNormal.create("foo").getScope());
        assertEquals(new XUri("history/foo"), types.userHistory.create("foo").getScope());
        assertEquals(new XUri("administration/security/userdb/roles"), types.secUrmRoles.create("ignored").getScope());
    }
    
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(XStoreTypeTest.class);
    }
    
}

