/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/common/impl/TestURMConfiguratorXML.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.common.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMConfiguratorXML extends TestCase {

    public TestURMConfiguratorXML(String name) throws Exception {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestURMConfiguratorXML.class);
    }

    public void test1_configuratorOutputStreamEquals() throws Exception {
        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();
        FileOutputStream fos = new FileOutputStream("testsuite/junit/URM_junit_created_ConfigurationLdap1.xml");
        conf.getConfiguratorAsStream(fos);
        fos.close();
        fis = new FileInputStream("testsuite/junit/URM_junit_created_ConfigurationLdap1.xml");
        URMConfigurator confcopy = new URMConfiguratorXML(fis);
        fis.close();
        assertTrue("Difference can be found between the original and the copy instance of the same configurator.", conf.equals(confcopy));
        
        File file = new File("testsuite/junit/URM_junit_created_ConfigurationLdap1.xml");
        file.delete();
    }

    public void test2_configuratorEqualCrossCheckModifyPropery() throws Exception {
        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();
        String subattrs = "Authenticator/Administrator/Attributes";
        URMConfigurator mconf = conf.getSubConfigurator(subattrs);
        assertNotNull("Cannot find the '"+subattrs+"' for the cross-check.", mconf);
        Object obj = mconf.getSubConfigurators().get("Attribute");
        assertNotNull("Cannot find the '"+subattrs+"/Attribute' for the cross-check.", obj);
        if (obj instanceof List)
            mconf = (URMConfigurator)((List)obj).get(0);
        else
            mconf = (URMConfigurator)obj;
        mconf.setPropery("value", "URM_Configurator_OutputStream_test_cross_check");
        FileOutputStream fos = new FileOutputStream("testsuite/junit/URM_junit_created_ConfigurationLdap2.xml");
        conf.getConfiguratorAsStream(fos);
        fos.close();
        // reread from the files and compare
        fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        conf = new URMConfiguratorXML(fis);
        fis.close();
        fis = new FileInputStream("testsuite/junit/URM_junit_created_ConfigurationLdap2.xml");
        mconf = new URMConfiguratorXML(fis);
        fis.close();
        assertFalse("Difference cannot be found between the original and the modified instance of the configurator.", conf.equals(mconf));
        File file = new File("testsuite/junit/URM_junit_created_ConfigurationLdap2.xml");
        file.delete();
    }

    public void test3_configuratorEqualCrossCheckRemoveNode() throws Exception {
        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();
        String subnode = "Authenticator/Administrator";
        URMConfigurator mconf = conf.getSubConfigurator(subnode);
        assertNotNull("Cannot find the '"+subnode+"' for the cross-check.", mconf);
        Object obj = mconf.removeSubConfigurator("RoleManager");
        assertNotNull("Cannot remove the '"+subnode+"/RoleManager' for the cross-check.", obj);
        FileOutputStream fos = new FileOutputStream("testsuite/junit/URM_junit_created_ConfigurationLdap3.xml");
        conf.getConfiguratorAsStream(fos);
        fos.close();
        // reread from the files and compare
        fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        conf = new URMConfiguratorXML(fis);
        fis.close();
        fis = new FileInputStream("testsuite/junit/URM_junit_created_ConfigurationLdap3.xml");
        mconf = new URMConfiguratorXML(fis);
        fis.close();
        assertFalse("Difference cannot be found between the original and the modified instance of the configurator.", conf.equals(mconf));
        File file = new File("testsuite/junit/URM_junit_created_ConfigurationLdap3.xml");
        file.delete();
    }

    public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestURMConfiguratorXML.class.getName() };
        
        org.apache.log4j.PropertyConfigurator.configure("testsuite/junit/log4j.properties");
        
        junit.textui.TestRunner.main(testCaseName);
    }
}
