/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/TestURMAclAdministrator.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.test.accesscontroler;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAce;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.accesscontroler.URMActionInUseException;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.impl.URMSubjectImpl;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMConfigurationException;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMAclAdministrator extends TestCase{
    
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "Class";
    
    private URMAclAdministrator mAclAdmin = null;
    
    public TestURMAclAdministrator(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestURMAclAdministrator.class);
    }
    
    public URMAuthenticator mAuthenticator = null;
    
    public void test_createActions() throws Exception {
        
        String uniqueId = null;

        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();

        conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
        //System.out.println(conf.toString());
        
        URMAuthenticator authenticator = URMAuthenticator.newInstance(conf);
        URMPrincipal princ = authenticator.authenticateUser("testuser01", "testuser01".toCharArray());
        princ.setActiveRole(URMConstants.URM_ADMIN_ROLE);

        System.out.println("\n" + princ.getProperties());
    
        URMAclAdministrator mAclAdmin = princ.getURMAclAdministrator();
        URMAdministrator mAdmin = princ.getURMAdministrator();
         
        URMSubject subjectAdmin = new URMSubjectImpl("Administrator",
                                                     URMConstants.ROLE,
                                                     null);
/*
        try {
            List inActs = new ArrayList();
            inActs.add("Action1");
            inActs.add("Action2");
            List ret = mAclAdmin.getAclsWithSpecificAction("ResId1/ResId2/ResId3", inActs);
        } catch (Exception e) {
            System.out.println("Shit");
        }
*/
        try {
            URMAction act1 = mAclAdmin.createAction("BaseAction1");
            mAclAdmin.beginTransaction();
            URMAction act2 = mAclAdmin.createAction("BaseAction2");
            URMAction act3 = mAclAdmin.createAction("BaseAction3");
            mAclAdmin.endTransaction(false);
            mAclAdmin.beginTransaction();
            act2 = mAclAdmin.createAction("BaseAction2");
            act3 = mAclAdmin.createAction("BaseAction3");
            mAclAdmin.endTransaction(true);
            URMAction act4 = mAclAdmin.createAction("TestAction1");
            act4.addAction("BaseAction1");
            act4.addAction("BaseAction2");
            try {
                act4.addAction("BaseAction2");
            } catch (URMInsertException e) {
                System.out.println("exception caught correctly: AddBaseAction");
            }
            act4.addAction("BaseAction3");
            try {
                act3.addAction("TestAction1");
            } catch (URMInsertException e) {
                System.out.println("eception caught correctly: add aggregated base action is forbidden");
            }
            act4 = mAclAdmin.getAction("TestAction1");
            Set set1 = act4.getBaseActions();
            Iterator iter1 = set1.iterator();
            while (iter1 != null && iter1.hasNext()) {
                System.out.println("TestAction1 has base action: " + iter1.next().toString());
            }
            URMAction act5 = mAclAdmin.getAction("TestAction1");
            set1 = act5.getBaseActions();
            iter1 = set1.iterator();
            while (iter1 != null && iter1.hasNext()) {
                System.out.println("TestAction1 has base action: " + iter1.next().toString());
            }
            
            Set set2 = mAclAdmin.getAllActions();
            Iterator iter2 = set2.iterator();
            while (iter2 != null && iter2.hasNext()) {
                URMAction act6 = (URMAction)iter2.next();
                System.out.println("Get all actions returns: " + act6.getName());
                Set set3 = act6.getBaseActions();
                if (set3 != null) {
                    Iterator iter3 = set3.iterator();
                    while (iter3 != null && iter3.hasNext()) {
                        System.out.println("    ... with base actions: " + iter3.next());
                    }
                }
            }
            
        } catch (Exception e) {
            System.out.println("Exception caught: " +e.getMessage());
        }
    }

    public void test_createAcl() throws Exception {
        
        String uniqueId = null;

        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();

        conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
        //System.out.println(conf.toString());
        
        URMAuthenticator authenticator = URMAuthenticator.newInstance(conf);
        URMPrincipal princ = authenticator.authenticateUser("testuser01", "testuser01".toCharArray());
        princ.setActiveRole(URMConstants.URM_ADMIN_ROLE);

        System.out.println("\n" + princ.getProperties());
    
        URMAclAdministrator mAclAdmin = princ.getURMAclAdministrator();
        URMAdministrator mUserDBAdmin = princ.getURMAdministrator();
         
        URMSubject subjectAdmin = new URMSubjectImpl("Administrator",
                                                     URMConstants.ROLE,
                                                     null);
        
        URMAdministrator mAdmin = princ.getURMAdministrator();
        URMAcl acl1 = null;
        try {
            acl1 = mAclAdmin.getAcl(uniqueId);
        } catch (Exception e) {
            System.out.println("Acl does not exist....");
        }
        System.out.println("acl1: " + acl1);
        URMUser usrA = mAdmin.getUser("testuser01", null);
        uniqueId = mAclAdmin.createAcl("UniqueId001", usrA, /* subjectAdmin*/ true);
        
        try {
            acl1 = mAclAdmin.getAcl(uniqueId);
            mAdmin.createRole("Administrator");
        } catch (Exception e) {
            System.out.println("To be removed later XXX....");
        }
        if (acl1 != null) {
            URMUser usr1 = mUserDBAdmin.getUser("testuser01", null);
            URMRole usr2 = mUserDBAdmin.getRole("Administrator");
            URMGroup usr3 = mUserDBAdmin.getGroup("testgrp01", null);
            URMAction act1 = mAclAdmin.getAction("TestAction1");
            URMAction act2 = mAclAdmin.getAction("BaseAction2");
            URMAction act3 = mAclAdmin.getAction("BaseAction3");
            if (usr1 != null &&
                usr2 != null &&
                usr3 != null &&
                act1 != null &&
                act2 != null &&
                act3 != null) {
                acl1.defineAce(URMConstants.GRANT,
                               usr1,
                               act1, 0, false);
                acl1.defineAce(URMConstants.GRANT,
                               usr2,
                               act2, 1, false);
                acl1.defineAce(URMConstants.DENY,
                               usr3,
                               act3, 0, false);
                }

            // acl1.setInheritable(true);
        }
        
        try {
            mAclAdmin.createAcl("A", usrA, true);
            mAclAdmin.createAcl("B", usrA, true);
            mAclAdmin.createAcl("C", usrA, true);
            mAclAdmin.createAcl("D", usrA, true);
            mAclAdmin.createAcl("E", usrA, true);
        } catch (Exception e) {
        }

        List aces = new ArrayList(5);
        aces.add("UniqueId001"); aces.add("B"); aces.add("C"); aces.add("D"); aces.add("E");
        
        mAclAdmin.getAclPath(aces);
        

        try {
            acl1 = mAclAdmin.getAcl(uniqueId);
            List list1 = acl1.getAllAces();
            Iterator iter1 = list1.iterator();
            while (iter1 != null && iter1.hasNext()) {
                URMAction act1 = ((URMAce)iter1.next()).getAction();
                Set set1 = act1.getBaseActions();
                Iterator iter2 = set1.iterator();
                while(iter2 != null && iter2.hasNext()) {
                    System.out.println("Base Actions: " + ((String)iter2.next()));
                }
                System.out.println("Acl " + acl1.getId() + "has ACE " + act1.getName());
            }
        } catch (Exception e) {
            System.out.println("Unexpetced exception (1)!");
        }

        System.out.print("createAcl method: " + uniqueId);
        
    }

    public void test_delete() throws Exception {
        
        String uniqueId = null;

        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdap.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();

        conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
        //System.out.println(conf.toString());
        
        URMAuthenticator authenticator = URMAuthenticator.newInstance(conf);
        URMPrincipal princ = authenticator.authenticateUser("testuser01", "testuser01".toCharArray());
        princ.setActiveRole(URMConstants.URM_ADMIN_ROLE);

        System.out.println("\n" + princ.getProperties());
    
        URMAdministrator mAdmin = princ.getURMAdministrator();
        URMAclAdministrator mAclAdmin = princ.getURMAclAdministrator();

        URMSubject subjectAdmin = new URMSubjectImpl("Administrator",
                                                     URMConstants.ROLE,
                                                     null);
        try {
            try {
                mAclAdmin.deleteAction("BaseAction1");
            } catch (URMActionInUseException e) {
                System.out.println("Exception caught correctly: deleteAction1");
            }
            
            URMAcl acl1 = null;
            try {
                acl1 = mAclAdmin.getAcl("UniqueId001");
            } catch (Exception e) {
                System.out.println("Unexpected exception (2)!");
            }
            
            try {
                acl1.removeAce(0);
            } catch (RuntimeException e){
                System.out.println("HuHU");
            }
            
            mAclAdmin.deleteAcl("A");
            mAclAdmin.deleteAcl("B");
            mAclAdmin.deleteAcl("C");
            mAclAdmin.deleteAcl("D");
            mAclAdmin.deleteAcl("E");

            mAclAdmin.deleteAcl("UniqueId001");
            mAclAdmin.deleteAction("TestAction1");
            mAclAdmin.deleteAction("BaseAction1");
            mAclAdmin.deleteAction("BaseAction2");
            mAclAdmin.deleteAction("BaseAction3");
            mAdmin.deleteRole("Administrator");
        } catch (Exception e) {
            throw new URMConfigurationException("Cannot instantiate semantic class");
        }
        System.out.print("deleteAcl called.");
        
    }
         
    public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestURMAclAdministrator.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
    }
}
