/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/TestURMCache.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAclValidator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMCache extends TestCase{
    
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "Class";
    private static URMAuthenticator authenticator = null;
    public TestURMCache(String name) throws Exception {
        super(name);
        if (authenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            authenticator = URMAuthenticator.newInstance(conf);
        }
    }

    public static Test suite() {
        return new TestSuite(TestURMCache.class);
    }


    public void test_accessCheck_1_10_Grant_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("13");
        uri.add("1");

        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_10_Deny_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("13");
        uri.add("1");

        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        URMAclAdministrator acladmin = principal.getURMAclAdministrator();
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMUser urmUser = urmadmin.getUser(user,null);
        acladmin.createAcl("13", urmUser,true);
        URMAcl acl10 = acladmin.getAcl("13");
        URMAction readAction = acladmin.getAction("Read");
        acl10.defineAce(URMConstants.DENY,urmUser,readAction,0,false);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        principal = principal.copyPrincipal(null);
        try {
            
            result = mAclValidator.accessCheck(principal,uri,action);
            acladmin.deleteAcl("13");
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }


        public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestURMCache.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
     }
     

      
}



