/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/TestURMValidator.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAclValidator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.accesscontroler.URMPermissionResult;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMValidator extends TestCase{
    
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "Class";
    private static URMAuthenticator authenticator = null;
    public TestURMValidator(String name) throws Exception {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestURMValidator.class);
    }

    String ldapadmin = "usr";
    
    String user1 = "user1";
    String user2 = "user2";
    String user3 = "user3";
    String user4 = "user4";
    String user5 = "user5";
    
    String employee = "Employee";
    String developer = "Developer";
    String administrator = "Administrator";
    
    String admins = "Admins";
    
    String read = "Read";
    String write = "Write";
    String create = "Create";
    String delete = "Delete";
    String execute = "Execute";
    String review = "Review";
    String admin = "Admin";
    
    String displayname = "displayname";
    
    String acl1 = "1";
    String acl2 = "2";
    String acl3 = "3";
    String acl4 = "4";
    String acl5 = "5";
    String acl6 = "6";
    String acl7 = "7";
    String acl8 = "8";
    String acl9 = "9";
    String acl10 = "10";
    String acl11 = "11";
    String acl13 = "13";
    
    String notes = "notes";
    
    int end = 100;


        
    public void test_create_testenvironment() throws Exception {
    try {
        int result = 0;
            
        List uri = new ArrayList();
        URMInit.init(false, ldapadmin, null);
        URMPrincipal principal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator acladmin = principal.getURMAclAdministrator();
        
        // create users, groups and roles
        urmadmin.createUser(user1, user1.toCharArray(), null);
        URMUser _user1 = urmadmin.getUser(user1, null);
        _user1.setProperty(displayname, user1);
        _user1.setProperty(notes, user1);
        assertEquals((String) _user1.getProperty(notes), user1);
        _user1.linkToRole(URMConstants.URM_ADMIN_ROLE);
        urmadmin.createUser(user2, user2.toCharArray(), null);
        URMUser _user2 = urmadmin.getUser(user2, null);
        _user2.setProperty(displayname, user1);
        urmadmin.createUser(user3, user3.toCharArray(), null);
        URMUser _user3 = urmadmin.getUser(user3, null);
        _user3.setProperty(displayname, user1);
        urmadmin.createUser(user4, user4.toCharArray(), null);
        URMUser _user4 = urmadmin.getUser(user4, null);
        _user4.setProperty(displayname, user1);
        urmadmin.createUser(user5, user5.toCharArray(), null);
        URMUser _user5 = urmadmin.getUser(user5, null);
        _user5.setProperty(displayname, user1);
        
        urmadmin.createRole(employee);
        urmadmin.createRole(developer);
        urmadmin.createRole(administrator);
        
        urmadmin.createGroup(admins, null);
        URMGroup _admins = urmadmin.getGroup(admins, null);
//        _admins.addUserToGroup(user2, null);
        _admins.addUserToGroup(user5, null);
        _admins.setProperty(displayname, admins);
        
        // create actions
        acladmin.createAction(read);
        acladmin.createAction(write);
        acladmin.createAction(delete);
        acladmin.createAction(create);
        acladmin.createAction(execute);
        acladmin.createAction(review);
        acladmin.createAction(admin);
        
        // do action mapping
        URMAction _review = acladmin.getAction(review);
        _review.addAction(read);
        _review.addAction(write);
        
        // do action mapping
        URMAction _admin = acladmin.getAction(admin);
        _admin.addAction(read);
        _admin.addAction(write);
        _admin.addAction(delete);
        _admin.addAction(create);
        
        // do role mapping
        URMRole _employee = urmadmin.getRole(employee);
        _employee.addUserLink(user1, null);
        _employee.addUserLink(user3, null);
        _employee.addUserLink(user4, null);
        
        URMRole _developer = urmadmin.getRole(developer);
        _developer.addUserLink(user2, null);
        _developer.addAncestor(employee);
                
        URMRole _administrator = urmadmin.getRole(administrator);
        _administrator.addGroupLink(admins, null);
        _administrator.addAncestor(employee);
        _administrator.setPredefinedAction(admin, new Boolean(true));
        
        // create acls
        acladmin.createAcl(acl1,_user1,true);
        acladmin.createAcl(acl2,_user1,true);
        acladmin.createAcl(acl3,_user1,true);
        acladmin.createAcl(acl4,_user1,true);
        acladmin.createAcl(acl5,_user1,true);
        acladmin.createAcl(acl6,_user1,true);
        acladmin.createAcl(acl7,_user1,true);
        acladmin.createAcl(acl8,_user1,true);
        acladmin.createAcl(acl9,_user1,true);
        acladmin.createAcl(acl10,_user1,true);
        acladmin.createAcl(acl11,_user1,true);
        acladmin.createAcl(acl13,_user1,true);
        
        // define aces
        URMAcl _acl1 = acladmin.getAcl(acl1);
        _acl1.defineAce(URMConstants.GRANT,_employee,_admin,end,false);
        _acl1.defineAce(URMConstants.GRANT,_admins,_admin,end,false);
        
        URMAction _read = acladmin.getAction(read);
        URMAcl _acl2 = acladmin.getAcl(acl2);
        _acl2.defineAce(URMConstants.DENY,_employee,_read,end,false);
        
        URMAcl _acl3 = acladmin.getAcl(acl3);
        _acl3.defineAce(URMConstants.GRANT,_developer,_read,end,false);
        
        URMAcl _acl4 = acladmin.getAcl(acl4);
        _acl4.defineAce(URMConstants.DENY,_administrator,_read,end,false);
        _acl4.defineAce(URMConstants.DENY,_developer,_read,end,false);
        _acl4.defineAce(URMConstants.DENY,_employee,_read,end,false);
        
        URMAcl _acl5 = acladmin.getAcl(acl5);
        _acl5.defineAce(URMConstants.GRANT,_employee,_read,end,false);
        _acl5.defineAce(URMConstants.DENY,_employee,_read,end,false);
            
        URMAcl _acl6 = acladmin.getAcl(acl6);
        _acl6.defineAce(URMConstants.GRANT,_user4,_review,end,false);
        _acl6.defineAce(URMConstants.GRANT,_user2,_read,end,false);
        _acl6.defineAce(URMConstants.DENY,_user4,_read,end,false);
     
        URMAcl _acl7 = acladmin.getAcl(acl7);
        _acl7.defineAce(URMConstants.DENY,_user1,_read,end,true);
            
        URMAcl _acl8= acladmin.getAcl(acl8);
        _acl8.defineAce(URMConstants.GRANT,_user2,_read,end,false);
            
        URMAcl _acl9 = acladmin.getAcl(acl9);
        _acl9.defineAce(URMConstants.GRANT,_employee,_read,end,false);
        _acl9.defineAce(URMConstants.DENY,_employee,_read,end,false);
            
        URMAcl _acl10= acladmin.getAcl(acl10);
        _acl10.defineAce(URMConstants.GRANT,urmadmin.getALLSubject(),acladmin.getAction(URMConstants.URM_ALL_ACTION),end,false);
            
        URMAcl _acl11= acladmin.getAcl(acl11);
        _acl11.defineAce(URMConstants.DENY,_user1,_read,end,false);
            
        URMAcl _acl13= acladmin.getAcl(acl13);
        _acl13.defineAce(URMConstants.DENY,_admins,_read,end,false);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void test_accessCheck_not_existing_acl_Admin() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("42");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_not_existing_acl_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("42");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMIndeterminate, result);
    }
    
    // test the URMGuest account
    public void test_accessCheck_1_Guest() throws Exception {

        int result = 0;
        String action = "Review";
        List uri = new ArrayList();
        uri.add("1");
        
        URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
        conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
        
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        try {
            result = mAclValidator.accessCheck(null,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMIndeterminate, result);
    }
    
    public void test_accessCheck_1_Admin() throws Exception {

        int result = 0;
        String action = "Review";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
//        principal.getURMAclAdministrator().addTransientEmptyAcl("1");
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        // Deny because of Review is not part of Admin action
        assertEquals(URMAclValidator.URMIndeterminate, result);
    }
    
    public void test_accessCheck_1_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_2_3_Admin() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Throwable e) {
            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_2_3_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");

        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }


    public void test_accessCheck_1_2_3_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }

    public void test_accessCheck_1_2_Admin() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_2_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
    public void test_accessCheck_1_2_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
    // predefined action (admin:read) over ace (admin: deny read)
    public void test_accessCheck_1_4_Admin() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("4");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_4_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("4");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
    public void test_accessCheck_1_4_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
        public void test_accessCheck_1_5_Admin() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_5_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_5_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("5");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_5_6_Admin() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("6");
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    
    public void test_accessCheck_1_5_6_Developer() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("6");
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }

    // test ace order ACE1: read, ACE2: deny read
    public void test_accessCheck_1_5_6_Employee() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("6");
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    // test aggregated Action test parent action
    public void test_accessCheck_1_5_6_AggregatedAction() throws Exception {
        
        int result = 0;
        String action = "Review";
        String user = "user4";
        List uri = new ArrayList();
        uri.add("6");
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
        // test aggregated Action test child action
    public void test_accessCheck_1_5_6_AggregatedAction_child() throws Exception {
        
        int result = 0;
        String action = "Read";
        String user = "user4";
        List uri = new ArrayList();
        uri.add("6");
        uri.add("5");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }

        public void test_accessCheck_1_7_InvertAce_User1() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_accessCheck_1_7_InvertAce_All() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("7");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
    
    public void test_accessCheck_10_11_12_user1() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("12");
        uri.add("11");
        uri.add("10");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        principal.getURMAclAdministrator().addTransientEmptyAcl("12");
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
        public void test_accessCheck_10_11_12_user2() throws Exception {

        int result = 0;
        String action = "Read";
        String user = "user2";
        List uri = new ArrayList();
        uri.add("12");
        uri.add("11");
        uri.add("10");

        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        principal.getURMAclAdministrator().addTransientEmptyAcl("12");
        try {
            result = mAclValidator.accessCheck(principal,uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_subjectPermissionReportRoleDeny() throws Exception {

        int result = 0;
        String action = "Read";
        List uri = new ArrayList();
        uri.add("4");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        
        try {
            result = aclAdmin.subjectPermissionReport(principal,urmAdmin.getRole(employee),uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
    public void test_subjectPermissionReportRolePermit() throws Exception {

        int result = 0;
        String action = "Read";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        
        try {
            result = aclAdmin.subjectPermissionReport(principal,urmAdmin.getRole(employee),uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_subjectPermissionReportUserDeny() throws Exception {

        int result = 0;
        String action = "Read";
        List uri = new ArrayList();
        uri.add("4");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        
        try {
            result = aclAdmin.subjectPermissionReport(principal,urmAdmin.getUser(user3, null),uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
    public void test_subjectPermissionReportUserPermit() throws Exception {

        int result = 0;
        String action = "Read";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        
        try {
            result = aclAdmin.subjectPermissionReport(principal,urmAdmin.getUser(user3, null),uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
   
    public void test_subjectPermissionReportGroupDeny() throws Exception {

        int result = 0;
        String action = "Read";
        List uri = new ArrayList();
        uri.add("13");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        
        try {
            result = aclAdmin.subjectPermissionReport(principal,urmAdmin.getGroup(admins, null),uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMDeny, result);
    }
    
        public void test_subjectPermissionReportGroupPermit() throws Exception {

        int result = 0;
        String action = "Read";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        
        try {
            result = aclAdmin.subjectPermissionReport(principal,urmAdmin.getGroup(admins, null),uri,action);
        } catch (Exception e) {
//            e.printStackTrace();
            result = -1;
        }
        assertEquals(URMAclValidator.URMPermit, result);
    }
    
    public void test_1_2_3_getUserWithPermissionReport() throws Exception {
        //URMInit.init();
        Set result = null;
        String user = "user1";
        Set reference = new HashSet();
        String action = "Read";
        reference.add("user2");
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.userWithPermissionReport(principal,action,uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String key = ((URMUser) iter.next()).getName();
            assertEquals(key, reference.contains(key), true);
        }
        
        Iterator refiter = reference.iterator();
        while (refiter.hasNext()) {
            String key = (String) refiter.next();
            Iterator userIter = result.iterator();
            URMUser currentuser = null;
            while ((currentuser == null) && userIter.hasNext()) {
                URMUser help = (URMUser) userIter.next();
                if (help.getName().equals(key)) currentuser = help;
            }
            assertEquals(key, (currentuser != null), true);
        }
    }

        public void test_1_2_getUserWithPermissionReport() throws Exception {

        Set result = null;
        String user = "user1";
        Set reference = new HashSet();
        String action = "Review";
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.userWithPermissionReport(principal,action,uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String key = ((URMUser) iter.next()).getName();
            assertEquals(key, reference.contains(key), true);
        }
        
        Iterator refiter = reference.iterator();
        while (refiter.hasNext()) {
            String key = (String) refiter.next();
            Iterator userIter = result.iterator();
            URMUser currentuser = null;
            while ((currentuser == null) && userIter.hasNext()) {
                URMUser help = (URMUser) userIter.next();
                if (help.getName().equals(key)) currentuser = help;
            }
            assertEquals(key, (currentuser != null), true);
        }
    }
    
    public void test_1_getUserWithPermissionReport() throws Exception {

        Set result = null;
        String user = "user1";
        Set reference = new HashSet();
        String action = "Read";
        reference.add("user1");
        reference.add("user2");
        reference.add("user3");
        reference.add("user4");
        reference.add("user5");
        List uri = new ArrayList();
        uri.add("1");
 
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.userWithPermissionReport(principal,action,uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String key = ((URMUser) iter.next()).getName();
            assertEquals(key, reference.contains(key), true);
        }
        
        Iterator refiter = reference.iterator();
        while (refiter.hasNext()) {
            String key = (String) refiter.next();
            Iterator userIter = result.iterator();
            URMUser currentuser = null;
            while ((currentuser == null) && userIter.hasNext()) {
                URMUser help = (URMUser) userIter.next();
                if (help.getName().equals(key)) currentuser = help;
            }
            assertEquals(key, (currentuser != null), true);
        }
    }
    
    
    public void test_1_2_3_UserPermissionReport_Employee() throws Exception {

        Map result = null;
        String user = "user1";
        String domain = null;
        Map reference = new HashMap();
        reference.put("Admin", new Integer(URMAclValidator.URMPermit));
        reference.put("Read", new Integer(URMAclValidator.URMDeny));
        reference.put("Write", new Integer(URMAclValidator.URMPermit));
        reference.put("Create", new Integer(URMAclValidator.URMPermit));
        reference.put("Delete", new Integer(URMAclValidator.URMPermit));
        reference.put("Review", new Integer(URMAclValidator.URMDeny));
        reference.put("ALLAction", new Integer(URMAclValidator.URMDeny));
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.subjectPermissionSetReport(principal, urmadmin.getUser(user,null),uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            assertEquals(key, reference.get(key), new Integer(((URMPermissionResult)result.get(key)).getPermission()));
        }
    }
    
    public void test_1_2_3_UserPermissionReport_Employee_role() throws Exception {

        Map result = null;
        Map reference = new HashMap();
        reference.put("Admin", new Integer(URMAclValidator.URMPermit));
        reference.put("Read", new Integer(URMAclValidator.URMDeny));
        reference.put("Write", new Integer(URMAclValidator.URMPermit));
        reference.put("Create", new Integer(URMAclValidator.URMPermit));
        reference.put("Delete", new Integer(URMAclValidator.URMPermit));
        reference.put("Review", new Integer(URMAclValidator.URMDeny));
        reference.put("ALLAction", new Integer(URMAclValidator.URMDeny));
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.subjectPermissionSetReport(principal, urmadmin.getRole(employee),uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            assertEquals(key, reference.get(key), new Integer(((URMPermissionResult)result.get(key)).getPermission()));
        }
    }
    
        public void test_1_2_UserPermissionReport_Employee() throws Exception {

        Map result = null;
        String user = "user1";
        String domain = null;
        Map reference = new HashMap();
        reference.put("Admin", new Integer(URMAclValidator.URMPermit));
        reference.put("Read", new Integer(URMAclValidator.URMDeny));
        reference.put("Write", new Integer(URMAclValidator.URMPermit));
        reference.put("Create", new Integer(URMAclValidator.URMPermit));
        reference.put("Delete", new Integer(URMAclValidator.URMPermit));
        reference.put("Review", new Integer(URMAclValidator.URMDeny));
        reference.put("ALLAction", new Integer(URMAclValidator.URMDeny));
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.subjectPermissionSetReport(principal, urmadmin.getUser(user,null),uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            assertEquals(key, reference.get(key), new Integer(((URMPermissionResult)result.get(key)).getPermission()));
        }
    }
    
    public void test_1_2_UserPermissionReport_Employee_role() throws Exception {

        Map result = null;
        Map reference = new HashMap();
        reference.put("Admin", new Integer(URMAclValidator.URMPermit));
        reference.put("Read", new Integer(URMAclValidator.URMDeny));
        reference.put("Write", new Integer(URMAclValidator.URMPermit));
        reference.put("Create", new Integer(URMAclValidator.URMPermit));
        reference.put("Delete", new Integer(URMAclValidator.URMPermit));
        reference.put("Review", new Integer(URMAclValidator.URMDeny));
        reference.put("ALLAction", new Integer(URMAclValidator.URMDeny));
        List uri = new ArrayList();
        uri.add("2");
        uri.add("1");
 
        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.subjectPermissionSetReport(principal, urmadmin.getRole(employee),uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            assertEquals(key, reference.get(key), new Integer(((URMPermissionResult)result.get(key)).getPermission()));
        }
    }
        
    // has to be fixed by Dieter
    public void test_1_2_3_UserPermissionReport_Developer_role() throws Exception {

        Map result = null;
        Map reference = new HashMap();
        reference.put("Admin", new Integer(URMAclValidator.URMPermit));
        reference.put("Read", new Integer(URMAclValidator.URMPermit));
        reference.put("Write", new Integer(URMAclValidator.URMPermit));
        reference.put("Create", new Integer(URMAclValidator.URMPermit));
        reference.put("Delete", new Integer(URMAclValidator.URMPermit));
        reference.put("Review", new Integer(URMAclValidator.URMPermit));
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");

        URMPrincipal principal = authenticator.authenticateUser(user1, user1.toCharArray(), null);
        
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.subjectPermissionSetReport(principal, urmadmin.getRole(developer),uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            assertEquals(key, reference.get(key), new Integer(((URMPermissionResult)result.get(key)).getPermission()));
        }
    }
    
        public void test_1_2_3_UserPermissionReport_Developer_user() throws Exception {

        Map result = null;
        String user = "user2";
        String domain = null;
        Map reference = new HashMap();
        reference.put("Admin", new Integer(URMAclValidator.URMPermit));
        reference.put("Read", new Integer(URMAclValidator.URMPermit));
        reference.put("Write", new Integer(URMAclValidator.URMPermit));
        reference.put("Create", new Integer(URMAclValidator.URMPermit));
        reference.put("Delete", new Integer(URMAclValidator.URMPermit));
        reference.put("Review", new Integer(URMAclValidator.URMPermit));
        List uri = new ArrayList();
        uri.add("3");
        uri.add("2");
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator admin = principal.getURMAclAdministrator();
        try {
            result = admin.subjectPermissionSetReport(principal, urmadmin.getUser(user,null),uri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            assertEquals(key, reference.get(key), new Integer(((URMPermissionResult)result.get(key)).getPermission()));
        }
    }
    
    public void test_deletetest_environment() throws Exception {
    try {
        int result = 0;
            
        List uri = new ArrayList();
        URMPrincipal principal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator acladmin = principal.getURMAclAdministrator();
               
        // delete acls
        acladmin.deleteAcl(acl1);
        acladmin.deleteAcl(acl2);
        acladmin.deleteAcl(acl3);
        acladmin.deleteAcl(acl4);
        acladmin.deleteAcl(acl5);
        acladmin.deleteAcl(acl6);
        acladmin.deleteAcl(acl7);
        acladmin.deleteAcl(acl8);
        acladmin.deleteAcl(acl9);
        acladmin.deleteAcl(acl10);
        acladmin.deleteAcl(acl11);
        acladmin.deleteAcl(acl13);

        urmadmin.deleteRole(administrator);
        urmadmin.deleteRole(developer);
        urmadmin.deleteRole(employee);
            
        urmadmin.deleteGroup(admins, null);
            
        urmadmin.deleteUser(user1, null);
        urmadmin.deleteUser(user2, null);
        urmadmin.deleteUser(user3, null);
        urmadmin.deleteUser(user4, null);
        urmadmin.deleteUser(user5, null);
            
        // delete actions
        acladmin.deleteAction(review);
        acladmin.deleteAction(admin);
        acladmin.deleteAction(read);
        acladmin.deleteAction(write);
        acladmin.deleteAction(delete);
        acladmin.deleteAction(create);
        acladmin.deleteAction(execute);

            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
        public static void main(String[] args) throws Exception {
        if (authenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            authenticator = URMAuthenticator.newInstance(conf);
        }
        
        String[] testCaseName = { "-noloading", TestURMValidator.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
        
     }
     

}



