/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/Test_QE_URMAce.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAce;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.impl.URMSubjectImpl;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * Implement the official test cases
 * URMAclAdministrator_0001 - URMAclAdministrator_00..
 */
public class Test_QE_URMAce extends TestCase{
    
    private static URMAuthenticator authenticator = null;
    private static URMAclAdministrator mAclAdmin = null;
    private static URMAdministrator mAdmin = null;
    private static URMPrincipal mPrincipal = null;
    private static URMConfigurator mTestConfigurator = null;
    private static String ldapadmin = "testuser01";

    public Test_QE_URMAce(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Test_QE_URMAce.class);
    }
    
    public URMAuthenticator mAuthenticator = null;
    
    public void test_pre() throws Exception {

        URMInit.init(false, ldapadmin, null);
        mPrincipal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdmin = mPrincipal.getURMAdministrator();
        mAclAdmin = mPrincipal.getURMAclAdministrator();

        // Create all data necessary to start the tests

        try {

            URMAction act1 = mAclAdmin.createAction("B1");
            URMAction act2 = mAclAdmin.createAction("B2");
            URMAction act3 = mAclAdmin.createAction("B3");
            URMAction act4 = mAclAdmin.createAction("A1");
            URMAction act5 = mAclAdmin.createAction("A2");
            act4.addAction("B1");
            act4.addAction("B2");
            act4.addAction("B3");
            
            // Create roles
            URMRole role1 = mAdmin.createRole("role1");
            URMRole role2 = mAdmin.createRole("role2");
            URMRole role3 = mAdmin.createRole("role3");
            
            // User and Groups
            mAdmin.createUser("TestUser_dk1", "TestUser_dk1".toCharArray(), null);
            mAdmin.createUser("TestUser_dk2", "TestUser_dk2".toCharArray(), null);
            mAdmin.createUser("TestUser_dk3", "TestUser_dk3".toCharArray(), null);
            mAdmin.createGroup("TestGroup_dk1", null);
            URMGroup grp1 = mAdmin.getGroup("TestGroup_dk1", null);
            grp1.addUserToGroup("TestUser_dk1", null);
            grp1.addUserToGroup("TestUser_dk2", null);

            // Create Acl/Ace with
            URMSubject ownerSubject= new URMSubjectImpl("testuser01",
                                                         URMConstants.USER,
                                                         null);

            String s1 = mAclAdmin.createAcl("UrmAclId001", ownerSubject, true);
            URMAcl acl1 = mAclAdmin.getAcl("UrmAclId001");
            acl1.defineAce(URMConstants.GRANT, mAdmin.getUser("TestUser_dk2", null),
                                 mAclAdmin.getAction("A1"), 0, false);
            acl1.defineAce(URMConstants.GRANT, mAdmin.getRole("role2"),
                                 mAclAdmin.getAction("B3"), 0, false);
            acl1.defineAce(URMConstants.GRANT, mAdmin.getUser("TestUser_dk1", null),
                                 mAclAdmin.getAction("A2"), 2, true);

            s1 = mAclAdmin.createAcl("UrmAclId002", ownerSubject, true);
            URMAcl acl2 = mAclAdmin.getAcl("UrmAclId002");
            acl2.defineAce(URMConstants.GRANT, mAdmin.getUser("TestUser_dk3", null),
                                 mAclAdmin.getAction("A1"), 0, false);
            acl2.defineAce(URMConstants.DENY, mAdmin.getRole("role2"),
                                 mAclAdmin.getAction("B2"), 1, true);
            acl2.defineAce(URMConstants.GRANT, mAdmin.getGroup("TestGroup_dk1", null),
                                 mAclAdmin.getAction("B1"), 2, true);
            
        } catch (Exception e) {
            System.out.println("Exception caught: " +e.getMessage());
        }
        
    }

    public void test_001() throws Exception {
            
        mPrincipal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdmin = mPrincipal.getURMAdministrator();
        mAclAdmin = mPrincipal.getURMAclAdministrator();

        URMSubject ownerSubject= new URMSubjectImpl("testuser01",
                                                     URMConstants.USER,
                                                     null);

        URMSubject invalidOwner = new URMSubjectImpl("dengibtsnicht",
                                                     URMConstants.USER,
                                                     null);

        // URMAce_0001 all Ace-Methods.
        URMAcl acl1 = mAclAdmin.getAcl("UrmAclId001");

        List l1 = acl1.getAllAces();
        Iterator iter1 = l1.iterator();
        List r1 = new ArrayList();
        r1.add("role2");
        r1.add("TestUser_dk2");
        r1.add("TestUser_dk1");
        List r2 = new ArrayList();
        r2.add("B3");
        r2.add("A1");
        r2.add("A2");
        
        assertEquals(l1.size(), 3);
        while (iter1 != null && iter1.hasNext()) {
            URMAce next = (URMAce)iter1.next();
            String t1 = next.getSubject().getName();
            assertTrue(r1.contains(next.getSubject().getName()));
            String t2 = next.getAction().getName();
            assertTrue(r2.contains(next.getAction().getName()));
        }

        //
        URMAce ace1 = acl1.getAce(2);
        assertTrue(ace1.getSubject().getName().equals("TestUser_dk1"));
        assertTrue(ace1.getAction().getName().equals("A2"));

        //
        r1.clear(); r2.clear();
        r1.add("role2");
        r1.add("TestUser_dk1");
        r2.add("B3");
        r2.add("A2");
        
        acl1.removeAce(1);
        l1 = acl1.getAllAces();
        iter1 = l1.iterator();

        assertEquals(l1.size(), 2);
        while (iter1 != null && iter1.hasNext()) {
            URMAce next = (URMAce)iter1.next();
            assertTrue(r1.contains(next.getSubject().getName()));
            assertTrue(r2.contains(next.getAction().getName()));
        }
        
        // URMAce_0002
        // get type of Ace: DENY
        URMAcl acl2 = mAclAdmin.getAcl("UrmAclId002");
        
        URMAce ace2 = acl2.getAce(1);
        int aType = ace2.getType();
        assertEquals(aType, URMConstants.DENY);
        
        // URMAce_0003
        // get type of Ace: GRANT
        URMAcl acl3 = mAclAdmin.getAcl("UrmAclId002");
        
        URMAce ace3 = acl3.getAce(2);
        aType = ace3.getType();
        assertEquals(aType, URMConstants.GRANT);
        
        // URMAce_0004
        // getSubject from Ace
        String subName = ace3.getSubject().getName();
        int subType = ace3.getSubject().getType();
        assertTrue(subName.equals("TestGroup_dk1"));
        assertEquals(subType, URMConstants.GROUP);
        
        // URMAce_0005
        // getAction from Ace
        String actName = ace3.getAction().getName();
        assertTrue(actName.equals("B1"));

    }
         
    public void test_post() throws Exception {
        
        try {
            mPrincipal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
            mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
            mAdmin = mPrincipal.getURMAdministrator();
            mAclAdmin = mPrincipal.getURMAclAdministrator();

            // Acls
            mAclAdmin.deleteAcl("UrmAclId001");
            mAclAdmin.deleteAcl("UrmAclId002");
            
            // Users and Groups
            URMGroup grp1 = mAdmin.getGroup("TestGroup_dk1", null);
            grp1.removeUserFromGroup("TestUser_dk1", null);
            grp1.removeUserFromGroup("TestUser_dk2", null);
            mAdmin.deleteGroup("TestGroup_dk1", null);
            mAdmin.deleteUser("TestUser_dk1", null);
            mAdmin.deleteUser("TestUser_dk2", null);
            mAdmin.deleteUser("TestUser_dk3", null);

            // Roles
            mAdmin.deleteRole("role1");
            mAdmin.deleteRole("role2");
            mAdmin.deleteRole("role3");

            // Actions
            URMAction act4 = mAclAdmin.getAction("A1");
            act4.removeAction("B1");
            act4.removeAction("B2");
            act4.removeAction("B3");
            mAclAdmin.deleteAction("B1");
            mAclAdmin.deleteAction("B2");
            mAclAdmin.deleteAction("B3");
            mAclAdmin.deleteAction("A1");
            mAclAdmin.deleteAction("A2");

        } catch (Exception e) {
            System.out.println("Exception caught: " +e.getMessage());
        }
        
    }

    public static void main(String[] args) throws Exception {
        if (authenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            authenticator = URMAuthenticator.newInstance(conf);
        }
        
        String[] testCaseName = { "-noloading", Test_QE_URMAce.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
    }
}
