/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/Test_QE_URMAclMultiThreaded.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Test_QE_URMAclMultiThreaded extends TestCase {
    public static final int THREADS_NUMBER = 1;
    public static final int ROUNDS_NUMBER = 1;

    private static URMAuthenticator mAuthenticator = null;
    private static URMAclAdministrator mAclAdmin = null;
    private static URMAdministrator mAdmin = null;
    private static URMPrincipal mPrincipal = null;
    private static URMConfigurator mTestConfigurator = null;
    private static String ldapadmin = "testuser01";


    public Test_QE_URMAclMultiThreaded(String name) throws Exception {
        super(name);
        initUrmTest();
    }
    
    private static synchronized void initUrmTest() throws Exception {
        URMInit.init(false, ldapadmin, null);
        mPrincipal = mAuthenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdmin = mPrincipal.getURMAdministrator();
        mAclAdmin = mPrincipal.getURMAclAdministrator();
        
    }
    
    public static Test suite() {
        return new TestSuite(Test_QE_URMAclMultiThreaded.class);
    }
    
    private void waitForTheEnd(Test_QE_URMAclMultiThreadedBase threads[]) throws InterruptedException {
        for (int i = 0; i < threads.length; ++i)
            threads[i].waitForDie();
    }

    public void test1_createDeleteUsersGroups() throws Exception {
        Test_QE_URMAclMultiThreadedBase queryAclThreads[] = new Test_QE_URMAclMultiThreadedQuery[THREADS_NUMBER];
        // create thread objects
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i] = new Test_QE_URMAclMultiThreadedQuery(mAclAdmin, mAdmin, ROUNDS_NUMBER);

        // create Objects
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startCreate();
        waitForTheEnd(queryAclThreads);  // wait until they finish

        // query Objects
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startCheck();
        waitForTheEnd(queryAclThreads);  // wait until they finish

        // delete Objects
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startClear();
        waitForTheEnd(queryAclThreads);  // wait until they finish
    }

    public void _test2_addRemoveUserToFromGroup() throws Exception {
        // CREATE users and groups
        Test_QE_URMAclMultiThreadedBase queryAclThreads[] = new Test_QE_URMAclMultiThreadedQuery[THREADS_NUMBER];
        // create thread objects
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i] = new Test_QE_URMAclMultiThreadedQuery(mAclAdmin, mAdmin, 20);

            // create user/group entries
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startCreate();
        waitForTheEnd(queryAclThreads); // wait until they finish
            // check user/group entries
        for (int i = 0; i < queryAclThreads.length; ++i)
        queryAclThreads[i].startCheck();
        waitForTheEnd(queryAclThreads);
        
        // ADD/REMOVE user to/from group test
        Test_QE_URMAclMultiThreadedBase threads[] = new Test_QE_URMAclMultiThreadedQuery[THREADS_NUMBER];
        // create thread objects
        for (int i = 0; i < threads.length; ++i)
            threads[i] = new Test_QE_URMAclMultiThreadedQuery(mAclAdmin, mAdmin, 10);
        // all in one
        for (int i = 0; i < threads.length; ++i)
            threads[i].startAll();
        waitForTheEnd(threads);  // wait until they finish

        // CHECK/UPDATE/CLEAR user/group entries
            // check user/group entries
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startCheck();
        waitForTheEnd(queryAclThreads);
            // update user/group entries
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startUpdate();
        waitForTheEnd(queryAclThreads); // wait until they finish
            // remove user/group entries
        for (int i = 0; i < queryAclThreads.length; ++i)
            queryAclThreads[i].startClear();
        waitForTheEnd(queryAclThreads); // wait until they finish
    }
    
    public static void main(String[] args) throws Exception {
        if (mAuthenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            mAuthenticator = URMAuthenticator.newInstance(conf);
        }
        
        String[] testCaseName = { "-noloading", Test_QE_URMAclMultiThreaded.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
    }
}
