/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/Test_QE_URMAclMultiThreadedBase.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.Random;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.authenticator.URMAdministrator;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class Test_QE_URMAclMultiThreadedBase {

    protected URMAclAdministrator mAclAdministrator = null;
    protected URMAdministrator mAdministrator = null;
    protected String           mDomain        = null;
    protected Throwable        mThrowable     = null;
    protected Random           mRandom        = null;
    private Thread             mThread        = null;
    
    public Test_QE_URMAclMultiThreadedBase(URMAclAdministrator aclAdmin, URMAdministrator admin) {
        mAclAdministrator = aclAdmin;
        mAdministrator = admin;
        mRandom = new Random();
    }
    
    private class LocalTestThread extends Thread {
        private int mFlag = 0;
        private Test_QE_URMAclMultiThreadedBase mImpl = null;
    
        public LocalTestThread(Test_QE_URMAclMultiThreadedBase impl, int flag) {
            mImpl = impl;
            mFlag = flag;
        }
    
        /* (non-Javadoc)
         * @see java.lang.Runnable#run()
         */
        public void run() {
            switch (mFlag) {
                case 1:  mImpl.create();
                         break;
                case 2:  mImpl.update();
                         break;
                case 3:  mImpl.check();
                         break;
                case 4:  mImpl.clear();
                         break;
                default: mImpl.create(); mImpl.check(); mImpl.update(); mImpl.check(); mImpl.clear();
                         break;
            }
        }

    }
    
    public void startCreate() {
        (mThread = new LocalTestThread(this, 1)).start();
    }
    
    public void startUpdate() {
        (mThread = new LocalTestThread(this, 2)).start();
    }
    
    public void startCheck() {
        (mThread = new LocalTestThread(this, 3)).start();
    }
    
    public void startClear() {
        (mThread = new LocalTestThread(this, 4)).start();
    }
    
    public void startAll() {
        (mThread = new LocalTestThread(this, 0)).start();
    }
    
    public Thread getThread() {
        return mThread;
    }
    
    public Throwable getError() {
        return mThrowable;
    }

    public void waitForDie() {
        Thread lthread = mThread;
        mThread = null;
        while (lthread.isAlive())
            Thread.yield();
            try {
                lthread.join(/*100*/);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        //System.out.println("Thread '"+lthread.getName()+"' died.");
        lthread = null;
    }
    
    protected abstract void create();

    protected abstract void update();

    protected abstract void check();

    protected abstract void clear();
    
}
