/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/Test_QE_URMAclMultiThreadedQuery.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.slide.urm.URMException;
import org.apache.slide.urm.accesscontroler.URMAce;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMConstants;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Test_QE_URMAclMultiThreadedQuery extends Test_QE_URMAclMultiThreadedBase {
    
    private int              mObjectNumber    = 0;
    private List             mCreatedObjects  = Collections.synchronizedList(new LinkedList());
    
    public Test_QE_URMAclMultiThreadedQuery(URMAclAdministrator aclAdmin, URMAdministrator admin, int objectNumber) {
        super(aclAdmin,  admin);
        mAclAdministrator = aclAdmin;
        mAdministrator = admin;
        mObjectNumber = objectNumber;
    }
    
    public void create() {
        try {
        for (int i = 0; i < mObjectNumber; ++i) {
            // create User
            String userName = "URM_ACL_USER" + java.lang.Thread.currentThread().getName() + Integer.toString(i);
            mAdministrator.createUser(userName, userName.toCharArray(), null);
            // create Role
            String roleName = "URM_ACL_ROLE" + java.lang.Thread.currentThread().getName() + Integer.toString(i);
            URMRole role1 = mAdministrator.createRole(roleName);
            // create Actions
            String actionName = "URM_ACL_ACTION" + java.lang.Thread.currentThread().getName() + Integer.toString(i);
            URMAction act1 = mAclAdministrator.createAction(actionName);
            // create UserMapping
            role1.addUserLink(userName, null);
            // create Acl/Ace
            URMUser usr1 = mAdministrator.getUser(userName, null);
            String aclId = "URM_ACL_ID" + java.lang.Thread.currentThread().getName() + Integer.toString(i);
//            System.out.println("usr1: " + (usr1 != null ? usr1.getName() : "NULL"));
            mAclAdministrator.createAcl(aclId, usr1, true);
            URMAcl acl1 = mAclAdministrator.getAcl(aclId);
            acl1.defineAce(URMConstants.GRANT, usr1, act1, 0, false);
            
            mCreatedObjects.add(new String(java.lang.Thread.currentThread().getName() + Integer.toString(i)));
            if ((i % 3) == 0)
                Thread.yield();
        }
        } catch (Exception e) {
            e.printStackTrace();
            mThrowable = e;
        } finally {
            if (mThrowable != null) {
                List objs = new LinkedList(mCreatedObjects);
                for (int i = 0; i < objs.size(); ++i) {
                    try {
                        // remove objects
                        String curr = (String)objs.get(i);
                        mAclAdministrator.deleteAcl("URM_ACL_ID" + curr);
                        URMRole role1 = mAdministrator.getRole("URM_ACL_ROLE" + curr);
                        role1.deleteUserLink("URM_ACL_USER" + curr, null);
                        mAclAdministrator.deleteAction("URM_ACL_ACTION" + curr);
                        mAdministrator.deleteRole("URM_ACL_ROLE" + curr);
                        mAdministrator.deleteUser("URM_ACL_USER" + curr, null);
                        
                        // remove from list
                        mCreatedObjects.remove(objs.get(i));
                    } catch (URMException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
    
    public void check() {
        String curr = null;
        try {
            int i = 0;
            for (Iterator iter = mCreatedObjects.iterator(); iter.hasNext(); ++i) {
                curr = (String)iter.next();

//               System.out.println("Trying to check object: " + curr);
                // Do something
                mAclAdministrator.getAllActions();
                URMAcl acl1 = mAclAdministrator.getAcl("URM_ACL_ID" + curr);
                List list1 = acl1.getAllAces();
                URMAce ace1 = acl1.getAce(0);
                
                Set set1 = mAdministrator.getAllRoles();
                URMRole role1 = mAdministrator.getRole("URM_ACL_ROLE" + curr);
                Set set2 = role1.getAllAncestors();
//                System.out.println("Checking object: " + curr + " succeeded.");
                
                if ((i % 3) == 0)
                    Thread.yield();
            }
        } catch (/*URM*/Exception e) {
//            System.out.println("Deleting object: " + curr + " failed.");
//            System.out.println("\n '"+ curr +"' failed.");
            e.printStackTrace();
            mThrowable = e;
        }
    }
    
    public void update() {
    }
    
    public void clear() {
        int last_size;
        do {
            last_size = mCreatedObjects.size();
            List objs = new LinkedList(mCreatedObjects);
            for (Iterator iter = objs.iterator(); iter.hasNext();) {
                try {
                    // remove objects
                     String curr = (String)iter.next();
//                    System.out.println("Trying to delete object: " + curr);
//                    System.out.println("URM_ACL_ID" + curr);
                     mAclAdministrator.deleteAcl("URM_ACL_ID" + curr);
                     URMRole role1 = mAdministrator.getRole("URM_ACL_ROLE" + curr);
                     role1.deleteUserLink("URM_ACL_USER" + curr, null);
//                    System.out.println("URM_ACL_ACTION" + curr);
                     mAclAdministrator.deleteAction("URM_ACL_ACTION" + curr);
//                     System.out.println("URM_ACL_ROLE" + curr);
                     mAdministrator.deleteRole("URM_ACL_ROLE" + curr);
//                     System.out.println("URM_ACL_USER" + curr);
                     mAdministrator.deleteUser("URM_ACL_USER" + curr, null);
//                     System.out.println("Deleting object: " + curr + " succeeded.");
                        
                     // remove from list
                     mCreatedObjects.remove(curr);

                } catch (URMException e) {
                    e.printStackTrace();
                    mThrowable = e;
                }
            }
        } while(mCreatedObjects.size() < last_size);
    }

    public List getCreatedObjects() {
        return mCreatedObjects;
    }
}
