/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/Test_QE_URMAction.java,v 1.1 2004/03/25 16:18:16 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:16 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.impl.URMSubjectImpl;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

public class Test_QE_URMAction extends TestCase {

    private static URMAuthenticator authenticator = null;
    private static URMAclAdministrator mAclAdmin = null;
    private static URMAdministrator mAdmin = null;
    private static URMPrincipal mPrincipal = null;
    private static URMConfigurator mTestConfigurator = null;
    private static String ldapadmin = "testuser01";
    
    public Test_QE_URMAction(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Test_QE_URMAction.class);
    }
    
    public URMAuthenticator mAuthenticator = null;
    
    public void test_pre() throws Exception {
        
        URMInit.init(false, ldapadmin, null);
        mPrincipal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdmin = mPrincipal.getURMAdministrator();
        mAclAdmin = mPrincipal.getURMAclAdministrator();

        // Create all data necessary to start the tests

        try {
            // Actions
            // URM_Test

//            URMAction act1 = mAclAdmin.createAction("B1");
            URMAction act2 = mAclAdmin.createAction("B2");
            URMAction act3 = mAclAdmin.createAction("B3");
            URMAction act4 = mAclAdmin.createAction("A1");
            URMAction act5 = mAclAdmin.createAction("A2");

            // URMAction_0005
            // Ading of this Action should not be possible
            try {
                act4.addAction("B1");
            } catch (Exception e) {
                if (e instanceof URMInternalServerException) {
                    // expected
                } else {
                    e.printStackTrace();
                    assertTrue(false);
                }
            }
            URMAction act1 = mAclAdmin.createAction("B1");
            act4.addAction("B1");
            
            
            act4.addAction("B2");
            act4.addAction("B3");
            
            act5.addAction("B3");
            
            // Some Roles
            URMRole role1 = mAdmin.createRole("role1");
            URMRole role2 = mAdmin.createRole("role2");
            URMRole role3 = mAdmin.createRole("role3");
            
            // User and Groups
            mAdmin.createUser("TestUser_dk1", "TestUser_dk1".toCharArray(), null);
            mAdmin.createUser("TestUser_dk2", "TestUser_dk2".toCharArray(), null);
            mAdmin.createGroup("TestGroup_dk1", null);
            URMGroup grp1 = mAdmin.getGroup("TestGroup_dk1", null);
            grp1.addUserToGroup("TestUser_dk1", null);
            grp1.addUserToGroup("TestUser_dk2", null);
            
        } catch (Exception e) {
            System.out.println("Exception caught: " +e.getMessage());
            e.printStackTrace();
        }
        
    }

    public void test_001() throws Exception {
        mPrincipal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdmin = mPrincipal.getURMAdministrator();
        mAclAdmin = mPrincipal.getURMAclAdministrator();
        
        URMSubject ownerSubject= new URMSubjectImpl("testuser01",
                                                     URMConstants.USER,
                                                     null);

        URMSubject invalidOwner = new URMSubjectImpl("dengibtsnicht",
                                                     URMConstants.USER,
                                                     null);

        try {
            // URMAction_0003
            // The Action is already a child action of this one.
            URMAction act1 = mAclAdmin.getAction("A1");
            act1.addAction("B1");
            assertTrue(false);
        } catch (Exception e) {
            if (e instanceof URMInsertException) {
                // expected
            } else {
                e.printStackTrace();
                assertTrue(false);
            }
        }
 
        try {
            // URMAction_0004
            // Action is the current one.
            URMAction act1 = mAclAdmin.getAction("A1");
            act1.addAction("A1");
            assertTrue(false);
        } catch (Exception e) {
            if (e instanceof URMInsertException) {
                // expected
            } else {
                e.printStackTrace();
                assertTrue(false);
            }
        }
 
        try {
            // URMAction_0006
            // Remove Action. Action does not exist.
            mAclAdmin.deleteAction("XXA1");
            assertTrue(false);
        } catch (Exception e) {
            if (e instanceof URMDeleteException){
                // expected
            } else {
                e.printStackTrace();
                assertTrue(false);
            }
        }
 
        try {
            // URMAction_0007
            // Remove Action. Action is not Base Action of this one.
            URMAction act1 = mAclAdmin.getAction("A1");
            act1.removeAction("A2");
        } catch (Exception e) {
            if (e instanceof URMDeleteException) {
                // expected
            } else {
                e.printStackTrace();
                assertTrue(false);
            }
        }
 
        // URMAction_0009
        // Get base actions.
        List r1 = new ArrayList();
        r1.add("B1"); r1.add("B2"); r1.add("B3");

        URMAction act1 = mAclAdmin.getAction("A1");
        Set set1 = act1.getBaseActions();
        assertEquals(set1.size(), 3);
        Iterator iter1 = set1.iterator();
        while (iter1 != null && iter1.hasNext()) {
            assertTrue(r1.contains(iter1.next()));
        }
 
        // URMAction_0010
        // Check circular dependency.
        act1 = mAclAdmin.getAction("A1");
        act1.addAction("A2");

        try {
            // URMAction_0010a
            // Check circular dependency.
            act1 = mAclAdmin.getAction("B1");
            act1.addAction("A1");
            assertTrue(false);
        } catch (Exception e) {
            if (e instanceof URMInsertException) {
                // expected
            } else {
                e.printStackTrace();
                assertTrue(false);
            }
        }

        // URMAction_0012
        // Get name of Action
        act1 = mAclAdmin.getAction("A2");
        assertTrue(act1.getName().equals("A2"));

    }
         
     public void test_post() throws Exception {
        
         mPrincipal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
         mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
         mAdmin = mPrincipal.getURMAdministrator();
         mAclAdmin = mPrincipal.getURMAclAdministrator();

         // Create all data necessary to start the tests

         try {
             // Users and Groups
             URMGroup grp1 = mAdmin.getGroup("TestGroup_dk1", null);
             grp1.removeUserFromGroup("TestUser_dk1", null);
             grp1.removeUserFromGroup("TestUser_dk2", null);
             mAdmin.deleteGroup("TestGroup_dk1", null);
             mAdmin.deleteUser("TestUser_dk1", null);
             mAdmin.deleteUser("TestUser_dk2", null);

             // Roles
             mAdmin.deleteRole("role1");
             mAdmin.deleteRole("role2");
             mAdmin.deleteRole("role3");

             // Actions
             URMAction act4 = mAclAdmin.getAction("A1");
             act4.removeAction("B1");
             act4.removeAction("B2");
             act4.removeAction("B3");
             act4.removeAction("A2");
             URMAction act5 = mAclAdmin.getAction("A2");
             act5.removeAction("B3");
             mAclAdmin.deleteAction("B1");
             mAclAdmin.deleteAction("B2");
             mAclAdmin.deleteAction("B3");
             mAclAdmin.deleteAction("A1");
             mAclAdmin.deleteAction("A2");

         } catch (Exception e) {
             System.out.println("Exception caught: " +e.getMessage());
             e.printStackTrace();
         }
        
     }

     public static void main(String[] args) throws Exception {
         if (authenticator == null) {
             URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
             conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
             authenticator = URMAuthenticator.newInstance(conf);
         }
        
         String[] testCaseName = { "-noloading", Test_QE_URMAction.class.getName() };
    
         junit.textui.TestRunner.main(testCaseName);
     }
}

