/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/accesscontroler/Test_QE_URMReport.java,v 1.3 2004/07/30 06:52:20 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:20 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.accesscontroler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.accesscontroler.URMAccessCheckException;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAclValidator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.impl.URMSubjectImpl;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Test_QE_URMReport extends TestCase{
    
    private static URMAuthenticator authenticator = null;
    public Test_QE_URMReport(String name) throws Exception {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Test_QE_URMReport.class);
    }

    String ldapadmin = "testuser01";
    
    String user1 = "user1";
    String user2 = "user2";
    String user3 = "user3";
    String user4 = "user4";
    String user5 = "user5";
    
    String employee = "Employee";
    String developer = "Developer";
    String administrator = "Administrator";
    
    String admins = "Admins";
    String guests = "GuestUsers";
    
    String read = "Read";
    String write = "Write";
    String create = "Create";
    String delete = "Delete";
    String execute = "Execute";
    String review = "Review";
    String admin = "Admin";
    
    String displayname = "displayname";
    
    String acl1 = "1";
    String acl2 = "2";
    String acl3 = "3";
    String acl4 = "4";
    String acl5 = "5";
    String acl6 = "6";
    String acl7 = "7";
    String acl8 = "8";
    String acl9 = "9";
    String acl10 = "10";
    String acl11 = "11";
    String acl13 = "13";
    String acl14 = "14";
    String acl4711 = "4711";
    
    String notes = "notes";
    
    int end = 100;

    public void _test_create_testenvironment() throws Exception {
    try {
        int result = 0;
            
        List uri = new ArrayList();
        URMInit.init(false, ldapadmin, null);
        URMPrincipal principal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator acladmin = principal.getURMAclAdministrator();
        
        // create users, groups and roles
        urmadmin.createUser(user1, user1.toCharArray(), null);
        URMUser _user1 = urmadmin.getUser(user1, null);
        _user1.setProperty(displayname, user1);
        _user1.setProperty(notes, user1);
        assertEquals((String) _user1.getProperty(notes), user1);
        _user1.linkToRole(URMConstants.URM_ADMIN_ROLE);
        urmadmin.createUser(user2, user2.toCharArray(), null);
        URMUser _user2 = urmadmin.getUser(user2, null);
        _user2.setProperty(displayname, user1);
        urmadmin.createUser(user3, user3.toCharArray(), null);
        URMUser _user3 = urmadmin.getUser(user3, null);
        _user3.setProperty(displayname, user1);
        urmadmin.createUser(user4, user4.toCharArray(), null);
        URMUser _user4 = urmadmin.getUser(user4, null);
        _user4.setProperty(displayname, user1);
        urmadmin.createUser(user5, user5.toCharArray(), null);
        URMUser _user5 = urmadmin.getUser(user5, null);
        _user5.setProperty(displayname, user1);
        
        urmadmin.createRole(employee);
        urmadmin.createRole(developer);
        urmadmin.createRole(administrator);
        
        urmadmin.createGroup(admins, null);
        URMGroup _admins = urmadmin.getGroup(admins, null);
//        _admins.addUserToGroup(user2, null);
        _admins.addUserToGroup(user5, null);
        _admins.setProperty(displayname, admins);

        urmadmin.createGroup(guests, null);
//        _admins = urmadmin.getGroup(admins, null);
//        _admins.addUserToGroup(user2, null);
        URMGroup _guests = urmadmin.getGroup(guests, null);
        
        // create actions
        acladmin.createAction(read);
        acladmin.createAction(write);
        acladmin.createAction(delete);
        acladmin.createAction(create);
        acladmin.createAction(execute);
        acladmin.createAction(review);
        acladmin.createAction(admin);
        
        // do action mapping
        URMAction _review = acladmin.getAction(review);
        _review.addAction(read);
        _review.addAction(write);
        
        // do action mapping
        URMAction _admin = acladmin.getAction(admin);
        _admin.addAction(read);
        _admin.addAction(write);
        _admin.addAction(delete);
        _admin.addAction(create);
        
        // do role mapping
        URMRole _employee = urmadmin.getRole(employee);
        _employee.addUserLink(user1, null);
        _employee.addUserLink(user3, null);
        _employee.addUserLink(user4, null);
        
        URMRole _developer = urmadmin.getRole(developer);
        _developer.addUserLink(user2, null);
        _developer.addAncestor(employee);
                
        URMRole _administrator = urmadmin.getRole(administrator);
        _administrator.addGroupLink(admins, null);
        _administrator.addAncestor(employee);
        _administrator.setPredefinedAction(admin, new Boolean(true));
        
        // create acls
        acladmin.createAcl(acl1,_user1,true);
        acladmin.createAcl(acl2,_user1,true);
        acladmin.createAcl(acl3,_user1,true);
        acladmin.createAcl(acl4,_user1,true);
        acladmin.createAcl(acl5,_user1,true);
        acladmin.createAcl(acl6,_user1,true);
        acladmin.createAcl(acl7,_user1,true);
        acladmin.createAcl(acl8,_user1,true);
        acladmin.createAcl(acl9,_user1,true);
        acladmin.createAcl(acl10,_user1,true);
        acladmin.createAcl(acl11,_user1,true);
        acladmin.createAcl(acl13,_user1,true);
        acladmin.createAcl(acl14,_user1,true);
        acladmin.createAcl(acl4711,_user1,true);
        
        // define aces
        URMAcl _acl1 = acladmin.getAcl(acl1);
        _acl1.defineAce(URMConstants.GRANT,_employee,_admin,end,false);
        _acl1.defineAce(URMConstants.GRANT,_admins,_admin,end,false);
        
        URMAction _read = acladmin.getAction(read);
        URMAcl _acl2 = acladmin.getAcl(acl2);
        _acl2.defineAce(URMConstants.DENY,_employee,_read,end,false);
        
        URMAcl _acl3 = acladmin.getAcl(acl3);
        _acl3.defineAce(URMConstants.GRANT,_developer,_read,end,false);
        
        URMAcl _acl4 = acladmin.getAcl(acl4);
        _acl4.defineAce(URMConstants.DENY,_administrator,_read,end,false);
        _acl4.defineAce(URMConstants.DENY,_developer,_read,end,false);
        _acl4.defineAce(URMConstants.DENY,_employee,_read,end,false);
        
        URMAcl _acl5 = acladmin.getAcl(acl5);
        _acl5.defineAce(URMConstants.GRANT,_employee,_read,end,false);
        _acl5.defineAce(URMConstants.DENY,_employee,_read,end,false);
            
        URMAcl _acl6 = acladmin.getAcl(acl6);
        _acl6.defineAce(URMConstants.GRANT,_user4,_review,end,false);
        _acl6.defineAce(URMConstants.GRANT,_user2,_read,end,false);
        _acl6.defineAce(URMConstants.DENY,_user4,_read,end,false);
     
        URMAcl _acl7 = acladmin.getAcl(acl7);
        _acl7.defineAce(URMConstants.DENY,_user1,_read,end,true);
            
        URMAcl _acl8= acladmin.getAcl(acl8);
        _acl8.defineAce(URMConstants.GRANT,_user2,_read,end,false);
            
        URMAcl _acl9 = acladmin.getAcl(acl9);
        _acl9.defineAce(URMConstants.GRANT,_employee,_read,end,false);
        _acl9.defineAce(URMConstants.DENY,_employee,_read,end,false);
            
        URMAcl _acl10= acladmin.getAcl(acl10);
        _acl10.defineAce(URMConstants.GRANT,urmadmin.getALLSubject(),acladmin.getAction(URMConstants.URM_ALL_ACTION),end,false);
            
        URMAcl _acl11= acladmin.getAcl(acl11);
        _acl11.defineAce(URMConstants.DENY,_user1,_read,end,false);
            
        URMAcl _acl13= acladmin.getAcl(acl13);
        _acl13.defineAce(URMConstants.DENY,_admins,_read,end,false);

        URMAcl _acl14= acladmin.getAcl(acl14);
        _acl14.defineAce(URMConstants.GRANT,_admins,_read,end,false);
        _acl14.defineAce(URMConstants.GRANT,_guests,_read,end,false);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void test_group_Permissions() throws Exception {

        // URMAclAdministrator_0027
        // GetGroupPermissionReport, Group does not exist
        
        Map result = null;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl("NonExistingGroup", URMConstants.GROUP, null);

/*        try {
            urmAdmin.getAllUsers(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
*/
        try {
            result = aclAdmin.subjectPermissionSetReport(principal, subG, uri);
        } catch (Exception e) {
//            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }

    public void test_group_Permissions_Domain() throws Exception {

        // URMAclAdministrator_0028
        // GetGroupPermissionReport, Domain does not exist
        // BUG BUG ??
        Map result = null;
        String action = "Read";
        String user = "user3";
        List uri = new ArrayList();
        uri.add("1");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMGroup urmGroup = urmAdmin.getGroup("Admins", "NonExistingDomain"); // Domain ignored with Ldap Authentication
        
        try {
            result = aclAdmin.subjectPermissionSetReport(principal, urmGroup,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
// ??        assertEquals(result.size(), 5);
    }
    
    // test the URMGuest account
    public void test_group_Permission_Resource() throws Exception {

        // URMAclAdministrator_0029
        // GetGroupPermissionReport, Resource does not exist
        Map result = null;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("42");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl("Admins", URMConstants.GROUP, null);

        try {
            result = aclAdmin.subjectPermissionSetReport(principal, subG,uri);
        } catch (Exception e) {
//            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_group_Permission_Resource_Empty() throws Exception {

        // URMAclAdministrator_0031
        // GetGroupPermissionReport, Resource empty, no ACE.
        Map result = null;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("4711");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl("Admins", URMConstants.GROUP, null);

        try {
            result = aclAdmin.subjectPermissionSetReport(principal, subG,uri);
        } catch (Exception e) {
//            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_group_Permission_no_ACE() throws Exception {

        // URMAclAdministrator_0032
        // GetGroupPermissionReport, actions only for different group
        Map result = null;
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("4711");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl(guests, URMConstants.GROUP, null);

        try {
            result = aclAdmin.subjectPermissionSetReport(principal, subG,uri);
        } catch (Exception e) {
//           e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    public void test_group_Permission_Ace() throws Exception {

        // URMAclAdministrator_0033
        // GetGroupPermissionReport, ACE exists for this group
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("13");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl(admins, URMConstants.GROUP, null);
        
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subG,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
        assertEquals(result.size(), 1);
    }
    
    public void test_group_Permission_more_Aces() throws Exception {

        // URMAclAdministrator_0034
        // GetGroupPermissionReport, ACE exists for this and another group
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("14");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl(admins, URMConstants.GROUP, null);
        
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subG,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
        assertEquals(result.size(), 1);
    }
    
    public void test_role_Permission_report() throws Exception {

        // URMAclAdministrator_0035
        // GetRolePermissionReport, Role does not exist BUG BUG -> role cannot be create in first place!

        // URMAclAdministrator_0036
        // GetRolePermissionReport, Role exist, but resource not
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("14");
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Developer");
        
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subR,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_role_Permission_no_Ace() throws Exception {
    
        // URMAclAdministrator_0037
        // GetRolePermissionReport, no Ace
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("4711");
            
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Developer");
            
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subR,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_role_Permission_no_Ace_for_Role() throws Exception {
        
        // URMAclAdministrator_0038
        // GetRolePermissionReport, no Ace for this role
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("14");
                
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Developer");
                
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subR,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_role_Permission_Ace() throws Exception {
            
        // URMAclAdministrator_0039
        // GetRolePermissionReport, only Ace for this role
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("9");
                    
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Employee");
                    
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subR,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
    }
    
    public void test_role_Permission_Ace_other() throws Exception {
                
        // URMAclAdministrator_0039
        // GetRolePermissionReport, Aces only for this roles
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("3");
                        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Developer");
                        
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subR,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
        assertEquals(result.size(), 1);
    }
    
    public void test_role_Permission_Ace_more() throws Exception {
                    
        // URMAclAdministrator_0040
        // GetRolePermissionReport, Aces for this and other roles
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("4");
                            
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Developer");
                            
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subR,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
    }
    
    public void test_user_Permission_user_not_exist() throws Exception {
                        
        // URMAclAdministrator_0041
        // GetRolePermissionReport, Aces for this and other roles
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("4");
                                
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subU = new URMSubjectImpl("UserDoesNotExist", URMConstants.USER, null);
                                
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_user_Permission_Acl_not_exist() throws Exception {
        // URMAclAdministrator_0042
        // Domain passed does not exist. BUG BUG You cannot create such a user object.
                            
        // URMAclAdministrator_0043
        // GetRolePermissionReport, no Ace
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("42");
                                    
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                    
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_user_Permission_not_auth() throws Exception {
        // URMAclAdministrator_0044
        // Unauthorized access.
                                
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("4711");
                                        
        URMPrincipal principal = authenticator.authenticateUser("testuser01", "testuser01".toCharArray(), null);
        principal.setActiveRole("URMGuest");
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
                                        
        try {
            URMUser subU = urmAdmin.getUser(user, null);
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            if (e instanceof URMForbiddenException) {
                // nada, OK , guuuut!
            } else {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
    }

    public void test_user_Permission_no_Ace() throws Exception {
        // URMAclAdministrator_0045
        // user permission report. Acl has no aces.
                                
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("4711");
                                        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                        
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_user_Permission_other_Ace() throws Exception {
        // URMAclAdministrator_0046
        // user permission report. Acl not defined for the user

        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("6");
                                            
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                            
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }

    public void test_user_Permission_valid_Ace() throws Exception {
        // URMAclAdministrator_0047
        // user permission report. One Ace defined for the user
    
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
        assertEquals(result.size(), 1);
    }

    public void test_user_Permission_Aces() throws Exception {
        // URMAclAdministrator_0048
        // user permission report. One Ace defined for the user
        
        Map result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                    
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                    
        try {
            result = aclAdmin.subjectPermissionSetReport(principal,subU,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.containsKey("Read"), true);
        assertEquals(result.size(), 1);
    }
    
    public void test_user_Permission_Report_1() throws Exception {
        // URMAclAdministrator_0049
        // user permission report. Action does not exist
            
        Set result = null;
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                        
        try {
            result = aclAdmin.userWithPermissionReport(principal,"NonExistingAction",uri);
        } catch (Exception e) {
            if (e instanceof URMInternalServerException) {
                // nada
            } else {
                e.printStackTrace();
            }
            result = null;
        }
        assertEquals(result, null);
    }
    
    public void test_user_Permission_Report_2() throws Exception {
        // URMAclAdministrator_0050
        // user permission report. Resource does not exist
                
        Set result = null;
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("42");
                                                            
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                            
        try {
            result = aclAdmin.userWithPermissionReport(principal,action,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_user_Permission_Report_3() throws Exception {
        // URMAclAdministrator_0051
        // user permission report. This action is not in the ACE
                    
        Set result = null;
        String action = "Write";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                                
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                                
        try {
            result = aclAdmin.userWithPermissionReport(principal,action,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        assertEquals(result.isEmpty(), true);
    }
    
    public void test_user_Permission_Report_4() throws Exception {
        // URMAclAdministrator_0052
        // user permission report. This action is not in the ACE
                        
        Set result = null;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                                    
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                                    
        try {
            result = aclAdmin.userWithPermissionReport(principal,action,uri);
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }

        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String key = ((URMUser) iter.next()).getName();
            assertEquals(key, reference.contains(key), true);
        }
        
        Iterator refiter = reference.iterator();
        while (refiter.hasNext()) {
            String key = (String) refiter.next();
            Iterator userIter = result.iterator();
            URMUser currentuser = null;
            while ((currentuser == null) && userIter.hasNext()) {
                URMUser help = (URMUser) userIter.next();
                if (help.getName().equals(key)) currentuser = help;
            }
            assertEquals(key, (currentuser != null), true);
        }
        assertEquals(result.size(), 1);
    }

    public void test_Subject_Permission_Report_1() throws Exception {
        // URMAclAdministrator_0053
        // user permission report. This action is not in the ACE
                            
        int ret = 0;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                                        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMSubject subG = new URMSubjectImpl("NonExistingGroup", URMConstants.GROUP, null);
                                                                        
        try {
            ret = aclAdmin.subjectPermissionReport(principal,subG,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            ret = -1;
        }
    
        assertEquals(URMAclValidator.URMNotApplicable, ret);
    }

    public void test_Subject_Permission_Report_2() throws Exception {
        // URMAclAdministrator_0054
        // user permission report. Domain does not exist BUG BUG You cannot create this Subject!
        
        // URMAclAdministrator_0055
        // user permission report. Action does not exist
                                
        int ret = 0;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "NonExistingAction";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("7");
                                                                            
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                                                 
        try {
            ret = aclAdmin.subjectPermissionReport(principal,subU,uri,action);
        } catch (Exception e) {
            if (e instanceof URMAccessCheckException) {
                // nada
            } else {
                e.printStackTrace();
            }
            ret = -1;
        }
        
        assertEquals(ret, -1);
    }

    public void test_Subject_Permission_Report_3() throws Exception {
        // URMAclAdministrator_0056
        // user permission report. Resource does not exist
                                    
        int ret = 0;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("42");
                                                                                
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                                                     
        try {
            ret = aclAdmin.subjectPermissionReport(principal,subU,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            ret = -1;
        }
            
        assertEquals(ret,URMAclValidator.URMIndeterminate);
    }

    public void test_Subject_Permission_Report_4() throws Exception {
        // URMAclAdministrator_0057
        // user permission report. No matching Ace
                                        
        int ret = 0;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("13");
                                                                                    
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                                                         
        try {
            ret = aclAdmin.subjectPermissionReport(principal,subU,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            ret = -1;
        }
                
        assertEquals(ret,URMAclValidator.URMIndeterminate);
    }

    public void test_Subject_Permission_Report_5() throws Exception {
        // URMAclAdministrator_0058
        // user permission report. Ace says NO
                                            
        int ret = 0;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "Read";
        String user = "user5";
        List uri = new ArrayList();
        uri.add("13");
                                                                                        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMUser subU = urmAdmin.getUser(user, null);
                                                                                             
        try {
            ret = aclAdmin.subjectPermissionReport(principal,subU,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            ret = -1;
        }
                    
        assertEquals(ret,URMAclValidator.URMDeny);
    }

    public void test_Subject_Permission_Report_6() throws Exception {
        // URMAclAdministrator_0059
        // user permission report. Ace says YES
                                                
        int ret = 0;
        Set reference = new HashSet();
        reference.add("user1");
        String action = "Read";
        String user = "user1";
        List uri = new ArrayList();
        uri.add("9");
                                                                                            
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        URMAclValidator mAclValidator = URMAclValidator.newInstance();
        URMAdministrator urmAdmin = principal.getURMAdministrator();
        URMAclAdministrator aclAdmin = principal.getURMAclAdministrator();
        URMRole subR = urmAdmin.getRole("Employee");
                                                                                                 
        try {
            ret = aclAdmin.subjectPermissionReport(principal,subR,uri,action);
        } catch (Exception e) {
            e.printStackTrace();
            ret = -1;
        }
                        
        assertEquals(ret,URMAclValidator.URMPermit);
    }
    
    public void _test_deletetest_environment() throws Exception {
    try {
        int result = 0;
            
        List uri = new ArrayList();
        URMPrincipal principal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        URMAclAdministrator acladmin = principal.getURMAclAdministrator();
               
        // delete acls
        acladmin.deleteAcl(acl1);
        acladmin.deleteAcl(acl2);
        acladmin.deleteAcl(acl3);
        acladmin.deleteAcl(acl4);
        acladmin.deleteAcl(acl5);
        acladmin.deleteAcl(acl6);
        acladmin.deleteAcl(acl7);
        acladmin.deleteAcl(acl8);
        acladmin.deleteAcl(acl9);
        acladmin.deleteAcl(acl10);
        acladmin.deleteAcl(acl11);
        acladmin.deleteAcl(acl13);
        acladmin.deleteAcl(acl14);
        acladmin.deleteAcl(acl4711);

        urmadmin.deleteRole(administrator);
        urmadmin.deleteRole(developer);
        urmadmin.deleteRole(employee);
            
        urmadmin.deleteGroup(admins, null);
            
        urmadmin.deleteUser(user1, null);
        urmadmin.deleteUser(user2, null);
        urmadmin.deleteUser(user3, null);
        urmadmin.deleteUser(user4, null);
        urmadmin.deleteUser(user5, null);
            
        // delete actions
        acladmin.deleteAction(review);
        acladmin.deleteAction(admin);
        acladmin.deleteAction(read);
        acladmin.deleteAction(write);
        acladmin.deleteAction(delete);
        acladmin.deleteAction(create);
        acladmin.deleteAction(execute);

            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (authenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            authenticator = URMAuthenticator.newInstance(conf);
        }
        
        String[] testCaseName = { "-noloading", Test_QE_URMReport.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
        
     }
     

}

