/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/rolemanager/TestURMRoleAdministrator.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.rolemanager;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.URMException;
import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.rolemanager.impl.URMRoleImpl;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorUtil;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMRoleAdministrator extends TestCase {

    private static final int TEST_METHOD_NUMBER = 10;

    private static String TEST_USER1 = "URM_junit_testr_usr1";
    private static String TEST_USER2 = "URM_junit_testr_usr2";
    private static String TEST_GROUP1 = "URM_junit_testr_grp1";
    private static String TEST_GROUP2 = "URM_junit_testr_grp2";
    private static String TEST_ROLE1 = "URM_junit_testr_role1";
    private static String TEST_ROLE2 = "URM_junit_testr_role2";
    private static String TEST_ROLE3 = "URM_junit_testr_role3";
    private static String TEST_ROLE4 = "URM_junit_testr_role4";
    private static String TEST_ACTION1 = "URM_junit_testr_action1";
    private static String TEST_ACTION2 = "URM_junit_testr_action2";
    private static String TEST_RESOURCE_ID1 = "URM_junit_testr_acl_resource_id1";
    private static String TEST_RESOURCE_ID2 = "URM_junit_testr_acl_resource_id2";

    private static URMAuthenticator mAuthenticator = null;
    private static URMPrincipal mPrincipal = null;
    private static URMAdministrator mAdministrator = null;
    private static URMAclAdministrator mAclAdministrator = null;
    private static URMConfigurator mTestConfigurator = null;
    private static String mDomain = null;
    private static int mSetUpTearDownCounter = 0;
    private static int mSetUpTearDownCounterCheck = 0;
    private static LinkedList mCreatedUserNames    = new LinkedList();
    private static LinkedList mCreatedUserDomains  = new LinkedList();
    private static LinkedList mCreatedGroupNames   = new LinkedList();
    private static LinkedList mCreatedGroupDomains = new LinkedList();
    private static LinkedList mCreatedRoleNames    = new LinkedList();
    private static LinkedList mCreatedAclIds       = new LinkedList();

    public TestURMRoleAdministrator(String name) throws Exception {
        super(name);
        initUrmTest();
    }
    
    private static synchronized void initUrmTest() throws Exception {
        if (mTestConfigurator != null)
            return;
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationTamino.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapDK.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapSunOne.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapActiveDirectory.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationOS.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapXtlin1.xml");

        FileInputStream fis = new FileInputStream("config/ConfigurationLdapSunOne.xml");
        //FileInputStream fis = new FileInputStream("config/ConfigurationLdapOpenLdap.xml");
        //FileInputStream fis = new FileInputStream("config/ConfigurationOS.xml");

        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();
        mTestConfigurator = (URMConfigurator)(conf.getSubConfigurators().get("JUnitTest"));
        conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
        mAuthenticator = URMAuthenticator.newInstance(conf);
        mDomain = mTestConfigurator.getProperties().getProperty("TestDomain");
        if (mDomain.length() <= 0)
            mDomain = null;
        mPrincipal = mAuthenticator.authenticateUser(
                mTestConfigurator.getProperties().getProperty("TestAdminUser"),
                mTestConfigurator.getProperties().getProperty("TestAdminPw").toCharArray(), mDomain);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdministrator = mPrincipal.getURMAdministrator();
        if (mAdministrator == null)
            throw new Exception ("CANNOT CREATE URM ADMINISTRATOR, CHECK THE TEST ADMIN USER PARAMS!");
        mAclAdministrator = mPrincipal.getURMAclAdministrator();
        assertNotNull("null URMAclAdministrator was received!!!", mAclAdministrator);
        
        mDomain = mTestConfigurator.getProperties().getProperty("TestDomain");
        if (mDomain.length() <= 0)
            mDomain = null;
    }
    
    public static Test suite() {
        return new TestSuite(TestURMRoleAdministrator.class);
    }
    
    private boolean containsValues(Set set, String val1, String val2) {
        /*if (set == null)
            return false;*/
        
        Iterator iter = set.iterator();
        boolean role1exists = false, role2exists = false;
        while (/*iter != null && */iter.hasNext()) {
            Object obj = iter.next();
            if (((URMSubject)obj).getName().equals(val1))
                role1exists = true;
            else if (((URMSubject)obj).getName().equals(val2))
                role2exists = true;
        }
        return role1exists && role2exists;
    }
    
    private boolean containsValue(Set set, String val) {
        /*if (set == null)
            return false;*/
        
        Iterator iter = set.iterator();
        while (/*iter != null && */iter.hasNext())
            if (((URMSubject)iter.next()).getName().equals(val))
                return true;
        return false;
    }
    
    private String getMissingKeys(Enumeration keys, Properties props) {
        String missingkeys = ",";
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String gval = props.getProperty(key);
            if (gval == null)
                missingkeys += ("," + key);
        }
        return missingkeys.substring(2);
    }
    
    public void setUp() throws Exception {
        /*
        URMGroup grp = mAdministrator.getGroup("role1", null);
        Set members = grp.getGroupMembers();
        mAdministrator = null;
        */
        synchronized (mAdministrator) {
            assertFalse("Please, increment the 'TEST_METHOD_NUMBER' variable.",
                            mSetUpTearDownCounterCheck >= TEST_METHOD_NUMBER);
            if (mSetUpTearDownCounterCheck++ > 0) {
                return;
            }
            //System.out.println("Setup met zero counter.");
            mSetUpTearDownCounter = TEST_METHOD_NUMBER;
            String err;
            // create users
            try { err = null;
                mAdministrator.createUser(TEST_USER1, TEST_USER1.toCharArray(), mDomain);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_USER1+"' back("+err+").",
                            mAdministrator.getUser(TEST_USER1, mDomain));
            try { err = null;
                mAdministrator.createUser(TEST_USER2, TEST_USER2.toCharArray(), mDomain);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_USER2+"' back("+err+").",
                            mAdministrator.getUser(TEST_USER2, mDomain));
            // create groups
            try { err = null;
                mAdministrator.createGroup(TEST_GROUP1, mDomain);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_GROUP1+"' back("+err+").",
                            mAdministrator.getGroup(TEST_GROUP1, mDomain));
            try { err = null;
                mAdministrator.createGroup(TEST_GROUP2, mDomain);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_GROUP2+"' back("+err+").",
                            mAdministrator.getGroup(TEST_GROUP2, mDomain));
            // create roles
            try { err = null;
                mAdministrator.createRole(TEST_ROLE1);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_ROLE1+"' back("+err+").",
                            mAdministrator.getRole(TEST_ROLE1));
            try { err = null;
                mAdministrator.createRole(TEST_ROLE2);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_ROLE2+"' back("+err+").",
                            mAdministrator.getRole(TEST_ROLE2));
            try { err = null;
                mAdministrator.createRole(TEST_ROLE3);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_ROLE3+"' back("+err+").",
                            mAdministrator.getRole(TEST_ROLE3));
            try { err = null;
                mAdministrator.createRole(TEST_ROLE4);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_ROLE4+"' back("+err+").",
                            mAdministrator.getRole(TEST_ROLE4));
            // create actions
            try { err = null;
                Object obj = null;
                try { obj = mAclAdministrator.getAction(TEST_ACTION1); } catch (URMException e) {}
                if (obj == null)
                    mAclAdministrator.createAction(TEST_ACTION1);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_ACTION1+"' back("+err+").",
                            mAclAdministrator.getAction(TEST_ACTION1));
            try { err = null;
                Object obj = null;
                try { obj = mAclAdministrator.getAction(TEST_ACTION2); } catch (URMException e) {}
                if (obj == null)
                    mAclAdministrator.createAction(TEST_ACTION2);
            } catch (URMException e) { err = e.getMessage(); }
            assertNotNull("Cannot get the just created '"+TEST_ACTION2+"' back("+err+").",
                            mAclAdministrator.getAction(TEST_ACTION2));
        }
    }

    public void tearDown() throws Exception {
        synchronized (mAdministrator) {
            if (--mSetUpTearDownCounter > 0)
                return;
            //System.out.println("Tear down met zero counter.");
        }
                        
        // delete users
        mAdministrator.deleteUser(TEST_USER1, mDomain);
        assertFalse("The delete '"+TEST_USER1+"' failed (created in setUp).",
                        mAdministrator.isUser(TEST_USER1, mDomain));
        assertTrue("The '"+TEST_USER2+"' cannot be found (created in setUp).",
                        mAdministrator.isUser(TEST_USER2, mDomain));
        mAdministrator.deleteUser(TEST_USER2, mDomain);
        assertFalse("The delete '"+TEST_USER2+"' failed (created in setUp).",
                        mAdministrator.isUser(TEST_USER2, mDomain));
        // delete groups
        mAdministrator.deleteGroup(TEST_GROUP1, mDomain);
        assertFalse("The delete '"+TEST_GROUP1+"' failed (created in setUp).",
                        mAdministrator.isGroup(TEST_GROUP1, mDomain));
        assertTrue("The '"+TEST_GROUP2+"' cannot be found (created in setUp).",
                        mAdministrator.isGroup(TEST_GROUP2, mDomain));
        mAdministrator.deleteGroup(TEST_GROUP2, mDomain);
        assertFalse("The delete '"+TEST_GROUP2+"' failed (created in setUp).",
                        mAdministrator.isGroup(TEST_GROUP2, mDomain));

        // delete groups
        mAdministrator.deleteRole(TEST_ROLE1);
        assertFalse("The delete '"+TEST_ROLE1+"' failed (created in setUp).",
                        mAdministrator.isRole(TEST_ROLE1));
        assertTrue("The '"+TEST_ROLE2+"' cannot be found (created in setUp).",
                        mAdministrator.isRole(TEST_ROLE2));
        mAdministrator.deleteRole(TEST_ROLE2);
        assertFalse("The delete '"+TEST_ROLE2+"' failed (created in setUp).",
                        mAdministrator.isRole(TEST_ROLE2));
        assertTrue("The '"+TEST_ROLE3+"' cannot be found (created in setUp).",
                        mAdministrator.isRole(TEST_ROLE3));
        mAdministrator.deleteRole(TEST_ROLE3);
        assertFalse("The delete '"+TEST_ROLE3+"' failed (created in setUp).",
                        mAdministrator.isRole(TEST_ROLE3));
        mAdministrator.deleteRole(TEST_ROLE4);
        assertFalse("The delete '"+TEST_ROLE4+"' failed (created in setUp).",
                        mAdministrator.isRole(TEST_ROLE4));

        for (int i = 0; i < mCreatedUserNames.size(); ++i) {
            String usr = (String)mCreatedUserNames.get(i), dmn = (String)mCreatedUserDomains.get(i);
            mAdministrator.deleteUser(usr, dmn);
            assertFalse("The delete '"+usr+"'("+dmn+") failed (created during the tests).",
                            mAdministrator.isUser(usr, dmn));
        }
        for (int i = 0; i < mCreatedGroupNames.size(); ++i) {
            String usr = (String)mCreatedGroupNames.get(i), dmn = (String)mCreatedGroupDomains.get(i);
            mAdministrator.deleteGroup(usr, dmn);
            assertFalse("The delete '"+usr+"'("+dmn+") failed (created during the tests).",
                            mAdministrator.isGroup(usr, dmn));
        }
        for (int i = 0; i < mCreatedAclIds.size(); ++i) {
            String resourceid = (String)mCreatedAclIds.get(i);
            mAclAdministrator.deleteAcl(resourceid);
            assertNull("The delete ACL '"+resourceid+"' failed (created during the tests).",
                            mAclAdministrator.getAcl(resourceid));
        }
        for (int i = 0; i < mCreatedRoleNames.size(); ++i) {
            String role = (String)mCreatedRoleNames.get(i);
            mAdministrator.deleteRole(role);
            assertFalse("The delete '"+role+"' failed (created during the tests).",
                            mAdministrator.isRole(role));
        }
        
        // delete actions
        if (mAclAdministrator.getAction(TEST_ACTION1) != null) {
            mAclAdministrator.deleteAction(TEST_ACTION1);
        }
        assertNull("The delete '"+TEST_ACTION1+"' failed (created in setUp).",
                        mAclAdministrator.getAction(TEST_ACTION1));
        if (mAclAdministrator.getAction(TEST_ACTION2) != null) {
            mAclAdministrator.deleteAction(TEST_ACTION2);
        }
        assertNull("The delete '"+TEST_ACTION2+"' failed (created in setUp).",
                        mAclAdministrator.getAction(TEST_ACTION2));
    }

    public void test0_() throws Exception {
    }
    
    /** Implemented test cases:
     *
     * URMAdministrator_0029, URMAdministrator_0030, URMAdministrator_0032,
     * URMAdministrator_0033, URMAdministrator_0034, URMAdministrator_0035,
     * URMAdministrator_0036, URMAdministrator_0037, URMAdministrator_0039,
     * URMAdministrator_0041, URMAdministrator_0043, URMAdministrator_0044,
     * URMAdministrator_0045
     */
    public void test1_getAllRoles() throws Exception {
        assertTrue("Cannot get the added roles back.",
                containsValues(mAdministrator.getAllRoles(), TEST_ROLE1, TEST_ROLE2));
        // prepare GUEST user
        URMPrincipal princ1 = null;
        String err = null;
        try {
            princ1 = mAuthenticator.authenticateUser(TEST_USER1, TEST_USER1.toCharArray(), mDomain);
        } catch (URMException e) { err = e.getMessage(); }
        assertNotNull("Cannot authenticate the '"+TEST_USER1+"' user ("+err+").", princ1);
        URMUser usr = mAdministrator.getUser(TEST_USER1, mDomain);
        if (!URMRoleImpl.contains(usr.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            usr.linkToRole(URMConstants.URM_GUEST_ROLE);
        princ1.setActiveRole(URMConstants.URM_GUEST_ROLE);
        // create user
        String role_name = "URM_junit_test_allroles";
            // trying create with GUEST role
        try {
            princ1.getURMAdministrator().createRole(role_name);
            mCreatedRoleNames.add(role_name);
            assertFalse("Creating role with GUEST role did not throw an exception.", true);
        } catch (URMException e) { }
        assertFalse("Creating role with GUEST role was successful (but threw an exception).",
                        mAdministrator.isRole(role_name));
            // trying create with GUEST role (but having also ADMIN role)
        usr = mAdministrator.getUser(TEST_USER1, mDomain);
        if (!URMRoleImpl.contains(usr.getRoleMapping(), URMConstants.URM_ADMIN_ROLE))
            usr.linkToRole(URMConstants.URM_ADMIN_ROLE);
        princ1 = princ1.copyPrincipal(URMConstants.URM_ADMIN_ROLE);
        princ1 = princ1.copyPrincipal(URMConstants.URM_GUEST_ROLE);
        try {
            princ1.getURMAdministrator().createRole(role_name);
            mCreatedRoleNames.add(role_name);
            assertFalse("Creating role with GUEST role (but having also ADMIN role) did not throw an exception.", true);
        } catch (URMForbiddenException e) { }
        assertFalse("Creating role with GUEST role (but having also ADMIN role) was successful (but threw an exception).",
                        mAdministrator.isRole(role_name));
            // create with ADMIN
        try { err = null;
            mAdministrator.createRole(role_name);
        } catch (URMException e) { err = e.getMessage(); }
        assertTrue("Creating role '"+role_name+"' (2.) failed ("+err+").",
                        mAdministrator.isRole(role_name));
        mCreatedRoleNames.add(role_name);
            // delete role immediately ...
        try {
            mAdministrator.deleteRole(role_name);
        } catch (URMException e) { err = e.getMessage(); mCreatedRoleNames.add(role_name); }
        assertFalse("The delete '"+role_name+"' failed.",
                        mAdministrator.isRole(role_name));
        mCreatedRoleNames.removeLast();
            // ... and create role again immidiately
        try { err = null;
            mAdministrator.createRole(role_name);
        } catch (URMException e) { err = e.getMessage(); }
        assertNotNull("Cannot get the just created '"+role_name+"' (2.) back("+err+").",
                        mAdministrator.getRole(role_name));
        mCreatedRoleNames.add(role_name);
        try {
            mAdministrator.createRole(role_name);
            assertFalse("Create a just created role did not throw an exception.", true);
        } catch (URMException e) { }
        
        assertTrue("Cannot get the added roles (3.) back.",
                containsValues(mAdministrator.getAllRoles(), TEST_ROLE1, TEST_ROLE2));
        assertTrue("Cannot get the added role '"+role_name+"' back.",
                containsValue(mAdministrator.getAllRoles(), role_name));
        // delete role
            // trying delete with GUEST role
        if (URMRoleImpl.contains(usr.getRoleMapping(), URMConstants.URM_ADMIN_ROLE))
            usr.deleteRoleLink(URMConstants.URM_ADMIN_ROLE);
        princ1 = princ1.copyPrincipal(URMConstants.URM_GUEST_ROLE);
        try {
            princ1.getURMAdministrator().deleteRole(role_name);
            mCreatedRoleNames.removeLast(); mCreatedRoleNames.removeLast();
            assertFalse("Deleting role with GUEST role did not throw an exception.", true);
        } catch (URMForbiddenException e) { }
        assertTrue("Deleting role with GUEST role was successful (but threw an exception).",
                        mAdministrator.isRole(role_name));
        usr.linkToRole(URMConstants.URM_ADMIN_ROLE);
        princ1 = princ1.copyPrincipal(URMConstants.URM_ADMIN_ROLE);
        princ1 = princ1.copyPrincipal(URMConstants.URM_GUEST_ROLE);
        try {
            princ1.getURMAdministrator().deleteRole(role_name);
            mCreatedRoleNames.removeLast(); mCreatedRoleNames.removeLast();
            assertFalse("Deleting role with GUEST role (but having also ADMIN role) did not throw an exception.", true);
        } catch (URMException e) { }
        assertTrue("Deleting role with GUEST role (but having also ADMIN role) was successful (but threw an exception).",
                        mAdministrator.isRole(role_name));
            // delete with ADMIN
        try {
            mAdministrator.deleteRole(role_name);
        } catch (URMException e) { err = e.getMessage(); }
        assertFalse("The delete '"+role_name+"' failed ("+err+").",
                        mAdministrator.isRole(role_name));
        mCreatedRoleNames.removeLast();
        try {
            mAdministrator.deleteRole(role_name);
            assertFalse("Delete a just deleted role did not throw an exception.", true);
        } catch (URMException e) { }
        
        assertNull("The removed role '"+role_name+"' still exists.",
                        mAdministrator.getRole(role_name));
        assertTrue("Cannot get the added roles (4.) back.",
                containsValues(mAdministrator.getAllRoles(), TEST_ROLE1, TEST_ROLE2));
        assertFalse("The removed role '"+role_name+"' is still among all roles.",
                containsValue(mAdministrator.getAllRoles(), role_name));
    }
    
    /** Implemented test cases:
     *
     * URMUser_0013, URMUser_0014, URMUser_0015, URMUser_0016, URMUser_0017,
     * URMUser_0018, URMUser_0019, URMUser_0020, URMUser_0021,
     */
    public void test2_addRemoveUserToFromRole() throws Exception {
        String errmsg = null;
        // ADDING
        URMRole role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        assertTrue("The '"+TEST_ROLE1+"' has already a member (nothing was added).",
                        role1.getUserMapping().size() <= 0);
        URMUser usr2 = mAdministrator.getUser(TEST_USER2, mDomain);
        assertNotNull("Cannot get the '"+TEST_USER2+"' back.", usr2);
        assertTrue("The '"+TEST_USER2+"' is already a member in a role (nothing was added).",
                        usr2.getRoleMapping().size() <= 0);
        try {
            usr2.linkToRole("link_user_to_this_non_existing_role");
            assertFalse("Creating link to a non existing role did not throw an exception.", true);
        } catch (URMException e) { }

            // check create without ADMIN role
        URMPrincipal princ1 = null;
        try { errmsg = null;
            princ1 = mAuthenticator.authenticateUser(TEST_USER1, TEST_USER1.toCharArray(), mDomain);
        } catch (URMException e) { errmsg = e.getMessage(); }
        assertNotNull("Cannot authenticate the '"+TEST_USER1+"' user ("+errmsg+").", princ1);
        URMUser usr = mAdministrator.getUser(TEST_USER1, mDomain);
        if (!URMRoleImpl.contains(usr.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            usr.linkToRole(URMConstants.URM_GUEST_ROLE);
        princ1.setActiveRole(URMConstants.URM_GUEST_ROLE);
        URMRole role1p1 = null;
        try {
            role1p1 = princ1.getURMAdministrator().getRole(TEST_ROLE1);
        } catch (URMForbiddenException e) {
            assertNull("Creating URMRole object of '"+TEST_ROLE1+"' threw an exception (without ADMIN role): "+e.getMessage(), e.getMessage());
        }
        try {
            role1p1.addUserLink(TEST_USER1, mDomain);
            assertFalse("Creating user-role link ('"+TEST_USER1+"'-'"+TEST_ROLE1+"') did not throw an exception (without ADMIN role).", true);
        } catch (URMForbiddenException e) { }

        role1.addUserLink(TEST_USER2, mDomain);
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_USER2+"'.",
                    containsValue(role1.getUserMapping(), TEST_USER2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_USER1+"' (not added).",
                    !containsValue(role1.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_USER2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(usr2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER2+"' is member in '"+TEST_ROLE2+"' (not added).",
                    !containsValue(usr2.getRoleMapping(), TEST_ROLE2));
            // check delete without ADMIN role
        try {
            role1p1.deleteUserLink(TEST_USER2, mDomain);
            assertFalse("Removing user-role link ('"+TEST_USER2+"'-'"+TEST_ROLE1+"') did not throw an exception (without ADMIN role).", true);
        } catch (URMForbiddenException e) { }
        
        URMRole role2 = mAdministrator.getRole(TEST_ROLE2);
        assertNotNull("Cannot get the '"+TEST_ROLE2+"' back.", role2);
        assertTrue("The role '"+TEST_ROLE2+"' has already a member.",
                        role2.getUserMapping().size() <= 0);
        URMUser usr1 = mAdministrator.getUser(TEST_USER1, mDomain);
        assertNotNull("Cannot get the '"+TEST_USER1+"' back.", usr1);
        // clear existing user-role mappings
        if (URMRoleImpl.contains(usr1.getRoleMapping(), URMConstants.URM_ADMIN_ROLE))
            usr1.deleteRoleLink(URMConstants.URM_ADMIN_ROLE);
        if (URMRoleImpl.contains(usr1.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            usr1.deleteRoleLink(URMConstants.URM_GUEST_ROLE);
        assertTrue("The '"+TEST_USER1+"' is already a member in a role (nothing was added) (using user obj).",
                        usr1.getRoleMapping().size() <= 0);

        role2.addUserLink(TEST_USER1, mDomain);
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_USER1+"'.",
                    containsValue(role2.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE2+"' (using user obj).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is member in '"+TEST_ROLE1+"'.",
                    !containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        // and again
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_USER2+"'.",
                    containsValue(role1.getUserMapping(), TEST_USER2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_USER1+"' (not added).",
                    !containsValue(role1.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_USER2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(usr2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER2+"' is member in '"+TEST_ROLE2+"' (not added).",
                    !containsValue(usr2.getRoleMapping(), TEST_ROLE2));
                    
        role1.addUserLink(TEST_USER1, mDomain);
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_USER1+"' or "+TEST_USER2+"'.",
                    containsValues(role1.getUserMapping(), TEST_USER1, TEST_USER2));
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_USER1+"'.",
                    containsValue(role2.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_ROLE2+"' contains '"+TEST_USER2+"' (not added).",
                    !containsValue(role2.getUserMapping(), TEST_USER2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE1+"'.",
                    containsValues(usr1.getRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(usr2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER2+"' is member in '"+TEST_ROLE2+"' (not added).",
                    !containsValue(usr2.getRoleMapping(), TEST_ROLE2));
        
        Set set = role1.getUserMapping();
        assertFalse("'"+TEST_ROLE1+"' contains more than two member.", set.size() > 2);
        set = role2.getUserMapping();
        assertFalse("'"+TEST_ROLE2+"' contains more than one member.", set.size() > 1);
        set = usr1.getRoleMapping();
        assertFalse("'"+TEST_USER1+"' is a member more than two role.", set.size() > 2);
        set = usr2.getRoleMapping();
        assertFalse("'"+TEST_USER2+"' is a member more than one role.", set.size() > 1);

        try {
            role1.addUserLink(TEST_USER1, mDomain);
            assertFalse("Creating existing user-role link ('"+TEST_USER1+"'-'"+TEST_ROLE1+"') did not throw an exception.", true);
        } catch (URMException e) { }
        try {
            usr2.deleteRoleLink("remove_user_from_this_non_existing_role");
            assertFalse("Removing a non existing role link (to a user) did not throw an exception.", true);
        } catch (URMException e) { }

        // REMOVING
        try { // removing a not existing member
            role2.deleteUserLink(TEST_USER2, mDomain);
            assertFalse("Removing a non existing member did not throw an exception.", true);
        } catch (URMException e) { }
        // should not have been changed anything
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_USER1+"' or "+TEST_USER2+"'.",
                    containsValues(role1.getUserMapping(), TEST_USER1, TEST_USER2));
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_USER1+"'.",
                    containsValue(role2.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_ROLE2+"' contains '"+TEST_USER2+"' (removed).",
                    !containsValue(role2.getUserMapping(), TEST_USER2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE1+"'.",
                    containsValues(usr1.getRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(usr2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER2+"' is member in '"+TEST_ROLE2+"' (removed).",
                    !containsValue(usr2.getRoleMapping(), TEST_ROLE2));
        
        role1.deleteUserLink(TEST_USER1, mDomain);
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_USER1+"'.",
                    containsValue(role2.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is still member in '"+TEST_ROLE1+"'.",
                    !containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        // and again
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_USER2+"'.",
                    containsValue(role1.getUserMapping(), TEST_USER2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_USER1+"' (removed).",
                    !containsValue(role1.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_USER2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(usr2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER2+"' is member in '"+TEST_ROLE2+"' (removed).",
                    !containsValue(usr2.getRoleMapping(), TEST_ROLE2));

        role2.deleteUserLink(TEST_USER1, mDomain);
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_USER2+"'.",
                    containsValue(role1.getUserMapping(), TEST_USER2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_USER1+"' (removed).",
                    !containsValue(role1.getUserMapping(), TEST_USER1));
        assertTrue("The '"+TEST_USER2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(usr2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is member in '"+TEST_ROLE1+"' (removed).",
                    !containsValue(usr1.getRoleMapping(), TEST_ROLE1));

        role1.deleteUserLink(TEST_USER2, mDomain);
        // empty roles checks
        role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        assertTrue("The '"+TEST_ROLE1+"' has already a member (everything is removed).",
                        role1.getUserMapping().size() <= 0);
        usr2 = mAdministrator.getUser(TEST_USER2, mDomain);
        assertNotNull("Cannot get the '"+TEST_USER2+"' back.", usr2);
        assertTrue("The '"+TEST_USER2+"' is already a member in a role (everything is removed).",
                        usr2.getRoleMapping().size() <= 0);
        role2 = mAdministrator.getRole(TEST_ROLE2);
        assertNotNull("Cannot get the '"+TEST_ROLE2+"' back.", role2);
        assertTrue("The role '"+TEST_ROLE2+"' has already a member.",
                        role2.getUserMapping().size() <= 0);
        usr1 = mAdministrator.getUser(TEST_USER1, mDomain);
        assertNotNull("Cannot get the '"+TEST_USER1+"' back.", usr1);
        assertTrue("The '"+TEST_USER1+"' is already a member in a role (everything is removed).",
                        usr1.getRoleMapping().size() <= 0);
    }
    
    /** Implemented test cases:
     *
     * URMGroup_0015, URMGroup_0016, URMGroup_0017, URMGroup_0018,
     */
    public void test3_addRemoveGroupToFromRole() throws Exception {
        String errmsg = null;
        // ADDING
        URMRole role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        assertTrue("The '"+TEST_ROLE1+"' has already a member (nothing was added).",
                        role1.getGroupMapping().size() <= 0);
        URMGroup grp2 = mAdministrator.getGroup(TEST_GROUP2, mDomain);
        assertNotNull("Cannot get the '"+TEST_GROUP2+"' back.", grp2);
        assertTrue("The '"+TEST_GROUP2+"' is already a member in a role (nothing was added).",
                        grp2.getRoleMapping().size() <= 0);
        try {
            grp2.linkToRole("link_group_to_this_non_existing_role");
            assertFalse("Creating link to a non existing role did not throw an exception.", true);
        } catch (URMException e) { }

            // check create without ADMIN role
        URMPrincipal princ1 = null;
        try { errmsg = null;
            princ1 = mAuthenticator.authenticateUser(TEST_USER1, TEST_USER1.toCharArray(), mDomain);
        } catch (URMException e) { errmsg = e.getMessage(); }
        assertNotNull("Cannot authenticate the '"+TEST_GROUP1+"' group ("+errmsg+").", princ1);
        URMUser usr = mAdministrator.getUser(TEST_USER1, mDomain);
        if (!URMRoleImpl.contains(usr.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            usr.linkToRole(URMConstants.URM_GUEST_ROLE);
        princ1.setActiveRole(URMConstants.URM_GUEST_ROLE);
        URMRole role1p1 = null;
        try {
            role1p1 = princ1.getURMAdministrator().getRole(TEST_ROLE1);
        } catch (URMForbiddenException e) {
            assertNull("Creating URMRole object of '"+TEST_ROLE1+"' threw an exception (without ADMIN role): "+e.getMessage(), e.getMessage());
        }
        try {
            role1p1.addGroupLink(TEST_GROUP1, mDomain);
            assertFalse("Creating group-role link ('"+TEST_GROUP1+"'-'"+TEST_ROLE1+"') did not throw an exception (without ADMIN role).", true);
        } catch (URMForbiddenException e) { }

        role1.addGroupLink(TEST_GROUP2, mDomain);
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_GROUP2+"'.",
                    containsValue(role1.getGroupMapping(), TEST_GROUP2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_GROUP1+"' (not added).",
                    !containsValue(role1.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_GROUP2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(grp2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP2+"' is member in '"+TEST_ROLE2+"' (not added).",
                    !containsValue(grp2.getRoleMapping(), TEST_ROLE2));
            // check delete without ADMIN role
        try {
            role1p1.deleteGroupLink(TEST_GROUP2, mDomain);
            assertFalse("Removing group-role link ('"+TEST_GROUP2+"'-'"+TEST_ROLE1+"') did not throw an exception (without ADMIN role).", true);
        } catch (URMForbiddenException e) { }
        
        URMRole role2 = mAdministrator.getRole(TEST_ROLE2);
        assertNotNull("Cannot get the '"+TEST_ROLE2+"' back.", role2);
        assertTrue("The role '"+TEST_ROLE2+"' has already a member.",
                        role2.getGroupMapping().size() <= 0);
        URMGroup grp1 = mAdministrator.getGroup(TEST_GROUP1, mDomain);
        assertNotNull("Cannot get the '"+TEST_GROUP1+"' back.", grp1);
        // clear existing group-role mappings
        if (URMRoleImpl.contains(grp1.getRoleMapping(), URMConstants.URM_ADMIN_ROLE))
            grp1.deleteRoleLink(URMConstants.URM_ADMIN_ROLE);
        if (URMRoleImpl.contains(grp1.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            grp1.deleteRoleLink(URMConstants.URM_GUEST_ROLE);
        assertTrue("The '"+TEST_GROUP1+"' is already a member in a role (nothing was added) (using group obj).",
                        grp1.getRoleMapping().size() <= 0);

        role2.addGroupLink(TEST_GROUP1, mDomain);
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_GROUP1+"'.",
                    containsValue(role2.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE2+"' (using group obj).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE1+"'.",
                    !containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        // and again
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_GROUP2+"'.",
                    containsValue(role1.getGroupMapping(), TEST_GROUP2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_GROUP1+"' (not added).",
                    !containsValue(role1.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_GROUP2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(grp2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP2+"' is member in '"+TEST_ROLE2+"' (not added).",
                    !containsValue(grp2.getRoleMapping(), TEST_ROLE2));
                    
        role1.addGroupLink(TEST_GROUP1, mDomain);
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_GROUP1+"' or "+TEST_GROUP2+"'.",
                    containsValues(role1.getGroupMapping(), TEST_GROUP1, TEST_GROUP2));
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_GROUP1+"'.",
                    containsValue(role2.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_ROLE2+"' contains '"+TEST_GROUP2+"' (not added).",
                    !containsValue(role2.getGroupMapping(), TEST_GROUP2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE1+"'.",
                    containsValues(grp1.getRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(grp2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP2+"' is member in '"+TEST_ROLE2+"' (not added).",
                    !containsValue(grp2.getRoleMapping(), TEST_ROLE2));
        
        Set set = role1.getGroupMapping();
        assertFalse("'"+TEST_ROLE1+"' contains more than two member.", set.size() > 2);
        set = role2.getGroupMapping();
        assertFalse("'"+TEST_ROLE2+"' contains more than one member.", set.size() > 1);
        set = grp1.getRoleMapping();
        assertFalse("'"+TEST_GROUP1+"' is a member more than two role.", set.size() > 2);
        set = grp2.getRoleMapping();
        assertFalse("'"+TEST_GROUP2+"' is a member more than one role.", set.size() > 1);

        try {
            role1.addGroupLink(TEST_GROUP1, mDomain);
            assertFalse("Creating existing group-role link ('"+TEST_GROUP1+"'-'"+TEST_ROLE1+"') did not throw an exception.", true);
        } catch (URMException e) { }
        try {
            grp2.deleteRoleLink("remove_group_from_this_non_existing_role");
            assertFalse("Removing a non existing role link (to a group) did not throw an exception.", true);
        } catch (URMException e) { }

        // REMOVING
        try { // removing a not existing member
            role2.deleteGroupLink(TEST_GROUP2, mDomain);
            assertFalse("Removing a non existing member did not throw an exception.", true);
        } catch (URMException e) { }
        // should not have been changed anything
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_GROUP1+"' or "+TEST_GROUP2+"'.",
                    containsValues(role1.getGroupMapping(), TEST_GROUP1, TEST_GROUP2));
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_GROUP1+"'.",
                    containsValue(role2.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_ROLE2+"' contains '"+TEST_GROUP2+"' (removed).",
                    !containsValue(role2.getGroupMapping(), TEST_GROUP2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE1+"'.",
                    containsValues(grp1.getRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(grp2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP2+"' is member in '"+TEST_ROLE2+"' (removed).",
                    !containsValue(grp2.getRoleMapping(), TEST_ROLE2));
        
        role1.deleteGroupLink(TEST_GROUP1, mDomain);
        assertTrue("The '"+TEST_ROLE2+"' does not contain '"+TEST_GROUP1+"'.",
                    containsValue(role2.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is still member in '"+TEST_ROLE1+"'.",
                    !containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        // and again
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_GROUP2+"'.",
                    containsValue(role1.getGroupMapping(), TEST_GROUP2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_GROUP1+"' (removed).",
                    !containsValue(role1.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_GROUP2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(grp2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP2+"' is member in '"+TEST_ROLE2+"' (removed).",
                    !containsValue(grp2.getRoleMapping(), TEST_ROLE2));

        role2.deleteGroupLink(TEST_GROUP1, mDomain);
        assertTrue("The '"+TEST_ROLE1+"' does not contain '"+TEST_GROUP2+"'.",
                    containsValue(role1.getGroupMapping(), TEST_GROUP2));
        assertTrue("The '"+TEST_ROLE1+"' contains '"+TEST_GROUP1+"' (removed).",
                    !containsValue(role1.getGroupMapping(), TEST_GROUP1));
        assertTrue("The '"+TEST_GROUP2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValue(grp2.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE1+"' (removed).",
                    !containsValue(grp1.getRoleMapping(), TEST_ROLE1));

        role1.deleteGroupLink(TEST_GROUP2, mDomain);
        // empty roles checks
        role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        assertTrue("The '"+TEST_ROLE1+"' has already a member (everything is removed).",
                        role1.getGroupMapping().size() <= 0);
        grp2 = mAdministrator.getGroup(TEST_GROUP2, mDomain);
        assertNotNull("Cannot get the '"+TEST_GROUP2+"' back.", grp2);
        assertTrue("The '"+TEST_GROUP2+"' is already a member in a role (everything is removed).",
                        grp2.getRoleMapping().size() <= 0);
        role2 = mAdministrator.getRole(TEST_ROLE2);
        assertNotNull("Cannot get the '"+TEST_ROLE2+"' back.", role2);
        assertTrue("The role '"+TEST_ROLE2+"' has already a member.",
                        role2.getGroupMapping().size() <= 0);
        grp1 = mAdministrator.getGroup(TEST_GROUP1, mDomain);
        assertNotNull("Cannot get the '"+TEST_GROUP1+"' back.", grp1);
        assertTrue("The '"+TEST_GROUP1+"' is already a member in a role (everything is removed).",
                        grp1.getRoleMapping().size() <= 0);
    }
    
    public void test4_getAllAncestors() throws Exception {
        // add
        URMRole role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        assertTrue("The '"+TEST_ROLE1+"' has already an ancestor (1.) (nothing was added).",
                                role1.getAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE1+"' has already an ancestor (2.) (nothing was added).",
                                role1.getAllAncestors().size() <= 0);

        try {
            role1.addAncestor(TEST_ROLE1);
            assertTrue("Circular dependency could be successfully created (1.).", false);
        } catch (URMException e) { }
                    
        role1.addAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_ROLE2+"' is not member in '"+TEST_ROLE1+"' (1.).",
                    containsValue(role1.getAncestors(), TEST_ROLE2));
        assertFalse("The '"+TEST_ROLE3+"' is member in '"+TEST_ROLE1+"' (1.) (it was not added).",
                    containsValue(role1.getAncestors(), TEST_ROLE3));
        assertTrue("The '"+TEST_ROLE2+"' is not member in '"+TEST_ROLE1+"' (2.).",
                    containsValue(role1.getAllAncestors(), TEST_ROLE2));
        assertFalse("The '"+TEST_ROLE3+"' is member in '"+TEST_ROLE1+"' (2.) (it was not added).",
                    containsValue(role1.getAllAncestors(), TEST_ROLE3));

        URMRole role2 = mAdministrator.getRole(TEST_ROLE2);
        assertNotNull("Cannot get the '"+TEST_ROLE2+"' back.", role2);
        assertTrue("The '"+TEST_ROLE2+"' is already a member (1.) (nothing was added).",
                                role2.getAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE2+"' is already a member (2.) (nothing was added).",
                                role2.getAllAncestors().size() <= 0);

        try {
            role2.addAncestor(TEST_ROLE1);
            assertTrue("Circular dependency could be successfully created (2.).", false);
        } catch (URMException e) { }
                    
        role2.addAncestor(TEST_ROLE3);
        assertTrue("The '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"' (1.).",
                    containsValue(role2.getAncestors(), TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE2+"' (1.) (it was not added).",
                    containsValue(role2.getAncestors(), TEST_ROLE1));
        assertTrue("The '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"' (2.).",
                    containsValue(role2.getAllAncestors(), TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE2+"' (2.) (it was not added).",
                    containsValue(role2.getAllAncestors(), TEST_ROLE1));
        
        assertFalse("The '"+TEST_ROLE2+"' or '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValues(role1.getAncestors(), TEST_ROLE2, TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE3+"' is member in '"+TEST_ROLE1+"' (it was not added).",
                    containsValue(role1.getAncestors(), TEST_ROLE1));
        assertTrue("The '"+TEST_ROLE2+"' or '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValues(role1.getAllAncestors(), TEST_ROLE2, TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE1+"' (it was not added).",
                    containsValue(role1.getAllAncestors(), TEST_ROLE1));

        URMRole role3 = mAdministrator.getRole(TEST_ROLE3);
        assertNotNull("Cannot get the '"+TEST_ROLE3+"' back.", role3);
        assertTrue("The '"+TEST_ROLE3+"' is already a member (1.) (nothing was added).",
                                role3.getAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE3+"' is already a member (2.) (nothing was added).",
                                role3.getAllAncestors().size() <= 0);
        try {
            role3.addAncestor(TEST_ROLE1);
            assertTrue("Circular dependency could be successfully created (3.).", false);
        } catch (URMException e) { }
        
        role2.addAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAncestors(), TEST_ROLE3));
        assertTrue("The '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAncestors(), TEST_ROLE4));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(role2.getAncestors(), TEST_ROLE1));
        assertTrue("The '"+TEST_ROLE3+"' or '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValues(role2.getAllAncestors(), TEST_ROLE3, TEST_ROLE4));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(role2.getAllAncestors(), TEST_ROLE1));
        
        assertFalse("The '"+TEST_ROLE2+"' or '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValues(role1.getAncestors(), TEST_ROLE2, TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE3+"' is member in '"+TEST_ROLE1+"' (it was not added).",
                    containsValue(role1.getAncestors(), TEST_ROLE1));
        assertTrue("The '"+TEST_ROLE2+"' or '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValues(role1.getAllAncestors(), TEST_ROLE2, TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE1+"' (it was not added).",
                    containsValue(role1.getAncestors(), TEST_ROLE1));
                    
        role1 = mAdministrator.getRole(TEST_ROLE1); // test all roles role1
        assertTrue("The '"+TEST_ROLE2+"' or '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValues(role1.getAllAncestors(), TEST_ROLE2, TEST_ROLE3));
        assertTrue("The '"+TEST_ROLE4+"' or '"+TEST_ROLE2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValues(role1.getAllAncestors(), TEST_ROLE4, TEST_ROLE2));
        role2 = mAdministrator.getRole(TEST_ROLE2); // test all roles role2
        assertTrue("The '"+TEST_ROLE4+"' or '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValues(role2.getAllAncestors(), TEST_ROLE4, TEST_ROLE3));

        URMRole role4 = mAdministrator.getRole(TEST_ROLE4);
        try {
            role4.addAncestor(TEST_ROLE1);
            assertTrue("Circular dependency could be successfully created (4.).", false);
        } catch (URMException e) { }
        
        // delete
        role1.deleteAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (nothing was added).",
                                role1.getAllAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAncestors(), TEST_ROLE3));
        assertTrue("The '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAncestors(), TEST_ROLE4));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(role2.getAncestors(), TEST_ROLE1));
        assertTrue("The '"+TEST_ROLE3+"' or '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValues(role2.getAllAncestors(), TEST_ROLE3, TEST_ROLE4));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(role2.getAllAncestors(), TEST_ROLE1));
        
        role1 = mAdministrator.getRole(TEST_ROLE1); // test all roles role1
        assertFalse("The '"+TEST_ROLE2+"' or '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValues(role1.getAllAncestors(), TEST_ROLE2, TEST_ROLE3));
        assertFalse("The '"+TEST_ROLE4+"' or '"+TEST_ROLE2+"' is not member in '"+TEST_ROLE1+"'.",
                    containsValues(role1.getAllAncestors(), TEST_ROLE4, TEST_ROLE2));
        role2 = mAdministrator.getRole(TEST_ROLE2); // test all roles role2
        assertTrue("The '"+TEST_ROLE4+"' or '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValues(role2.getAllAncestors(), TEST_ROLE4, TEST_ROLE3));

        role2.deleteAncestor(TEST_ROLE3);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (nothing was added).",
                                role1.getAllAncestors().size() <= 0);
        assertFalse("The '"+TEST_ROLE3+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAncestors(), TEST_ROLE3));
        assertTrue("The '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAncestors(), TEST_ROLE4));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(role2.getAncestors(), TEST_ROLE1));
        assertFalse("The '"+TEST_ROLE3+"' or '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValues(role2.getAllAncestors(), TEST_ROLE3, TEST_ROLE4));
        assertFalse("The '"+TEST_ROLE1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(role2.getAllAncestors(), TEST_ROLE1));
        
        assertTrue("The '"+TEST_ROLE4+"' is not member in '"+TEST_ROLE2+"'.",
                    containsValue(role2.getAllAncestors(), TEST_ROLE4));
                    
        role2.deleteAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (everything was removed).",
                                role1.getAllAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE2+"' is already a member (everything was removed).",
                                role2.getAllAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE3+"' is already a member (everything was removed).",
                                role3.getAllAncestors().size() <= 0);
        assertTrue("The '"+TEST_ROLE4+"' is already a member (everything was removed).",
                                role4.getAllAncestors().size() <= 0);
    }
    
    /** Implemented test cases:
     *
     * URMUser_0025, URMUser_0030
     */
    public void test5_getAllRoleMappingOfUser() throws Exception {
        // add
        URMRole role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        URMUser usr1 = mAdministrator.getUser(TEST_USER1, mDomain);
        for (Iterator iter = usr1.getRoleMapping().iterator(); iter. hasNext(); )
            usr1.deleteRoleLink(((URMRole)iter.next()).getName());
        assertTrue("The '"+TEST_USER1+"' has already role mapping (1.) (nothing was added).",
                                usr1.getRoleMapping().size() <= 0);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (2.) (nothing was added).",
                                usr1.getAllRoleMapping().size() <= 0);
                                
        usr1.linkToRole(TEST_ROLE1);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (1.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (2.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE1));
        
        role1.addAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (3.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (it was not added).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        
        URMRole role2 = mAdministrator.getRole(TEST_ROLE2);
        role2.addAncestor(TEST_ROLE3);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (4.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE3));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE3+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE2+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE3, TEST_ROLE2));
        
        URMRole role3 = mAdministrator.getRole(TEST_ROLE3);
        role3.addAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (5.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (it was not added).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE4));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE3+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE4+"' or '"+TEST_ROLE2+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE4, TEST_ROLE2));
        // change
        role3.deleteAncestor(TEST_ROLE4);
        role2.addAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (6.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (it was not added).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE4+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE2+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE4, TEST_ROLE2));
        
        role1 = mAdministrator.getRole(TEST_ROLE1);
        role2 = mAdministrator.getRole(TEST_ROLE2);
        role2.deleteAncestor(TEST_ROLE3);
        usr1.linkToRole(TEST_ROLE3);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (7.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' (7.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (it was not added).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE4));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE4+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE4, TEST_ROLE2));
                    
        role1.deleteAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (8.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' (8.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (8.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (8.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (8.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (8.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE3+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));

        role1.addAncestor(TEST_ROLE2);
        usr1.deleteRoleLink(TEST_ROLE1);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' (9.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (9.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (9.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE1+"' (9.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (all 9.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (all 9.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE1+"' (all 9.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' (9.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE3));

        usr1.linkToRole(TEST_ROLE1);

        // remove
        role2.deleteAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (10.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (it was not added) (10.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"' (10.).",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE2+"' (10).",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE3, TEST_ROLE2));
                    
        usr1.deleteRoleLink(TEST_ROLE3);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (10.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"'.",
                    containsValues(usr1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (10.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE3+"' (10.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (all 10.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE3+"' (all 10.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE3));
        
        role1.deleteAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (11.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_USER1+"' is not member in '"+TEST_ROLE1+"' (11.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (11.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (11.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE3+"' (11.).",
                    containsValue(usr1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE2+"' (all 11.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE4+"' (all 11.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_USER1+"' is member in '"+TEST_ROLE3+"' (all 11.).",
                    containsValue(usr1.getAllRoleMapping(), TEST_ROLE3));
        
        usr1.deleteRoleLink(TEST_ROLE1);
        assertTrue("The '"+TEST_USER1+"' has already role mapping (1.) (everything was removed).",
                                usr1.getRoleMapping().size() <= 0);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (2.) (everything was removed).",
                                usr1.getAllRoleMapping().size() <= 0);
    }
    
    /** Implemented test cases:
     *
     * URMGroup_0024
     */
    public void test6_getAllRoleMappingOfGroup() throws Exception {
        // add
        URMRole role1 = mAdministrator.getRole(TEST_ROLE1);
        assertNotNull("Cannot get the '"+TEST_ROLE1+"' back.", role1);
        URMGroup grp1 = mAdministrator.getGroup(TEST_GROUP1, mDomain);
        assertTrue("The '"+TEST_GROUP1+"' has already role mapping (1.) (nothing was added).",
                                grp1.getRoleMapping().size() <= 0);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (2.) (nothing was added).",
                                grp1.getAllRoleMapping().size() <= 0);
                                
        grp1.linkToRole(TEST_ROLE1);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (1.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (2.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE1));
        
        role1.addAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (3.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (it was not added).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        
        URMRole role2 = mAdministrator.getRole(TEST_ROLE2);
        role2.addAncestor(TEST_ROLE3);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (4.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE3+"' (it was not added).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE3));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE3+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE2+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE3, TEST_ROLE2));
        
        URMRole role3 = mAdministrator.getRole(TEST_ROLE3);
        role3.addAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (5.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (it was not added).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE4));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE3+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE4+"' or '"+TEST_ROLE2+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE4, TEST_ROLE2));
        // change
        role3.deleteAncestor(TEST_ROLE4);
        role2.addAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (6.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (it was not added).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE4+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE2+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE4, TEST_ROLE2));
        
        role1 = mAdministrator.getRole(TEST_ROLE1);
        role2 = mAdministrator.getRole(TEST_ROLE2);
        role2.deleteAncestor(TEST_ROLE3);
        grp1.linkToRole(TEST_ROLE3);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (7.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' (7.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (it was not added).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE4));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE4+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE4, TEST_ROLE2));
                    
        role1.deleteAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (8.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' (8.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (8.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (8.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (8.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (8.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE3+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));

        role1.addAncestor(TEST_ROLE2);
        grp1.deleteRoleLink(TEST_ROLE1);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' (9.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (9.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (9.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE1+"' (9.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (all 9.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (all 9.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE1+"' (all 9.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' (9.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE3));

        grp1.linkToRole(TEST_ROLE1);

        // remove
        role2.deleteAncestor(TEST_ROLE4);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (10.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (it was not added) (10.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"' (10.).",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE3));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE3+"' or '"+TEST_ROLE2+"' (10).",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE3, TEST_ROLE2));
                    
        grp1.deleteRoleLink(TEST_ROLE3);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (10.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' or '"+TEST_ROLE2+"'.",
                    containsValues(grp1.getAllRoleMapping(), TEST_ROLE1, TEST_ROLE2));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (10.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE3+"' (10.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (all 10.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE3+"' (all 10.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE3));
        
        role1.deleteAncestor(TEST_ROLE2);
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (11.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE1));
        assertTrue("The '"+TEST_GROUP1+"' is not member in '"+TEST_ROLE1+"' (11.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE1));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (11.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (11.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE3+"' (11.).",
                    containsValue(grp1.getRoleMapping(), TEST_ROLE3));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE2+"' (all 11.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE2));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE4+"' (all 11.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE4));
        assertFalse("The '"+TEST_GROUP1+"' is member in '"+TEST_ROLE3+"' (all 11.).",
                    containsValue(grp1.getAllRoleMapping(), TEST_ROLE3));
        
        grp1.deleteRoleLink(TEST_ROLE1);
        assertTrue("The '"+TEST_GROUP1+"' has already role mapping (1.) (everything was removed).",
                                grp1.getRoleMapping().size() <= 0);
        assertTrue("The '"+TEST_ROLE1+"' is already a member (2.) (everything was removed).",
                                grp1.getAllRoleMapping().size() <= 0);
    }
    
    public void test7_setGetRoleAggregatedProperty() throws Exception {
        URMUser usr2 = mAdministrator.getUser(TEST_USER2, mDomain);
        assertNotNull("Cannot get the '"+TEST_USER2+"' back.", usr2);

        String aggr_role1 = "URM_junit_test_aggr_props_role1";
        String aggr_role2 = "URM_junit_test_aggr_props_role2";
        String aggr_role3 = "URM_junit_test_aggr_props_role3";
        mAdministrator.createRole(aggr_role1); mCreatedRoleNames.add(aggr_role1);
        mAdministrator.createRole(aggr_role2); mCreatedRoleNames.add(aggr_role2);
        mAdministrator.createRole(aggr_role3); mCreatedRoleNames.add(aggr_role3);
        URMRole role1 = mAdministrator.getRole(aggr_role1);
        assertNotNull("Cannot get the '"+aggr_role1+"' back.", role1);
        URMRole role2 = mAdministrator.getRole(aggr_role2);
        assertNotNull("Cannot get the '"+aggr_role2+"' back.", role2);
        URMRole role3 = mAdministrator.getRole(aggr_role3);
        assertNotNull("Cannot get the '"+aggr_role3+"' back.", role3);

        // prepare GUEST role
        URMPrincipal princ1 = null;
        String errmsg = null;
        try {
            princ1 = mAuthenticator.authenticateUser(TEST_USER2, TEST_USER2.toCharArray(), mDomain);
        } catch (URMException e) { errmsg = e.getMessage(); }
        assertNotNull("Cannot authenticate the '"+TEST_USER1+"' role ("+errmsg+").", princ1);
        if (!URMRoleImpl.contains(usr2.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            usr2.linkToRole(URMConstants.URM_GUEST_ROLE);
        princ1.setActiveRole(URMConstants.URM_GUEST_ROLE);
    
        // set metaproperties from config
        URMConfigurator propconf = mTestConfigurator.getSubConfigurator(
                                    "Administrator/UserDatabase/TestProperties");
            // set the properties from the 'Role3' node
        URMConfigurator roleprops = propconf.getSubConfigurator("Role3");
        Properties gsprops3 = URMConfiguratorUtil.getNodeAttrsAsProperties(
                                roleprops, "Property", "name", "value");
        assertNotNull("Cannot read the 'Role3' test properties from the config file.", gsprops3);
        roleprops = propconf.getSubConfigurator("Role2");
        Properties gsprops2 = URMConfiguratorUtil.getNodeAttrsAsProperties(
                                roleprops, "Property", "name", "value");
        roleprops = propconf.getSubConfigurator("Role1");
        Properties gsprops1 = URMConfiguratorUtil.getNodeAttrsAsProperties(
                                roleprops, "Property", "name", "value");
        assertNotNull("Cannot read the 'Role1' test properties from the config file.", gsprops1);
        // remove not common props
        for (Iterator iter = (new HashSet(gsprops3.keySet())).iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            if (gsprops2.getProperty(key) == null)
                gsprops3.remove(key);
            else if (gsprops1.getProperty(key) == null)
                gsprops3.remove(key);
        }
        for (Iterator iter = (new HashSet(gsprops2.keySet())).iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            if (gsprops3.getProperty(key) == null) {
                gsprops2.remove(key);
                gsprops1.remove(key);
            }
        }
        // ADDING
        // add role to role2 and check again
        role2.addAncestor(aggr_role1);
        // set role props with GUEST role
        try { errmsg = null;
            princ1.getURMAdministrator().getRole(aggr_role1).setProperties(gsprops3);
            assertTrue("Setting role properties with GUEST role did not throw an exception.", false);
        } catch (URMException e) { errmsg = e.getMessage(); }
        // set role props with ADMIN role
        role1.setProperties(gsprops1);
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the '"+key+"' role property back.", rgaprops.size() < 1);
            assertFalse("There are more than one aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 1);
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        gsprops1.getProperty(key)+"' but it was set to '"+rgaprops.toArray()[0]+"'.",
                        gsprops1.getProperty(key).equals(rgaprops.toArray()[0]));
        }
        // add role to role3 and check again
        role2.addAncestor(aggr_role3);
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the '"+key+"' role property back.", rgaprops.size() < 1);
            assertFalse("There are more than one aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 1);
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        gsprops1.getProperty(key)+"' but it was set to '"+rgaprops.toArray()[0]+"'.",
                        gsprops1.getProperty(key).equals(rgaprops.toArray()[0]));
        }
        role3.setProperties(gsprops3);
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the two aggregated role property of the '"+key+"' back.", rgaprops.size() < 2);
            assertFalse("There are more than two aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 2);
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        rgaprops.toArray()[0]+"' and '"+rgaprops.toArray()[1]+"' but it was set to '"+
                        gsprops1.getProperty(key)+"' and '"+gsprops3.getProperty(key)+"'.",
                            (gsprops1.getProperty(key).equals(rgaprops.toArray()[0]) &&
                                gsprops3.getProperty(key).equals(rgaprops.toArray()[1])) ||
                            (gsprops1.getProperty(key).equals(rgaprops.toArray()[1]) &&
                                gsprops3.getProperty(key).equals(rgaprops.toArray()[0])));
        }
        // set role props with GUEST role
        try { errmsg = null;
            princ1.getURMAdministrator().getRole(aggr_role2).setProperties(gsprops3);
            assertTrue("Setting role properties with GUEST role did not throw an exception.", false);
        } catch (URMException e) { errmsg = e.getMessage(); }
        if (URMRoleImpl.contains(usr2.getRoleMapping(), URMConstants.URM_GUEST_ROLE))
            usr2.deleteRoleLink(URMConstants.URM_GUEST_ROLE);
        // set role props with ADMIN role
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the two aggregated role property of the '"+key+"' back.", rgaprops.size() < 2);
            assertFalse("There are more than two aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 2);
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        rgaprops.toArray()[0]+"' and '"+rgaprops.toArray()[1]+"' but it was set to '"+
                        gsprops1.getProperty(key)+"' and '"+gsprops3.getProperty(key)+"'.",
                            (gsprops1.getProperty(key).equals(rgaprops.toArray()[0]) &&
                                gsprops3.getProperty(key).equals(rgaprops.toArray()[1])) ||
                            (gsprops1.getProperty(key).equals(rgaprops.toArray()[1]) &&
                                gsprops3.getProperty(key).equals(rgaprops.toArray()[0])));
        }
        role2.setProperties(gsprops2);
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the three aggregated role property of the '"+key+"' back.", rgaprops.size() < 3);
            assertFalse("There are more than three aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 3);
            int counter = 0;
            for (int i = 0; i < 3; ++i)
                if (gsprops3.getProperty(key).equals(rgaprops.toArray()[i])) ++counter;
                else if (gsprops2.getProperty(key).equals(rgaprops.toArray()[i])) ++counter;
                else if (gsprops1.getProperty(key).equals(rgaprops.toArray()[i])) ++counter;
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        rgaprops.toArray()[0]+"', '"+rgaprops.toArray()[1]+"' and '"+rgaprops.toArray()[2]+"'" +
                        " but it was set to '"+gsprops3.getProperty(key)+"', '"+gsprops2.getProperty(key)+
                        "' and '"+gsprops1.getProperty(key)+"'.", counter == 3);
        }
        // REMOVING
        // removes role to role2 and check again
        role2.deleteAncestor(aggr_role1);
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the two aggregated role property of the '"+key+"' back.", rgaprops.size() < 2);
            assertFalse("There are more than two aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 2);
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        rgaprops.toArray()[0]+"' and '"+rgaprops.toArray()[1]+"' but it was set to '"+
                        gsprops3.getProperty(key)+"' and '"+gsprops2.getProperty(key)+"'.",
                            (gsprops3.getProperty(key).equals(rgaprops.toArray()[0]) &&
                                gsprops2.getProperty(key).equals(rgaprops.toArray()[1])) ||
                            (gsprops3.getProperty(key).equals(rgaprops.toArray()[1]) &&
                                gsprops2.getProperty(key).equals(rgaprops.toArray()[0])));
        }
        // removes role to role3 and check again
        role2.deleteAncestor(aggr_role3);
        for (Iterator iter = gsprops3.keySet().iterator(); iter.hasNext(); ) {
            String key = (String)iter.next();
            Set rgaprops = role2.getAggregatedProperty(key);
            assertFalse("Cannot get the '"+key+"' role property back.", rgaprops.size() < 1);
            assertFalse("There are more than one aggregated role property for '"+key+
                            "' but just one was set.", rgaprops.size() > 1);
            assertTrue("The aggregated role property '"+key+"' has the value '"+
                        gsprops2.getProperty(key)+"' but it was set to '"+rgaprops.toArray()[0]+"'.",
                        gsprops2.getProperty(key).equals(rgaprops.toArray()[0]));
        }
    }
    
    public void test8_getAllAncestorsAgain() throws Exception {
        String ltest_role1 = "URM_junit_test_roleallroles_role1";
        String ltest_role2 = "URM_junit_test_roleallroles_role2";
        String ltest_role3 = "URM_junit_test_roleallroles_role3";
        String ltest_role4 = "URM_junit_test_roleallroles_role4";
        String ltest_role5 = "URM_junit_test_roleallroles_role5";
        mAdministrator.createRole(ltest_role1); mCreatedRoleNames.add(ltest_role1);
        mAdministrator.createRole(ltest_role2); mCreatedRoleNames.add(ltest_role2);
        mAdministrator.createRole(ltest_role3); mCreatedRoleNames.add(ltest_role3);
        mAdministrator.createRole(ltest_role4); mCreatedRoleNames.add(ltest_role4);
        mAdministrator.createRole(ltest_role5); mCreatedRoleNames.add(ltest_role5);
        // adding
        URMRole role = mAdministrator.getRole(TEST_ROLE1);
        assertTrue("Role "+TEST_ROLE1+" is already member in a role (nothing was added 1.)", role.getAllAncestors().size() == 0);
        mAdministrator.getRole(TEST_ROLE1).addAncestor(ltest_role1);
        assertFalse("Role "+TEST_ROLE1+" is not member in any roles (one was added 1.)", role.getAllAncestors().size() < 1);
        assertFalse("Role "+TEST_ROLE1+" is member in more than one roles (just one was added 1.)", role.getAllAncestors().size() > 1);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" (it was added 1.)",
                        containsValue(role.getAllAncestors(), ltest_role1));

        mAdministrator.getRole(ltest_role1).addAncestor(ltest_role2);
        assertFalse("Role "+TEST_ROLE1+" is not member in less than two roles (two was added)", role.getAllAncestors().size() < 2);
        assertFalse("Role "+TEST_ROLE1+" is member in more than two roles (just two was added)", role.getAllAncestors().size() > 2);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role2+" (it was added)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role2));

        mAdministrator.getRole(ltest_role2).addAncestor(ltest_role3);
        assertFalse("Role "+TEST_ROLE1+" is not member in less than three roles (three was added)", role.getAllAncestors().size() < 3);
        assertFalse("Role "+TEST_ROLE1+" is member in more than three roles (just three was added)", role.getAllAncestors().size() > 3);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role3+" (it was added)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role3));

        mAdministrator.getRole(ltest_role3).addAncestor(ltest_role4);
        assertFalse("Role "+TEST_ROLE1+" is not member in less than four roles (four was added 1.)", role.getAllAncestors().size() < 4);
        assertFalse("Role "+TEST_ROLE1+" is member in more than four roles (just four was added 1.)", role.getAllAncestors().size() > 4);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 1.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role4+" (it was added 1.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role4));

        mAdministrator.getRole(ltest_role3).addAncestor(ltest_role5);
        assertFalse("Role "+TEST_ROLE1+" is not member in less than five roles (five was added 1.)", role.getAllAncestors().size() < 5);
        assertFalse("Role "+TEST_ROLE1+" is member in more than five roles (just five was added 1.)", role.getAllAncestors().size() > 5);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 1.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role4+" (it was added 1.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role4));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role5+" (it was added 1.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role5));

        // test circular dependencies
        //try {
            mAdministrator.getRole(ltest_role5).addAncestor(ltest_role4);
        //    assertTrue("Circular dependency could be successfully created (1.).", false);
        //} catch (URMException e) { }
        assertFalse("Role "+TEST_ROLE1+" is not member in less than five roles (five was added 2.)", role.getAllAncestors().size() < 5);
        assertFalse("Role "+TEST_ROLE1+" is member in more than five roles (just five was added 2.)", role.getAllAncestors().size() > 5);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 2.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role4+" (it was added 2.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role4));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role5+" (it was added 2.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role5));
        try {
            mAdministrator.getRole(ltest_role4).addAncestor(ltest_role3);
            assertTrue("Circular dependency could be successfully created (2.).", false);
        } catch (URMException e) { }
        assertFalse("Role "+TEST_ROLE1+" is not member in less than five roles (five was added 3.)", role.getAllAncestors().size() < 5);
        assertFalse("Role "+TEST_ROLE1+" is member in more than five roles (just five was added 3.)", role.getAllAncestors().size() > 5);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 3.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role4+" (it was added 3.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role4));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role5+" (it was added 3.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role5));
        //try {
            mAdministrator.getRole(ltest_role5).deleteAncestor(ltest_role4);
        //    assertFalse("Removing a non existing ancestor did not throw an exception (1).", true);
        //} catch (URMException e) { }
        try {
            mAdministrator.getRole(ltest_role4).deleteAncestor(ltest_role3);
            assertFalse("Removing a non existing ancestor did not throw an exception (2).", true);
        } catch (URMException e) { }
        try {
            mAdministrator.getRole(ltest_role4).addAncestor(ltest_role3);
            assertTrue("Circular dependency could be successfully created (3.).", false);
        } catch (URMException e) { }
        assertFalse("Role "+TEST_ROLE1+" is not member in less than five roles (five was added 4.)", role.getAllAncestors().size() < 5);
        assertFalse("Role "+TEST_ROLE1+" is member in more than five roles (just five was added 4.)", role.getAllAncestors().size() > 5);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 4.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role4+" (it was added 4.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role4));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role5+" (it was added 4.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role5));
        try {
            mAdministrator.getRole(ltest_role4).deleteAncestor(ltest_role3);
            assertFalse("Removing a non existing ancestor did not throw an exception (3).", true);
        } catch (URMException e) { }
        try {
            mAdministrator.getRole(ltest_role4).addAncestor(ltest_role1);
            assertTrue("Circular dependency could be successfully created (4.).", false);
        } catch (URMException e) { }
        assertFalse("Role "+TEST_ROLE1+" is not member in less than five roles (five was added 5.)", role.getAllAncestors().size() < 5);
        assertFalse("Role "+TEST_ROLE1+" is member in more than five roles (just five was added 5.)", role.getAllAncestors().size() > 5);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 5.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role4+" (it was added 5.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role4));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role5+" (it was added 5.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role5));
        try {
            mAdministrator.getRole(ltest_role4).deleteAncestor(ltest_role1);
            assertFalse("Removing a non existing ancestor did not throw an exception (3).", true);
        } catch (URMException e) { }
        // removing
        mAdministrator.getRole(ltest_role3).deleteAncestor(ltest_role4);
        assertFalse("Role "+TEST_ROLE1+" is not member in less than four roles (four was added 2.)", role.getAllAncestors().size() < 4);
        assertFalse("Role "+TEST_ROLE1+" is member in more than four roles (just four was added 2.)", role.getAllAncestors().size() > 4);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 2.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role1+" (it was added 2.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role1));
        
        mAdministrator.getRole(ltest_role1).deleteAncestor(ltest_role2);
        assertFalse("Role "+TEST_ROLE1+" is not member in any roles (one was added 2.)", role.getAllAncestors().size() < 1);
        assertFalse("Role "+TEST_ROLE1+" is member in more than one roles (just one was added 2.)", role.getAllAncestors().size() > 1);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" (it was added 2.)",
                        containsValue(role.getAllAncestors(), ltest_role1));

        mAdministrator.getRole(ltest_role1).addAncestor(ltest_role2);
        assertFalse("Role "+TEST_ROLE1+" is not member in less than four roles (four was added 3.)", role.getAllAncestors().size() < 4);
        assertFalse("Role "+TEST_ROLE1+" is member in more than four roles (just four was added 3.)", role.getAllAncestors().size() > 4);
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role1+" and "+ltest_role3+" (it was added 3.)",
                        containsValues(role.getAllAncestors(), ltest_role1, ltest_role3));
        assertTrue("Role "+TEST_ROLE1+" is member in role "+ltest_role2+" and "+ltest_role1+" (it was added 3.)",
                        containsValues(role.getAllAncestors(), ltest_role2, ltest_role1));
        
        mAdministrator.getRole(TEST_ROLE1).deleteAncestor(ltest_role1);
        assertTrue("Role "+TEST_ROLE1+" is still member in a role (everything was removed)", role.getAllAncestors().size() == 0);
    }
    
    public void test9_() throws Exception {
    }
    
    public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestURMRoleAdministrator.class.getName() };
        
        org.apache.log4j.PropertyConfigurator.configure("testsuite/junit/log4j.properties");
        
        junit.textui.TestRunner.main(testCaseName);
    }
}
