/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/userdb/TestURMAllUsers.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.userdb;

import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMAllUsers extends TestCase{
    
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "Class";
    private static URMAuthenticator authenticator = null;
    public TestURMAllUsers(String name) throws Exception {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestURMAllUsers.class);
    }

    String ldapadmin = "usr";
    
    String user = "testuser";

    
    public void test_all_user() throws Exception {
    try {
        int result = 0;
            
        System.out.println("start");
        URMInit.init(false, ldapadmin, null);
        URMPrincipal principal = authenticator.authenticateUser(ldapadmin, ldapadmin.toCharArray(), null);
        principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        URMAdministrator urmadmin = principal.getURMAdministrator();
        
        // create users, groups and roles
        for (int i = 0; i < 1200;i++){
           urmadmin.createUser(user + i, new String(user + i).toCharArray(), null);
        }
        System.out.println("try to get all users");
        Set users = urmadmin.getAllUsers(null);
        System.out.println("users loaded");
        
        for (int i = 0; i < 1200;i++){
           urmadmin.deleteUser(user + i, null);
        }
        
        System.out.println("finished");
        } catch (Exception e) {
            e.printStackTrace();
        }
        
    }
    
 

        public static void main(String[] args) throws Exception {
        if (authenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            authenticator = URMAuthenticator.newInstance(conf);
        }
        
        String[] testCaseName = { "-noloading", TestURMAllUsers.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
        
     }
     

}



