/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/userdb/TestURMUserProperties.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.userdb;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author dk
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMUserProperties extends TestCase{
    
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "Class";
    private static URMAuthenticator authenticator = null;
    public TestURMUserProperties(String name) throws Exception {
        super(name);
        if (authenticator == null) {
            URMConfigurator conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
            authenticator = URMAuthenticator.newInstance(conf);
        }
    }

    public static Test suite() {
        return new TestSuite(TestURMUserProperties.class);
    }

    public void test_set_role_property() throws Exception {

        String result = null;
        String user = "user1";
        Map map = null;
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            principal.setActiveRole("URMAdmin");
            map = principal.getURMAdministrator().getRole("URMAdmin").getAvailablePropertyNames();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String prop = (String) iter.next();
            System.out.println("prop: " + prop + " readable: " + map.get(prop));
        }
    }
    
    public void test_set_user_property() throws Exception {

        String result = null;
        String user = "user1";
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            principal.setActiveRole("URMAdmin");
            principal.getURMAdministrator().getUser(user, null).setProperty("displayname", "fritz");
            result = principal.getProperties().getProperty("displayname");
            principal.getURMAdministrator().getUser(user, null).setProperty("displayname", user);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        assertEquals("fritz", result);
    }
    
    public void test_set_user_properties() throws Exception {

        String displyname = null;
        String description = null;
        String user = "user1";
        Properties props = new Properties();
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            props.setProperty("displayname", "fritz");
            props.setProperty("description", "Fritz M�ller");
            principal.setActiveRole("URMAdmin");
            principal.getURMAdministrator().getUser(user, null).setProperties(props);
            displyname = principal.getProperties().getProperty("displayname");
            description = principal.getProperties().getProperty("description");
            props.setProperty("displayname", user);
            props.setProperty("description", user);
            principal.getURMAdministrator().getUser(user, null).setProperties(props);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        assertEquals("fritz", displyname);
        assertEquals("Fritz M�ller", description);
    }
    
        public void test_get_user_property() throws Exception {

        String result = null;
        String user = "user1";
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            result = principal.getProperties().getProperty("displayname");
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        assertEquals(user, result);
    }
    
    public void test_set_group_property() throws Exception {

        String result = null;
        String user = "user1";
        String group = "testgrp1";
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            principal.setActiveRole("URMAdmin");
            principal.getURMAdministrator().getGroup(group, null).setProperty("displayname", "testgroup");
            result = (String)principal.getURMAdministrator().getGroup(group, null).getProperty("displayname");
            principal.getURMAdministrator().getGroup(group, null).setProperty("displayname", group);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        assertEquals("testgroup", result);
    }
    
    public void test_set_group_properties() throws Exception {

        String displyname = null;
        String description = null;
        String user = "user1";
        Properties props = new Properties();
        String group = "testgrp1";
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            props.setProperty("displayname", "workers");
            props.setProperty("description", "Workers of Fritz M�ller");
            principal.setActiveRole("URMAdmin");
            principal.getURMAdministrator().getGroup(group, null).setProperties(props);
            displyname = (String)principal.getURMAdministrator().getGroup(group, null).getProperties().getProperty("displayname");
            description = (String)principal.getURMAdministrator().getGroup(group, null).getProperties().getProperty("description");
            props.setProperty("displayname", group);
            props.setProperty("description", group);
            principal.getURMAdministrator().getGroup(group, null).setProperties(props);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        assertEquals("workers", displyname);
        assertEquals("Workers of Fritz M�ller", description);
    }
    
        public void test_get_group_property() throws Exception {

        String result = null;
        String user = "user1";
        String group = "testgrp1";
        
        URMPrincipal principal = authenticator.authenticateUser(user, user.toCharArray(), null);
        
        try {
            result = (String)principal.getURMAdministrator().getGroup(group, null).getProperty("displayname");
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        assertEquals(group, result);
    }


        public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestURMUserProperties.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
     }
 
}



