/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/userdb/threads/TestMultithreadedUserDb.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.userdb.threads;

import java.io.FileInputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestMultithreadedUserDb extends TestCase {
    //public static final int THREADS_NUMBER = 5;
    //public static final int USER_NUMBER_PER_THREAD = 10;
    public static final int THREADS_NUMBER = 5;
    public static final int USER_NUMBER_PER_THREAD = 10;

    private static URMAuthenticator mAuthenticator = null;
    private static URMPrincipal mPrincipal = null;
    private static URMAdministrator mAdministrator = null;
    private static URMAclAdministrator mAclAdministrator = null;
    private static URMConfigurator mTestConfigurator = null;
    private static String mDomain = null;


    public TestMultithreadedUserDb(String name) throws Exception {
        super(name);
        initUrmTest();
    }
    
    private static synchronized void initUrmTest() throws Exception {
        if (mTestConfigurator != null)
            return;
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationTamino.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapActiveDirectory.xml");
        FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapSunOne.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapDK.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationLdapXtlin1.xml");
        //FileInputStream fis = new FileInputStream("testsuite/junit/ConfigurationOS.xml");
        URMConfigurator conf = new URMConfiguratorXML(fis);
        fis.close();
        mTestConfigurator = (URMConfigurator)(conf.getSubConfigurators().get("JUnitTest"));
        conf = (URMConfigurator)(conf.getSubConfigurators().get("Authenticator"));
        mAuthenticator = URMAuthenticator.newInstance(conf);
        mPrincipal = mAuthenticator.authenticateUser(
                mTestConfigurator.getProperties().getProperty("TestAdminUser"),
                mTestConfigurator.getProperties().getProperty("TestAdminPw").toCharArray(), null);
        mPrincipal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
        mAdministrator = mPrincipal.getURMAdministrator();
        if (mAdministrator == null)
            throw new Exception ("CANNOT CREATE URM ADMINISTRATOR, CHECK THE TEST ADMIN USER PARAMS!");
        mAclAdministrator = mPrincipal.getURMAclAdministrator();
        assertNotNull("null URMAclAdministrator was received!!!", mAclAdministrator);
        
        mDomain = mTestConfigurator.getProperties().getProperty("TestDomain");
        if (mDomain.length() <= 0)
            mDomain = null;
    }
    
    public static Test suite() {
        return new TestSuite(TestMultithreadedUserDb.class);
    }
    
    private void waitForTheEnd(TestThreadUserDbBase threads[]) throws InterruptedException {
        for (int i = 0; i < threads.length; ++i)
            threads[i].waitForDie();
    }

    public void test0_() throws Exception {
        URMAction action = mAclAdministrator.getAction("TEST");
        if (action != null)
            System.out.println("\nAction: " + action.getName() + "(" + action.getBaseActions() + ")");
    }
    
    public void _test1_createDeleteUsersGroups() throws Exception {
        TestThreadUserDbBase create_users_threads[] = new TestThreadCreateUsers[THREADS_NUMBER];
        TestThreadUserDbBase create_groups_threads[] = new TestThreadCreateGroups[THREADS_NUMBER];
        // create thread objects
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i] = new TestThreadCreateUsers(mAuthenticator, mAdministrator, mDomain, null, USER_NUMBER_PER_THREAD);
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i] = new TestThreadCreateGroups(mAuthenticator, mAdministrator, mDomain, null, USER_NUMBER_PER_THREAD);
        
        // start create
        /*for (int i = 0; i < threads.length; ++i)
            threads[i].startCreate();
        waitForTheEnd(threads); // wait until they finish
        System.out.println("\nUsers are created.");
        // start check
        for (int i = 0; i < threads.length; ++i)
            threads[i].startCheck();
        waitForTheEnd(threads);  // wait until they finish
        // and again check
        for (int i = 0; i < threads.length; ++i)
            threads[i].startCheck();
        waitForTheEnd(threads);  // wait until they finish
        // start clear
        for (int i = 0; i < threads.length; ++i)
            threads[i].startClear();
        waitForTheEnd(threads);  // wait until they finish*/
        // all in one
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startAll();
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startAll();
        waitForTheEnd(create_groups_threads);  // wait until they finish
        waitForTheEnd(create_users_threads);  // wait until they finish
    }

    public void test2_addRemoveUserToFromGroup() throws Exception {
        // CREATE users and groups
        TestThreadCreateUsers  create_users_threads[]  = new TestThreadCreateUsers[THREADS_NUMBER];
        TestThreadCreateGroups create_groups_threads[] = new TestThreadCreateGroups[THREADS_NUMBER];
        // create thread objects
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i] = new TestThreadCreateUsers(mAuthenticator, mAdministrator, mDomain, null, USER_NUMBER_PER_THREAD);
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i] = new TestThreadCreateGroups(mAuthenticator, mAdministrator, mDomain, null, USER_NUMBER_PER_THREAD);
            // create user/group entries
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startCreate();
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startCreate();
        waitForTheEnd(create_users_threads); // wait until they finish
        waitForTheEnd(create_groups_threads);
            // check user/group entries
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startCheck();
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startCheck();
        waitForTheEnd(create_users_threads); // wait until they finish
        waitForTheEnd(create_groups_threads);
        
        // ADD/REMOVE user to/from group test
        TestThreadUserDbBase threads[] = new TestThreadAddUserToGroup[THREADS_NUMBER];
        // create thread objects
        for (int i = 0; i < threads.length; ++i)
            threads[i] = new TestThreadAddUserToGroup(mAuthenticator, mAdministrator, mDomain,
                                                create_users_threads[i].getCreatedUsers(),
                                                create_groups_threads[i].getCreatedGroups(),
                                                (i%2 == 0) ? true : false);
        // all in one
        for (int i = 0; i < threads.length; ++i)
            threads[i].startAll();
        waitForTheEnd(threads);  // wait until they finish

        // CHECK/UPDATE/CLEAR user/group entries
            // check user/group entries
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startCheck();
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startCheck();
        waitForTheEnd(create_users_threads);
        waitForTheEnd(create_groups_threads); // wait until they finish
            // update user/group entries
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startUpdate();
        waitForTheEnd(create_users_threads); // wait until they finish
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startUpdate();
        waitForTheEnd(create_groups_threads); // wait until they finish
            // check user/group entries
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startCheck();
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startCheck();
        waitForTheEnd(create_users_threads);
        waitForTheEnd(create_groups_threads); // wait until they finish
            // remove user/group entries
        for (int i = 0; i < create_users_threads.length; ++i)
            create_users_threads[i].startClear();
        waitForTheEnd(create_users_threads); // wait until they finish
        for (int i = 0; i < create_groups_threads.length; ++i)
            create_groups_threads[i].startClear();
        waitForTheEnd(create_groups_threads); // wait until they finish
    }
    
    public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestMultithreadedUserDb.class.getName() };
        
        org.apache.log4j.PropertyConfigurator.configure("testsuite/junit/log4j.properties");

        junit.textui.TestRunner.main(testCaseName);
    }
}
