/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/userdb/threads/TestThreadBase.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.userdb.threads;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class TestThreadBase extends Thread {

    private int mCreateCleanFlag = 0;

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {
        switch (mCreateCleanFlag) {
            case 1:  create();
                     break;
            case 2:  update();
                     break;
            case 3:  check();
                     break;
            case 4:  clear();
                     break;
            default: create(); check(); update(); check(); check(); clear();
                     break;
        }
        mCreateCleanFlag = 0;
    }

    public void runCreate() {
        mCreateCleanFlag = 1;
        run();
    }
    
    public void runUpdate() {
        mCreateCleanFlag = 2;
        run();
    }
    
    public void runCheck() {
        mCreateCleanFlag = 3;
        run();
    }
    
    public void runClear() {
        mCreateCleanFlag = 4;
        run();
    }
    
    public abstract void create();

    public abstract void update();

    public abstract void check();

    public abstract void clear();

}
