/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/userdb/threads/TestThreadCreateGroups.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.userdb.threads;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.slide.urm.URMException;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestThreadCreateGroups extends TestThreadUserDbBase {

    private String           mNamePrefix    = null;
    private int              mGroupNumber   = 0;
    private List             mCreatedGroups = new LinkedList();
    
    public TestThreadCreateGroups(URMAuthenticator auth, URMAdministrator admin, String domain,
                                String namePrefix, int userNumber) {
        super(auth, admin, domain);
        mNamePrefix = namePrefix;
        mGroupNumber = userNumber;
    }

    public void create() {
        try {
        if (mNamePrefix == null) {
            String threadname = Thread.currentThread().getName();
            mNamePrefix = "URM_mt_test_grp"+threadname.substring(threadname.indexOf('-') + 1) + "_";
        }
        for (int i = 0; i < mGroupNumber; ++i) {
            String grpname = mNamePrefix + Integer.toString(i);
                if (!mAdministrator.isGroup(grpname, mDomain))
                    mAdministrator.createGroup(grpname, mDomain);
                if (!mAdministrator.isGroup(grpname, mDomain)) {
                    System.out.println("\nisGroup() returns false for group '"+grpname+"' (it was just created).");
                    break;
                }
                mCreatedGroups.add(grpname);
        }
        } catch (Throwable e) {
            e.printStackTrace();
            mThrowable = e;
        } finally {
            if (mThrowable != null) {
                List grps = new LinkedList(mCreatedGroups);
                for (int i = 0; i < grps.size(); ++i) {
                    try {
                        mAdministrator.deleteGroup((String)grps.get(i), mDomain);
                        mCreatedGroups.remove(grps.get(i));
                    } catch (URMException e) {
                        //e.printStackTrace();
                    }
                }
            }
        }
    }

    public void update() {
        try {
            if (mCreatedGroups.size() > 1) {
                String grpname = (String)mCreatedGroups.get(mCreatedGroups.size() - 1);
                mAdministrator.deleteGroup(grpname, mDomain);
                Thread.yield();
                if (mAdministrator.isGroup(grpname, mDomain))
                    System.out.println("\nisGroup() returns true for group '"+grpname+"' (it was just removed in update()).");
                else
                    mCreatedGroups.remove(grpname);
                if (mCreatedGroups.size() > 1) {
                    grpname = (String)mCreatedGroups.get(0);
                    mAdministrator.deleteGroup(grpname, mDomain);
                    Thread.yield();
                    if (mAdministrator.isGroup(grpname, mDomain))
                        System.out.println("\nisGroup() returns true for group '"+grpname+"' (it was just removed in update()).");
                    else
                        mCreatedGroups.remove(grpname);
                }
            }
        } catch (URMException e) {
            e.printStackTrace();
            mThrowable = e;
        }
    }
    
    public void check() {
        try {
            for (Iterator iter = mCreatedGroups.iterator(); iter.hasNext();) {
                String grpname = (String)iter.next();
                if (!mAdministrator.isGroup(grpname, mDomain)) {
                    System.out.println("\nisGroup() returns false for group '"+grpname+"' (it must be created).");
                }
            }
        } catch (URMException e) {
            e.printStackTrace();
            mThrowable = e;
        }
    }
    
    public void clear() {
        int again = 0;
        do {
            List grps = new LinkedList(mCreatedGroups);
            int i = 0;
            for (Iterator iter = grps.iterator(); iter.hasNext();++i) {
                String grpname = (String)iter.next();
                try {
                    mAdministrator.deleteGroup(grpname, mDomain);
                    Thread.yield();
                    if (mAdministrator.isGroup(grpname, mDomain)) {
                        System.out.println("\nisGroup() returns true for group '"+grpname+"' (it was just removed).");
                        ++again;
                        continue;
                        
                    }
                    mCreatedGroups.remove(grpname);
                } catch (URMException e) {
                    try {
                        if (mAdministrator.isGroup(grpname, mDomain)) {
                            ++again;
                            e.printStackTrace();
                            mThrowable = e;
                        }
                        else
                            mCreatedGroups.remove(grpname);
                    } catch (Exception e2) {}
                }
            }
        } while(mCreatedGroups.size() > 0 && again < 10);
    }
    
    public List getCreatedGroups() {
        return mCreatedGroups;
    }
}
