/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/authenticator/userdb/threads/TestThreadUserDbBase.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.authenticator.userdb.threads;

import java.util.Random;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMAuthenticator;

/**
 * @author zsa
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class TestThreadUserDbBase {

    protected URMAuthenticator mAuthenticator = null;
    protected URMAdministrator mAdministrator = null;
    protected String           mDomain        = null;
    protected Throwable        mThrowable     = null;
    protected Random           mRandom        = null;
    private Thread             mThread        = null;
    
    public TestThreadUserDbBase(URMAuthenticator auth, URMAdministrator admin, String domain) {
        mAuthenticator = auth;
        mAdministrator = admin;
        mDomain = domain;
        mRandom = new Random();
    }
    
    private class LoclalTestThread extends Thread {
        private int mFlag = 0;
        private TestThreadUserDbBase mImpl = null;
    
        public LoclalTestThread(TestThreadUserDbBase impl, int flag) {
            mImpl = impl;
            mFlag = flag;
        }
    
        /* (non-Javadoc)
         * @see java.lang.Runnable#run()
         */
        public void run() {
            switch (mFlag) {
                case 1:  mImpl.create();
                         break;
                case 2:  mImpl.update();
                         break;
                case 3:  mImpl.check();
                         break;
                case 4:  mImpl.clear();
                         break;
                default: mImpl.create(); mImpl.check(); mImpl.update(); mImpl.check(); mImpl.clear();
                         break;
            }
        }

    }
    
    public void startCreate() {
        (mThread = new LoclalTestThread(this, 1)).start();
    }
    
    public void startUpdate() {
        (mThread = new LoclalTestThread(this, 2)).start();
    }
    
    public void startCheck() {
        (mThread = new LoclalTestThread(this, 3)).start();
    }
    
    public void startClear() {
        (mThread = new LoclalTestThread(this, 4)).start();
    }
    
    public void startAll() {
        (mThread = new LoclalTestThread(this, 0)).start();
    }
    
    public Thread getThread() {
        return mThread;
    }
    
    public Throwable getError() {
        return mThrowable;
    }

    public void waitForDie() {
        Thread lthread = mThread;
        mThread = null;
        while (lthread.isAlive())
            Thread.yield();
            try {
                lthread.join(/*100*/);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        //System.out.println("Thread '"+lthread.getName()+"' died.");
        lthread = null;
    }
    
    protected abstract void create();

    protected abstract void update();

    protected abstract void check();

    protected abstract void clear();
    
}
