/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/urm/org/apache/slide/urm/test/init/TestURMInit.java,v 1.3 2004/07/30 06:52:21 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:21 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.test.init;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.urm.common.URMInit;

/**
 * @author ehm
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TestURMInit extends TestCase{
    
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "Class";
    
    public TestURMInit(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestURMInit.class);
    }
    
    public void test_init_null() throws Exception {
        URMInit init = new URMInit();
        init.initURM(false, null, null);
    }
    
    public void _test_init_user() throws Exception {
        URMInit init = new URMInit();
        init.initURM(false, "fritz", null);
    }
    
    public void _test_init_user_domain() throws Exception {
        URMInit init = new URMInit();
        init.initURM(false, "fritz", "testdomain");
    }
    
    public void _test_init_null_security() throws Exception {
        URMInit init = new URMInit();
        init.initURM(true, null, null);
    }
    
    public void _test_init_user_security() throws Exception {
        URMInit init = new URMInit();
        init.initURM(true, "fritz", null);
    }
    
    public void _test_init_user_domain_security() throws Exception {
        URMInit init = new URMInit();
        init.initURM(true, "fritz", "testdomain");
    }
  
    public static void main(String[] args) throws Exception {
        String[] testCaseName = { "-noloading", TestURMInit.class.getName() };
    
        junit.textui.TestRunner.main(testCaseName);
     }
}



