/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/JDomTest.java,v 1.3 2004/07/30 06:52:22 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class JDomTest extends TestCase {
    /**
     ** Constructs a test case with the specified test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public JDomTest(String testMethodName) {
        super(testMethodName);
    }
    
    /**
     **/
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    //-- test equals

    public void testEqual() throws Exception {
        final String[][] doc = {
            {"<x xmlns:pre1='http://www.xapp.org/pre' pre1:attr1='av1' attr2='av2'/>",
             "<x xmlns:pre2='http://www.xapp.org/pre' pre2:attr1='av1' attr2='av2'/>"},
            {"<x xmlns:pre1='http://www.xapp.org/pre'><pre1:y1/><pre1:y2/></x>",
             "<x xmlns:pre2='http://www.xapp.org/pre'><pre2:y1/><pre2:y2/></x>"}
        };
        for (int i = 0; i < doc.length; i++) {
            assertTrue("compare " + doc[i][0],
                       JDom.equals(JDom.forString(doc[i][0]).getRootElement(), JDom.forString(doc[i][1]).getRootElement()));
        }
    }

    public void testNotEqual() throws Exception {
        final String[][] doc = {
            {"<x xmlns:pre1='http://www.xapp.org/pre1' pre1:attr1='av1' attr2='av2'/>",
             "<x xmlns:pre1='http://www.xapp.org/pre1'><pre1:y1/><pre1:y2/></x>"},
            {"<x><a/><b/></x>",
             "<x><b/><a/></x>"},
        };
        for (int i = 0; i < doc.length; i++) {
            assertFalse("compare " + doc[i][0],
                       JDom.equals(JDom.forString(doc[i][0]).getRootElement(), JDom.forString(doc[i][1]).getRootElement()));
        }
    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(JDomTest.class);
    }
}

