/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/MimeMappingTest.java,v 1.3 2004/07/30 06:52:22 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;


import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 ** This class... .
 **
 ** @author peter.nevermann@softwareag.com
 **
 ** @version 0.1
 **/
public class MimeMappingTest extends TestCase {
    
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public MimeMappingTest( String testMethodName ) {
        super( testMethodName );
    }
    
    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite() {
        return new TestSuite(  MimeMappingTest.class );
    }
    
    private static final String TYPE_A = "foo/bar";
    private static final String TYPE_B = "x/y";
    private static final String EXT_1 = "txt";
    private static final String EXT_2 = "doc";

    private MimeMapping mm;
    private List lst;
    
    public void testEmpty() {
        mm = new MimeMapping();
        assertEquals(0, mm.getExtensions(TYPE_A).size());
    }
    
    public void testOne() {
        mm = new MimeMapping();
        mm.add(TYPE_A, EXT_1);
        mm.add(TYPE_B, EXT_2);

        lst = mm.getExtensions(TYPE_A);
        assertEquals(1, lst.size());
        assertEquals(EXT_1, lst.get(0));
        lst = mm.getExtensions(TYPE_B);
        assertEquals(1, lst.size());
        assertEquals(EXT_2, lst.get(0));

        lst = mm.getMimeTypes(EXT_1);
        assertEquals(1, lst.size());
        assertEquals(TYPE_A, lst.get(0));
        lst = mm.getMimeTypes(EXT_2);
        assertEquals(1, lst.size());
        assertEquals(TYPE_B, lst.get(0));
    }

    public void testTwoExtensions() {
        mm = new MimeMapping();
        mm.add(TYPE_A, EXT_1);
        mm.add(TYPE_A, EXT_2);

        lst = mm.getExtensions(TYPE_A);
        assertEquals(2, lst.size());
        assertEquals(EXT_1, lst.get(0));
        assertEquals(EXT_2, lst.get(1));

        lst = mm.getMimeTypes(EXT_1);
        assertEquals(1, lst.size());
        assertEquals(TYPE_A, lst.get(0));
        lst = mm.getMimeTypes(EXT_2);
        assertEquals(1, lst.size());
        assertEquals(TYPE_A, lst.get(0));
    }

    public void testTwoTypes() {
        mm = new MimeMapping();
        mm.add(TYPE_A, EXT_1);
        mm.add(TYPE_B, EXT_1);

        lst = mm.getMimeTypes(EXT_1);
        assertEquals(2, lst.size());
        assertEquals(TYPE_A, lst.get(0));
        assertEquals(TYPE_B, lst.get(1));

        lst = mm.getExtensions(TYPE_A);
        assertEquals(1, lst.size());
        assertEquals(EXT_1, lst.get(0));
        lst = mm.getExtensions(TYPE_B);
        assertEquals(1, lst.size());
        assertEquals(EXT_1, lst.get(0));
    }
}

