/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/PatternTest.java,v 1.3 2004/07/30 06:52:22 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 **
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class PatternTest extends TestCase {
    private Pattern pattern;

    public PatternTest(String name) {
        super(name);
    }

    public void testWithoutParameter() {
        pattern = new Pattern("foo/bar.xml");
        assertFalse(pattern.isParameterized());
        assertEquals("foo/bar.xml", pattern.resolve("notUsed"));
    }

    public void testWithParameter() {
        pattern = new Pattern("foo/${store}/bar.xml");
        assertTrue(pattern.isParameterized());
        assertEquals("foo/used/bar.xml", pattern.resolve("used"));
    }

    public void testWithParameterReferencedTwice() {
        pattern = new Pattern("foo/${store}/${store}/bar.xml");
        assertTrue(pattern.isParameterized());
        assertEquals("foo/used/used/bar.xml", pattern.resolve("used"));
    }

    public void testWithWrongNameParameter() {
        pattern = new Pattern("foo/${store2}/bar.xml");
        assertFalse(pattern.isParameterized());
    }

    //--


    public void testMatchesSameLength() {
        check("foo", "${store}/bar", "foo/bar");
    }

    public void testMatchesDifferentLength() {
        check("foo/bar", "${store}", "foo/bar");
    }

    public void testMatchesNotParameterized() {
        check(Pattern.NO_VAR, "foo/bar", "foo/bar");
    }

    /* TODO: not supported yet
    public void testMatchesVariableUsedTwice() {
        check("foo", "${store}/${store}/bar", "foo/foo/bar");
    }

    public void testMatchesVariableUsedTwiceNotMatched() {
        check(null, "${store}/${store}", "foo/foo2");
     }*/

    private void check(String match, String left, String right) {
        assertEquals(match, new Pattern(left).match(right));
    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }

    public static Test suite() {
        return new TestSuite(PatternTest.class);
    }
}

