/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/PropertiesTest.java,v 1.1 2004/03/25 16:18:16 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:16 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PropertiesTest extends TestCase {
    private Properties props;
    
    protected void setUp() throws Exception {
        super.setUp();
        
        props = new Properties();
    }
    
    public void testSimple() {
        props.add("foo", "bar");
        assertNull(props.getOptional("empty"));
        assertEquals("bar", props.getOptional("foo"));
    }

    public void testReplace() {
        props.add("one", "1");
        props.add("two", "2");
        assertEquals("$one{one}", props.replace("$one{one}"));
        assertEquals("1", props.replace("${one}"));
        assertEquals("121", props.replace("${one}${two}${one}"));
        assertEquals("aa1bb2cc1dd", props.replace("aa${one}bb${two}cc${one}dd"));
        try {
            assertEquals("", props.replace("${three}"));
            fail();
        } catch (IllegalArgumentException e) {
            // ok
        }
    }
    
    public static void main(String[] args) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(PropertiesTest.class);
    }
    
}
