/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/StringsTest.java,v 1.3 2004/07/30 06:52:22 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 ** This class... .
 **
 ** @author peter.nevermann@softwareag.com
 **
 ** @version 0.1
 **/
public class StringsTest extends TestCase {
    
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public StringsTest( String testMethodName ) {
        super( testMethodName );
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    /*
     public static void main( String[] args ) {
     junit.textui.TestRunner.run( suite() );
     }
     */
    
    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite() {
        // automatically call each method starting with 'test'.
        TestSuite suite = new TestSuite(  StringsTest.class );
        
        
        // additionally add subsuites here
        // suite.addTest( XXX.suite() );
        // suite.addTest( YYY.suite() );
        
        
        // return the this suite
        return suite;
    }
    
    /**
     ** Construct your fixtures for the test cases in CaseTemplate.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void setUp() {
    }
    
    /**
     ** Destruct your fixtures for the test cases in CaseTemplate.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void tearDown() {
    }
    
    /**
     *
     */
    public void testEndsWithIgnoreCase() {
        
        String m = "abcdefg";
        String s0_T = "abcdefg";
        String s1_T = "efg";
        String s2_T = "eFg";
        String s3_T = "EfG";
        String s0_F = "xabcdefg";
        String s1_F = "xefg";
        String s2_F = "efgx";
        
        assertTrue( Strings.endsWithIgnoreCase(m, s0_T) );
        assertTrue( Strings.endsWithIgnoreCase(m, s1_T) );
        assertTrue( Strings.endsWithIgnoreCase(m, s2_T) );
        assertTrue( Strings.endsWithIgnoreCase(m, s3_T) );
        assertTrue( !Strings.endsWithIgnoreCase(m, s0_F) );
        assertTrue( !Strings.endsWithIgnoreCase(m, s1_F) );
        assertTrue( !Strings.endsWithIgnoreCase(m, s2_F) );
    }
    
    public void testStripExtension() {
        String f1 = "abc.xml";
        String f2 = ".xml";
        String f3 = "abc";
        String f4 = "abc.def.xml";
        
        assertTrue( "abc".equals(Strings.stripExtension(f1)) );
        assertTrue( ".xml".equals(Strings.stripExtension(f2)) );
        assertTrue( "abc".equals(Strings.stripExtension(f3)) );
        assertTrue( "abc.def".equals(Strings.stripExtension(f4)) );
    }
    
    //---
    
    public void testBlockSimple() {
        assertEquals("", Strings.block("", "", 0, ""));
        assertEquals("foo", Strings.block("", "foo", 10, ""));
        assertEquals("foo bar", Strings.block("", "foo bar", 10, ""));
        assertEquals("barfoo", Strings.block("bar", "foo ", 10, ""));
        assertEquals("foobar", Strings.block("", "foo", 10, "bar"));
    }

    public void testBlockNormalize() {
        assertEquals("foo", Strings.block("", " foo", 10, ""));
        assertEquals("foo", Strings.block("", "foo ", 10, ""));
        assertEquals("foo", Strings.block("", "foo\n", 10, ""));
        assertEquals("foo bar", Strings.block("", "foo  bar", 10, ""));
    }
    public void testBlockBreak() {
        assertEquals("foo-bar-", Strings.block("", "foo bar", 3, "-"));
        assertEquals("foo-bar-", Strings.block("", "foo bar", 4, "-"));
        assertEquals("foo-bar-", Strings.block("", "foo bar", 6, "-"));
        assertEquals("foo bar-", Strings.block("", "foo bar", 7, "-"));
        assertEquals("foo bar-", Strings.block("", "foo  bar", 7, "-"));
    }

    public void testBlockToSmall() {
        assertEquals("foo", Strings.block("", "foo", 0, ""));
        assertEquals("foo-bar-", Strings.block("", "foo bar", 0, "-"));
    }
}

