/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/XUriTest.java,v 1.3 2004/07/30 06:52:22 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 **
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XUriTest extends TestCase {
    private XUri uri;

    public XUriTest(String name) {
        super(name);
    }

    public void testEmpty() {
        uri = new XUri("");
        assertEquals(0, uri.size());
        assertNull(uri.getParent());
    }

    public void testNormal() {
        XUri parent;

        uri = new XUri("a/b/c");
        assertEquals(3, uri.size());
        assertEquals("a", uri.segment(0));
        assertEquals("b", uri.segment(1));
        assertEquals("c", uri.segment(2));
        parent = uri.getParent();
        assertEquals(2, parent.size());
        assertEquals("a", parent.segment(0));
        assertEquals("b", parent.segment(1));
    }

    public void testAbsoluteEmpty() {
        uri = new XUri("/");
        assertEquals(0, uri.size());
        assertEquals(uri, new XUri(""));
    }

    public void testAbsoluteOne() {
        uri = new XUri("/foo");
        assertEquals(1, uri.size());
        assertEquals("foo", uri.segment(0));
        assertEquals(uri, new XUri("foo"));
        assertEquals(uri, new XUri("foo/"));
        assertEquals(uri, new XUri("/foo/"));
    }

    public void testBackslashIsNotADelimiter() {
        final String str = "a\\b";
        uri = new XUri(str);
        assertEquals(1, uri.size());
        assertEquals(str, uri.segment(0));
    }

    public void testEquals() {
        uri = new XUri("foo/bar");
        assertTrue(uri.equals(new XUri(new String[] { "foo", "bar" })));
        assertFalse(uri.equals(new XUri(new String[] { "bar", "foo" })));
        assertFalse(uri.equals(new XUri("")));
    }

    public void testAppend() {
        assertEquals(new XUri("a/b/b/c/d"), new XUri("a/b").append(new XUri("b/c/d")));
    }

    //--

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }

    public static Test suite() {
        return new TestSuite(XUriTest.class);
    }
}

