/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/cli/ActualsTest.java,v 1.1 2004/03/25 16:18:17 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.cli;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.util.cli.Abort;
import org.apache.slide.util.cli.Actuals;

public class ActualsTest extends TestCase {
    private Actuals actuals;
    
    public ActualsTest(String name) {
        super( name );
    }
    
    protected void setUp() throws Exception {
        super.setUp();
        actuals = new Actuals();
    }
    
    public void testEmpty() throws Abort {
        assertEquals(0, actuals.names().size());
    }
    
    public void testNames() {
        actuals.add("name", "value");
        actuals.add("name2", "value2");
        assertEquals(2, actuals.names().size());
        assertTrue(actuals.names().contains("name"));
        assertTrue(actuals.names().contains("name2"));
    }

    public void testSwitch() {
        actuals.add("name", "value");
        assertTrue(actuals.getSwitch("name"));
        assertFalse(actuals.getSwitch("notFound"));
    }

    public void testString() {
        actuals.add("name", "value");
        assertEquals("value", actuals.getString("name"));
        assertEquals(null, actuals.getString("notFound"));
        assertEquals("foo", actuals.getString("alsoNotFound", "foo"));
    }

    public void testInt() throws Abort {
        actuals.add("str", "a");
        actuals.add("num", "1");
        try {
            actuals.getInt("str", 1);
            fail();
        } catch (Abort e) {
            // ok
        }
        assertEquals(1, actuals.getInt("num", -1));
        assertEquals(-1, actuals.getInt("num2", -1));
    }
    
    //--
    
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(ActualsTest.class);
    }
    
}

