/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/util/org/apache/slide/util/nodeset/GlobTest.java,v 1.3 2004/07/30 06:52:22 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.nodeset;

import junit.framework.TestCase;
import org.apache.oro.text.regex.Pattern;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class GlobTest extends TestCase {
    public GlobTest(String testMethodName) {
        super(testMethodName);
    }
    
    private Pattern p;
    
    /**
     **/
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    public void testEmpty() {
        p = Glob.compile("", false);
        assertTrue(Glob.matches(p, ""));
        assertFalse(Glob.matches(p, " "));
    }

    public void testIgnoreCase() {
        p = Glob.compile("a", true);
        assertTrue(Glob.matches(p, "a"));
        assertTrue(Glob.matches(p, "A"));
        assertFalse(Glob.matches(p, "b"));
    }

    public void testSuffix() {
        p = Glob.compile("*.java", true);
        assertTrue(Glob.matches(p, "foo.java"));
        assertFalse(Glob.matches(p, "foo.txt"));
        assertTrue(Glob.matches(p, ".java"));
    }
    public void testAll() {
        p = Glob.compile("*.*", true);
        assertFalse(Glob.matches(p, ""));
        assertTrue(Glob.matches(p, "."));
        assertTrue(Glob.matches(p, "foo.bar"));
    }
}

