package javax.wvcm;
import java.util.List;

/**
 * A configuration is a resource that is associated with a folder
 * (called the "root folder") and that represents all members
 * of the root folder that are not in another configuration.
 * <p>
 * A version-controlled configuration is associated with a
 * baseline-controlled folder, and is used to create and access
 * baselines of that folder.</p>
 * <p>
 * When a folder is both version-controlled and baseline-controlled,
 * a client can create a new version of the folder by
 * checking out and checking in that folder,
 * and it can create a new baseline of that folder by checking out
 * and checking in the version-controlled configuration of that folder.</p>
 */
public interface Configuration extends ControllableResource {

   /**
    * Return the root folder of the configuration.
    * The ControlledConfiguration property of the root folder of a version-controlled configuration
    * MUST identify that version-controlled configuration.
    * @throws WvcmException if this {@link Configuration} was not created with
    * {@link PropertyNameList.PropertyName#ROOT_FOLDER ROOT_FOLDER} as a wanted property.
    */
   public ControllableFolder getRootFolder() throws WvcmException;

   /**
    * If this {@link Configuration} is checked-out, 
    * return a list of {@link Baseline} objects that identify the baselines
    * that will be the subbaselines of the baseline created when this {@link Configuration}
    * is checked in; otherwise return <code>null</code>.
    * @throws WvcmException if this {@link Configuration} was not created with
    * {@link PropertyNameList.PropertyName#SUBBASELINE_LIST SUBBASELINE_LIST} as a wanted property.
    */
   public List getSubbaselineList() throws WvcmException;

   /**
    * Set the SubbaselineList property of this {@link Configuration}.
    * @param baselineList A list of {@link Baseline} objects that will be
    * the SubbaselineList property of the baseline created when this {@link Configuration}
    * is checked in.
    */
   public void setSubbaselineList(List baselineList)
      throws WvcmException;
}
