package javax.wvcm;

/**
 * NOT YET STANDARD
 * Describes a lock token.
 */
public interface LockToken {
    
    /**
     * Get the lock ID (an URI in the opaquelocktoken scheme)
     *
     * @return   a String
     */
    public String getLockId();
    
    /**
     * Get the lock scope
     *
     * @return   a Scope
     */
    public Scope getLockScope();
    
    /**
     * Get the lock depth
     *
     * @return   a Depth
     */
    public Depth getDepth();
    
    /**
     * Get the lock owner
     *
     * @return   a Principal
     *
     */
    public Principal getOwner();
    
    /**
     * Get the lock owner info
     *
     * @return   a String
     *
     */
    public String getOwnerInfo();
    
    /**
     * Get the lock timeout
     *
     * @return   a Timeout
     */
    public Timeout getTimeout();
    
    /**
     * Get the lock type
     *
     * @return   a Type
     */
    public Type getLockType();
    
    /**
     * Method isActive
     *
     * @return   a boolean
     *
     */
    public boolean isActive();
    
    /**
     * Discrete values for parameter "locktype".
     */
    public static class Type {
        public static final Type WRITE = new Type(){public String toString(){return "write";}};
    }
    
    /**
     * Discrete values for parameter "depth".
     */
    public static class Depth {
        public static final Depth ZERO = new Depth(){public String toString(){return "0";}};
        public static final Depth INFINITY = new Depth(){public String toString(){return "infinity";}};
    }
    
    /**
     * Discrete values for parameter "lockscope".
     */
    public static class Scope {
        public static final Scope EXCLUSIVE = new Scope(){public String toString(){return "exclusive";}};
        public static final Scope SHARED = new Scope(){public String toString(){return "shared";}};
    }
    
    /**
     * Describes the parameter "timeout".
     */
    public static class Timeout {
        public static final Timeout INFINITE = new Timeout(Integer.MAX_VALUE){public String toString(){return "Infinite";}};
        
        private int seconds;
        
        public Timeout(int seconds) {
            this.seconds = seconds;
        }
        
        public String toString() {
            return "Second-"+seconds;
        }
    }
}

