package javax.wvcm;

import java.util.List;


/**
 * NOT YET STANDARD
 * <p>
 * A "principal" is a distinct human or computational actor that initiates access
 * to network resources.  In this protocol, a principal is an HTTP resource that
 * represents such an actor.
 * </p><p>
 * See section 2 of RFCxxxx (WebDAV ACL).
 * </p>
 */
public interface Principal extends Resource {
    
    public Principal ALL = new GenericPrincipalImpl(Location.ALL);
    public Principal SELF = new GenericPrincipalImpl(Location.SELF);
    public Principal OWNER = new GenericPrincipalImpl(Location.OWNER);
    public Principal AUTHENTICATED = new GenericPrincipalImpl(Location.AUTHENTICATED);
    public Principal UNAUTHENTICATED = new GenericPrincipalImpl(Location.UNAUTHENTICATED);
    
    
    /**
     * Create a Principal on the server.
     *
     * @throws WvcmException Preconditions:
     * <br>(resource-must-be-null): A resource MUST NOT exist at the location of this Resource.
     * <br>(location-ok): The location of this Principal MUST identify a valid location to create this Resource.
     *   A client can determine the location of folders that can contain principals
     *  from the PrincipalFolderList property.
     * @throws WvcmException Postconditions:
     * <br>(initialize-resource): A new Principal resource exists at the location of this Resource.
     */
    public void doCreateResource() throws WvcmException;
    
    /**
     * Get the list of groups (Principal.Group) in which the principal is directly a member.
     *
     * @return   a List
     * @throws   WvcmException if this principal was not created with
     *           {@link PropertyNameList.PropertyName.GROUP_MEMBERSHIP} as a wanted property
     */
    public List getGroupMembership() throws WvcmException;
    
    /**
     * NOT YET STANDARD
     * <p>
     * A "group" is a principal that represents a set of other principals.
     * </p>
     */
    public interface Group extends Principal {
        
        /**
         * Get the list of Principal objects which are direct members of this group.
         *
         * @return   a List
         * @throws   WvcmException if this principal was not created with
         *           {@link PropertyNameList.PropertyName.GROUP_MEMBER_LIST} as a wanted property
         */
        public List getGroupMemberList() throws WvcmException;
        
        /**
         * Set the list of Principal objects which are direct members of this group.
         *
         * @param    members             a  List
         * @throws   WvcmException
         */
        public void setGroupMemberList(List members) throws WvcmException;
    }
    
    /**
     * NOT YET STANDARD
     * <p>
     * A "role" is a principal that represents a set of other principals.
     * </p>
     */
    public interface Role extends Group {
    }
    
    
    /**
     * NOT YET STANDARD
     * Implementation of a generic Principal.
     *
     * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
     * @version $Revision: 1.3 $
     */
    
    public class GenericPrincipalImpl extends GenericResourceImpl implements Principal {
        
        /**
         * Constructor
         *
         * @param    location            a  Location
         */
        public GenericPrincipalImpl(Location location) {
            super(location);
        }
        
        /**
         * Create a Principal on the server.
         *
         * @throws WvcmException Preconditions:
         * <br>(resource-must-be-null): A resource MUST NOT exist at the location of this Resource.
         * <br>(location-ok): The location of this Principal MUST identify a valid location to create this Resource.
         *   A client can determine the location of folders that can contain principals
         *  from the PrincipalFolderList property.
         * @throws WvcmException Postconditions:
         * <br>(initialize-resource): A new Principal resource exists at the location of this Resource.
         */
        public void doCreateResource() throws WvcmException {
            throw new UnsupportedOperationException("Not supported for generic resources");
        }
        
        /**
         * Get the list of groups (Principal.Group) in which the principal is directly a member.
         *
         * @return   a List
         * @throws   WvcmException if this principal was not created with
         *           {@link PropertyNameList.PropertyName.GROUP_MEMBERSHIP} as a wanted property
         */
        public List getGroupMembership() throws WvcmException {
            throw new UnsupportedOperationException("Not supported for generic resources");
        }
    }
}
