package javax.wvcm;

import java.util.List;

/**
 * A WVCM provider.
 */
public interface Provider {
    
    /**
     * Return a list of {@link Folder} objects that identify folders
     * on the server that contain workspaces for this Provider.
     * If this Provider does not allow the client to create new
     * workspaces on the server, an empty List is returned.
     * @param wantedPropertyList The properties available in the returned proxies.
     */
    public List serverWorkspaceFolderList(PropertyNameList wantedPropertyList)
        throws WvcmException;
    
    /**
     * Return a list of {@link Folder} objects that identify folders
     * on the client that contain workspaces for this Provider.
     * If this Provider does not support workspaces on the
     * client, an empty List is returned.
     * @param wantedPropertyList The properties available in the returned proxies.
     */
    public List clientWorkspaceFolderList(PropertyNameList wantedPropertyList)
        throws WvcmException;
    
    /**
     * Return a list of {@link Workspace} objects which
     * can be used as the argument of the
     * {@link Workspace#setServerState} routine
     * for more than one {@link Workspace}.
     * If this Provider does not allow multiple workspaces to
     * share the same ServerState, an empty List is returned.
     * @param wantedPropertyList The properties available in the returned proxies.
     */
    public List serverSharedWorkspaceList(PropertyNameList wantedPropertyList)
        throws WvcmException;
    
    // Location creation routine
    
    /**
     * Return a {@link Location} whose string value is the specified String.
     * @throws WvcmException with ILLEGAL_LOCATION_SYNTAX
     * if the String is not a valid location.
     */
    public Location location(String string) throws WvcmException;
    
    // ResourceList creation routine
    
    /**
     * Return an empty {@link ResourceList}.
     */
    public ResourceList resourceList();
    
    /**
     * NOT YET STANDARD
     * Get the list of generic Principal instances
     *
     * @return   a List
     */
    public List getGenericPrincipalList();
    
    /**
     * NOT YET STANDARD
     * Get the list of generic Privilege instances
     *
     * @return   a List
     */
    public List getGenericPrivilegeList();
}
