package javax.wvcm;
import java.util.List;

/**
 * A list containing {@link Resource} objects,
 * used to perform operations on all elements of the list.
 */
public interface ResourceList extends List {

   /**
    * An iterator of the results of applying a method to
    * each element of a {@link ResourceList}.
    * @see java.util.Iterator
    */
   public interface ResponseIterator {
      /**
       * Return whether the iteration has more elements.
       * @see java.util.Iterator#hasNext
       */
      public boolean hasNext();
      /**
       * Return the result of applying the method to the
       * the next element of the input list.
       * @see java.util.Iterator#next
       */
      public Object next() throws WvcmException;
   };

   /**
    * Apply {@link ControllableResource#doControl doControl}
    * to each element of this {@link ResourceList}.
    */
   public ResponseIterator doControl();

   /**
    * Apply {@link ControllableResource#doCheckin(boolean,boolean) doCheckin}
    * to each element of this {@link ResourceList}.
    */
   public ResponseIterator doCheckin(
      boolean keepCheckedOut,
      boolean forkOK);

   /**
    * Apply {@link ControllableResource#doCheckout(boolean,List,boolean,boolean) doCheckout}
    * to each element of this {@link ResourceList}.
    */
   public ResponseIterator doCheckout(
      boolean forkOK,
      List activityList,
      boolean newActivity,
      boolean unreserved);

   /**
    * Apply {@link ControllableResource#doRefresh doRefresh}
    * to each element of this {@link ResourceList}.
    */
   public ResponseIterator doRefresh(
      PropertyNameList wantedPropertyList,
      boolean ignoreDirty);

   /**
    * Apply {@link ControllableResource#doUncheckout doUncheckout}
    * to each element of this {@link ResourceList}.
    */
   public ResponseIterator doUncheckout();

}
