package javax.wvcm;

import java.util.List;

/**
 * A version history resource contains all versions of a version-controlled resource
 * as the bound members of the version history.
 * The binding name of a version in a version history the version name of that version.
 */
public interface VersionHistory extends Folder {
	
   /**
    * Return the root version of this {@link VersionHistory}.
    * The root version has no predecessors, and each other versions in this {@link VersionHistory}
    * is a descendant of the root version.
    * @throws WvcmException if this {@link VersionHistory} was not created with
    * {@link PropertyNameList.PropertyName#ROOT_VERSION ROOT_VERSION} as a wanted property.
    */
   public Version getRootVersion() throws WvcmException;

   /**
    * Return the Folder that contains a bound member for each label that selects
    * a version of this VersionHistory, where the label is the binding name of
    * the member, and the labelled version is the bound resource.
    * @throws WvcmException if this {@link VersionHistory} was not created with
    * {@link PropertyNameList.PropertyName#VERSION_BY_LABEL_FOLDER VERSION_BY_LABEL_FOLDER} as a wanted property.
    */
   public Folder getVersionByLabelFolder() throws WvcmException;

   /**
    * Return latest version in this {@link VersionHistory}
    * that is a product of the specified activity.
    * @param activity The activity whose latest product is to be returned.
    * @param wantedPropertyList The properties available in the returned proxies.
    */
   public Version doLatestActivityVersionReport(
      Activity activity,
      PropertyNameList wantedPropertyList)
      throws WvcmException;

}
