/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/ActivityImpl.java,v 1.14 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.14 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.List;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.WvcmException;
import org.apache.wvcm.store.ActivityAccessor;

/**
 * Implementation of Activity.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.14 $
 */
public class ActivityImpl extends ResourceImpl implements Activity {
    
    /**
     * Constructor
     */
    public ActivityImpl( Location location ) {
        super (location);
    }

    /**
     * Update the SubactivityList property of this {@link Activity}.
     * @param subactivityList The list of {@link Activity} objects that will be the
     * new value of the SubactivityList property.
     */
    public void setSubactivityList(List subactivityList) {
        loadedProperties().set( PropertyName.SUBACTIVITY_LIST, subactivityList );
    }
    
    /**
     * Return a list of {@link Activity} objects that identify activities
     * whose versions are treated as if
     * they were members of the ActivityVersionList of this {@link Activity}.
     * @throws WvcmException if this {@link Activity} was not created with
     * <code>PropertyName.SUBACTIVITY_LIST</code> as a wanted property.
     * @see #getActivityVersionList
     */
    public List getSubactivityList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.SUBACTIVITY_LIST );
    }
    
    /**
     * Create an activity on the server.  The request will
     * fail if a resource already exists at that location.
     */
    public void doCreateResource() throws WvcmException {
        ((ActivityAccessor)accessor()).doCreateResource();
    }
    
    /**
     * Return a list of {@link ControllableResource} objects that
     * identify all version-controlled resources that are checked out
     * to this {@link Activity}.
     * @throws WvcmException if this {@link Activity} was not created with
     * <code>PropertyName.ACTIVITY_CHECKOUT_LIST</code> as a wanted property.
     */
    public List getActivityCheckoutList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.ACTIVITY_CHECKOUT_LIST );
    }
    
    /**
     * Return a list of {@link Version} objects that identify versions
     * that were created for this {@link Activity}.
     * @throws WvcmException if this {@link Activity} was not created with
     * <code>PropertyName.ACTIVITY_VERSION_LIST</code> as a wanted property.
     */
    public List getActivityVersionList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.ACTIVITY_VERSION_LIST );
    }
    
    /**
     * Apply {@link ControllableResource#doCheckin doCheckin}
     * to each member of the ActivityCheckoutList of this {@link Activity}.
     * @param keepCheckedOut passed into each checkin request.
     * @param forkOK passed into each checkin request.
     */
    public void doCheckin(boolean keepCheckedOut, boolean forkOK) throws WvcmException {
        // TODO: prio=m, effort=0.5, descr=(checkin)
    }
    
    /**
     * Return a list of {@link Workspace} objects that identify
     * workspaces that refer to this {@link Activity} in their CurrentActivityList.
     * @throws WvcmException if this {@link Activity} was not created with
     * <code>PropertyName.CURRENT_WORKSPACE_LIST</code> as a wanted property.
     * @see Workspace#getCurrentActivityList
     */
    public List getCurrentWorkspaceList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.CURRENT_WORKSPACE_LIST );
    }
}

