/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/BaselineImpl.java,v 1.14 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.14 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.Iterator;
import java.util.List;
import javax.wvcm.Baseline;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.WvcmException;

/**
 * Implementation of Baseline.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.14 $
 */
public class BaselineImpl extends VersionImpl implements Baseline {
    
    /**
     * Constructor
     */
    public BaselineImpl( Location location ) {
        super( location );
    }
    
    /**
     * Create an accessor for this resource
     */
    /**
     * Return a list of {@link Baseline} objects that identify
     * the subbaselines of the baseline identified by this {@link Baseline}.
     * created when this {@link Configuration}
     * @throws WvcmException if this {@link Baseline} was not created with
     * <code>PropertyName.SUBBASELINE_LIST</code> as a wanted property.
     */
    public List getSubbaselineList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.SUBBASELINE_LIST );
    }
    
    /**
     * Return an iterator of AddedVersion, DeletedVersion, and
     * ChangedVersion objects, that enumerate the differences between the
     * versions selected by this {@link Baseline} and the baseline argument.
     * @param baseline The baseline being compared to this {@link Baseline}.
     */
    public Iterator doCompareBaselineReport(Baseline baseline) throws WvcmException {
        // TODO: prio=m, effort=2.0, descr=(compare-baseline report)
        return null;
    }
    
    /**
     * Return a folder containing a read-only copy of the
     * version-controlled state of the baseline-controlled folder
     * at the time the baseline identified by this {@link Baseline} was created.
     * @throws WvcmException if this {@link Baseline} was not created with
     * <code>PropertyName.BASELINE_FOLDER</code> as a wanted property.
     */
    public ControllableFolder getBaselineFolder() throws WvcmException {
        return (ControllableFolder)loadedProperties().get( PropertyName.BASELINE_FOLDER );
    }
}

