/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/ControllableFolderImpl.java,v 1.5 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.5 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.Iterator;
import java.util.List;
import javax.wvcm.Baseline;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.LockToken;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.WvcmException;
import javax.wvcm.WvcmException.ReasonCode;
import org.apache.wvcm.store.ControllableFolderAccessor;
import org.apache.wvcm.store.ControllableResourceAccessor;

/**
 * Implementation of Folder.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.5 $
 */
public class ControllableFolderImpl extends ControllableResourceImpl implements ControllableFolder {
    
    /**
     * Constructor
     */
    public ControllableFolderImpl( Location location ) {
        super (location);
    }
    
    // overwrites ControllableResourceImpl.doCreateResource
    public void doCreateResource() throws WvcmException {
        try {
            ((ControllableFolderAccessor)accessor()).doCreateResource();
        }
        catch (WvcmException e) {
            if (e.getReasonCode() != ReasonCode.LOCKED) {
                throw e;
            }
            // retry with lock-tokens from parent
            Folder parentFolder =
                (Folder)location().parent().folder().doReadProperties(null);
            Iterator i = parentFolder.getLockTokens().iterator();
            while (i.hasNext()) {
                addLockToken((LockToken)i.next());
            }
            ((ControllableFolderAccessor)accessor()).doCreateResource();
        }
    }
    
    /**
     * Return whether the folder can be put under baseline control.
     * @throws WvcmException if this {@link Folder} was not created with
     * <code>PropertyName.BASELINE_CONTROLLABLE</code> as a wanted property.
     * @see #doBaselineControl
     */
    public boolean getBaselineControllable() throws WvcmException {
        Boolean bc = (Boolean)loadedProperties().get(PropertyName.BASELINE_CONTROLLABLE);
        return bc.booleanValue();
    }
    
    /**
     * Put this {@link Folder} under baseline control and initialize
     * it with the contents of the specified baseline.
     * @param baseline The baseline used to initialize the folder.
     *
     * Preconditions:
     * (cannot-add-to-existing-history): This Folder MUST NOT identify an existing resource.
     * (one-baseline-controlled-folder-per-history-per-workspace): There MUST NOT be another folder
     *  in the workspace of this Folder whose ControlledConfiguration property
     *  identifies a version-controlled configuration for the baseline history of that baseline.
     *
     * Postconditions:
     * (create-controlled-configuration): A new folder is created at the location of this Folder,
     *  and a new version-controlled configuration is created, whose RootFolder property
     *  identifies the new folder.  The ControlledConfiguration property of the new folder
     *  identifies the new version-controlled configuration.
     * (select-existing-baseline): The CheckedIn property of the new version-controlled configuration
     *  MUST have been set to identify the specified baseline.
     *  A version-controlled member of the folder will be created for each version in the baseline,
     *  where the version-controlled member will have the content of that version,
     *  and will have the same name relative to the folder as the corresponding
     *  version-controlled resource had when the baseline was created.
     *  Any nested folders that are needed to provide the appropriate name
     *  for a version-controlled member will be created.
     */
    public void doBaselineControl(Baseline baseline) throws WvcmException {
        // TODO: prio=m, effort=0.5, descr=(baseline-control)
    }
    
    /**
     * Return an iterator of {@link Resource} objects that contain locally
     * available properties of the resources that are locally known
     * as members of this {@link Folder}.  Locally available information is
     * information that is available on the client host
     * without communicating with the server.
     * @see #doReadMemberList
     * @param wantedPropertyList The list of properties to be retrieved.
     * @param deep Whether to retrieve properties for all members of this {@link Folder}.
     */
    public Iterator readMemberList(PropertyNameList wantedPropertyList, boolean deep) throws WvcmException {
        // TODO: prio=l, effort=1.0, descr=(infrastructure for accessing FS)
        return null;
    }
    
    /**
     * Return a list of String objects that identify
     * the names of version-controlled resources in this {@link Folder}
     * that are eclipsed by non-version-controlled resources.
     * @throws WvcmException if this {@link Folder} was not created with
     * <code>PropertyName.ECLIPSED_LIST</code> as a wanted property.
     */
    public List getEclipsedList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.ECLIPSED_LIST );
    }
    
    /**
     * Put this {@link Folder} under baseline control.
     * <p>
     * A version-controlled configuration resource is associated with
     * this {@link Folder}, which allows versions of the configuration rooted at
     * this {@link Folder} to be created by checking out and checking in the
     * version-controlled configuration resource. </p>
     * <p>
     * A version of a configuration is called a "baseline". </p>
     */
    public void doBaselineControl() throws WvcmException {
        // TODO: prio=m, effort=0.5, descr=(baseline-control)
    }
    
    /**
     * Return a list of Binding objects that identify the
     * bound members of this {@link Folder}.
     * @throws WvcmException if this {@link Folder} was not created with
     * {@link PropertyNameList.PropertyName#BINDING_LIST BINDING_LIST}
     * as a wanted property.
     */
    public List getBindingList() throws WvcmException {
        // TODO
        return null;
    }
    
    /**
     * Return an iterator of {@link Resource} objects that contain properties of
     * the resources that are bound members of this {@link Folder}.
     * If <code>deep</code> is <code>true</code>, then
     * all members of the folder (including this {@link Folder}) are included.
     * @param wantedPropertyList The list of properties to be retrieved.
     * @param deep Whether to retrieve properties for
     * all members of this {@link Folder}.
     * @throws WvcmException Postconditions:
     * <br>(read-bound-members): The result contains a proxy for each bound member of the folder.
     * <br>(read-all-members): If deep is true, the result contains a proxy for
     *  every member of the folder identified by this Folder.
     */
    public Iterator doReadMemberList(PropertyNameList wantedPropertyList, boolean deep) throws WvcmException {
        return folderAccessor().doReadMemberList( wantedPropertyList, deep);
    }
    
    /**
     * Return a list of {@link ControllableResource} objects
     * that identify the controllable resources that are members of
     * this {@link Workspace} and whose versionHistory property identifies
     * a member of the <code>versionHistoryList</code> parameter.
     * @param versionHistoryList A list of {@link VersionHistory} objects that
     * are being located.
     * @param wantedPropertyList The properties to be retrieved for the
     * returned version-controlled resources.
     */
    public List doLocateByHistoryReport(List versionHistoryList, PropertyNameList wantedPropertyList) throws WvcmException {
        return folderAccessor().doLocateByHistoryReport( versionHistoryList, wantedPropertyList );
    }
    
}

