/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/FolderVersionImpl.java,v 1.14 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.14 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.Iterator;
import java.util.List;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

/**
 * Implementation of FolderVersion.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.14 $
 */
public class FolderVersionImpl extends VersionImpl implements FolderVersion {
    
    /**
     * Constructor
     */
    public FolderVersionImpl( Location location ) {
        super( location );
    }

    /**
     * Return an iterator of {@link Resource} objects that contain properties of
     * the resources that are bound members of this {@link Folder}.
     * If <code>deep</code> is <code>true</code>, then
     * all members of the folder (including this {@link Folder}) are included.
     * @param wantedPropertyList The list of properties to be retrieved.
     * @param deep Whether to retrieve properties for
     * all members of this {@link Folder}.
     * @throws WvcmException Postconditions:
     * <br>(read-bound-members): The result contains a proxy for each bound member of the folder.
     * <br>(read-all-members): If deep is true, the result contains a proxy for
     *  every member of the folder identified by this Folder.
     */
    public Iterator doReadMemberList(PropertyNameList wantedPropertyList, boolean deep) throws WvcmException {
        // TODO prio=m, effort=1.0, descr=(doReadMemberList)
        return null;
    }
    
    /**
     * Return a list of Binding objects that identify the
     * bound members of this {@link Folder}.
     * @throws WvcmException if this {@link Folder} was not created with
     * {@link PropertyNameList.PropertyName#BINDING_LIST BINDING_LIST}
     * as a wanted property.
     */
    public List getBindingList() throws WvcmException {
        // TODO PROBABLY DEPRECATED
        return null;
    }
}

