/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/LockTokenImpl.java,v 1.1 2003/12/08 17:14:26 pnever Exp $
 * $Revision: 1.1 $
 * $Date: 2003/12/08 17:14:26 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */
package org.apache.wvcm;

import javax.wvcm.LockToken;
import javax.wvcm.LockToken.*;
import javax.wvcm.Principal;


/**
 * NOT YET STANDARD
 * Describes a lock token.
 */

public class LockTokenImpl implements LockToken {
    
    private String lockId = null;
    private Scope lockScope = Scope.EXCLUSIVE;
    private Depth depth = Depth.ZERO;
    private Principal owner = null;
    private String ownerInfo = "";
    private Timeout timeout = Timeout.INFINITE;
    private Type lockType = Type.WRITE;
    private boolean active = false;
    

    /**
     * Constructor
     *
     * @param    lockId              a  String
     * @param    lockScope           a  Scope
     * @param    depth               a  Depth
     * @param    owner               a  String
     * @param    timeout             a  Timeout
     */
    public LockTokenImpl(String lockId, Scope lockScope, Depth depth, Principal owner, String ownerInfo, Timeout timeout) {
        this.lockId = lockId;
        this.lockScope = lockScope;
        this.depth = depth;
        this.owner = owner;
        this.ownerInfo = ownerInfo;
        this.timeout = timeout;
    }
    
    /**
     * Get the lock ID (an URI in the opaquelocktoken scheme)
     *
     * @return   a String
     */
    public String getLockId() {
        return lockId;
    }
    
    /**
     * Get the lock ID (an URI in the opaquelocktoken scheme);
     * hide, if lock-token is not active
     *
     * @return   a String
     */
    private String showLockId() {
        return isActive()
            ? lockId
            : "?";
    }
    
    /**
     * Get the lock scope
     *
     * @return   a Scope
     */
    public LockToken.Scope getLockScope() {
        return lockScope;
    }
    
    /**
     * Get the lock timeout
     *
     * @return   a Timeout
     */
    public LockToken.Timeout getTimeout() {
        return timeout;
    }
    
    /**
     * Get the lock type
     *
     * @return   a Type
     */
    public LockToken.Type getLockType() {
        return lockType;
    }
    
    /**
     * Get the lock owner
     *
     * @return   a Principal
     *
     */
    public Principal getOwner() {
        return owner;
    }
    
    /**
     * Get the lock owner
     *
     * @return   a String
     *
     */
    public String getOwnerInfo() {
        return ownerInfo;
    }
    
    /**
     * Get the lock depth
     *
     * @return   a Depth
     */
    public LockToken.Depth getDepth() {
        return depth;
    }
    
    /**
     * Method isActive
     *
     * @return   a boolean
     *
     */
    public boolean isActive() {
        return active;
    }
    
    // NON INTERFACE METHODS
    
    /**
     * Method setActive
     *
     * @param    active              a  boolean
     *
     */
    public void setActive(boolean active) {
        this.active = active;
    }
    
    public boolean equals(Object o) {
        if (o instanceof LockTokenImpl) {
            return getLockId().equals(((LockTokenImpl)o).getLockId());
        }
        else {
            return false;
        }
    }
    
    public int hashCode() {
        return getLockId().hashCode();
    }
    
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[lockId=").append(showLockId());
        b.append("; lockScope=").append(getLockScope());
        b.append("; depth=").append(getDepth());
        b.append("; owner=").append(getOwner());
        b.append("; ownerInfo=").append(getOwnerInfo());
        b.append("; timeout=").append(getTimeout());
        b.append("; lockType=").append(getLockType());
        b.append("; isActive=").append(isActive());
        return b.toString();
    }
}

