/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/PrincipalImpl.java,v 1.3 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.List;
import javax.wvcm.Location;
import javax.wvcm.Principal;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.WvcmException;
import org.apache.wvcm.store.PrincipalAccessor;

/**
 * Implementation of Principal.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */

public class PrincipalImpl extends ResourceImpl implements Principal {
    
    /**
     * Constructor
     */
    public PrincipalImpl( Location location ) {
        super (location);
    }
    
    /**
     * Create an Principal on the server.
     *
     * @throws WvcmException Preconditions:
     * <br>(resource-must-be-null): A resource MUST NOT exist at the location of this Resource.
     * <br>(location-ok): The location of this Principal MUST identify a valid location to create this Resource.
     *   A client can determine the location of folders that can contain principals
     *  from the PrincipalFolderList property.
     * @throws WvcmException Postconditions:
     * <br>(initialize-resource): A new Principal resource exists at the location of this Resource.
     */
    public void doCreateResource() throws WvcmException {
        ((PrincipalAccessor)accessor()).doCreateResource();
    }
    
    /**
     * Get the list of groups (Principal.Group) in which the principal is directly a member.
     *
     * @return   a List
     * @throws   WvcmException if this principal was not created with
     *           {@link PropertyNameList.PropertyName.GROUP_MEMBERSHIP} as a wanted property
     */
    public List getGroupMembership() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.GROUP_MEMBERSHIP );
    }
    
    /**
     * Implementation of a group
     */
    public static class GroupImpl extends PrincipalImpl implements Principal.Group {
        
        /**
         * Constructor
         */
        public GroupImpl( Location location ) {
            super (location);
        }
        
        /**
         * Set the list of Principal objects which are direct members of this group.
         *
         * @param    members             a  List
         * @throws   WvcmException
         */
        public void setGroupMemberList(List members) throws WvcmException {
            loadedProperties().set( PropertyName.GROUP_MEMBER_LIST, members );
        }
        
        /**
         * Get the list of Principal objects which are direct members of this group.
         *
         * @return   a List
         * @throws   WvcmException if this principal was not created with
         *           {@link PropertyNameList.PropertyName.GROUP_MEMBER_LIST} as a wanted property
         */
        public List getGroupMemberList() throws WvcmException {
            return (List)loadedProperties().get( PropertyName.GROUP_MEMBER_LIST );
        }
        
    }
    
    /**
     * Implementation of a Role
     */
    public static class RoleImpl extends GroupImpl implements Principal.Role {
        
        /**
         * Constructor
         */
        public RoleImpl( Location location ) {
            super (location);
        }
    }
}

