/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/VersionImpl.java,v 1.14 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.14 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.List;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;
import org.apache.wvcm.store.VersionAccessor;

/**
 * Implementation of Version.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.14 $
 */
public class VersionImpl extends ResourceImpl implements Version {
    
    /**
     * Constructor
     */
    public VersionImpl( Location location ) {
        super( location );
    }
    
    /**
     * Set the specified label on this {@link Version}.
     * If the label is already on another version in the same version history,
     * the label is removed from that other version.
     * @param label The label to set.
     */
    public void doSetLabel(String label) throws WvcmException {
        ((VersionAccessor)accessor()).doSetLabel( label );
    }
    
    /**
     * Return a list of {@link ControllableResource} objects
     * that identify the checked-out version-controlled
     * resources that refer to this {@link Version} in their CheckedOut property.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.CHECKOUT_LIST</code> as a wanted property.
     * @see ControllableResource#getCheckedOut ControllableResource.getCheckedOut
     */
    public List getCheckoutList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.CHECKOUT_LIST );
    }
    
    /**
     * Return the version history resource that contains this {@link Version}.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.VERSION_HISTORY</code> as a wanted property.
     */
    public VersionHistory getVersionHistory() throws WvcmException {
        return (VersionHistory)loadedProperties().get( PropertyName.VERSION_HISTORY );
    }
    
    /**
     * Set the ActivityList property.
     * @param activityList A list of {@link Activity} objects that specify
     * the new ActivityList property for this {@link Version}.
     */
    public void setActivityList(List activityList) {
        loadedProperties().set( PropertyName.ACTIVITY_LIST, activityList );
    }
    
    /**
     * Return a list of String objects that identify
     * labels that currently select this {@link Version}.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.LABEL_NAME_LIST</code> as a wanted property.
     */
    public List getLabelNameList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.LABEL_NAME_LIST );
    }
    
    /**
     * Set the CheckoutFork property.
     * @param val The new CheckoutFork value for this {@link Version}.
     */
    public void setCheckoutFork(int val) {
        loadedProperties().set( PropertyName.CHECKOUT_FORK, new Integer(val) );
    }
    
    /**
     * Return a list of {@link Version} objects that identify
     * the versions that are the successors of this {@link Version}.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.SUCCESSOR_LIST</code> as a wanted property.
     */
    public List getSuccessorList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.SUCCESSOR_LIST );
    }
    
    /**
     * Return the version name of this {@link Version}.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.VERSION_NAME</code> as a wanted property.
     */
    public String getVersionName() throws WvcmException {
        return (String)loadedProperties().get( PropertyName.VERSION_NAME );
    }
    
    /**
     * Removes the specified label from this {@link Version}.
     * @param label The label to remove.
     */
    public void doRemoveLabel(String label) throws WvcmException {
        ((VersionAccessor)accessor()).doRemoveLabel( label );
    }
    
    /**
     * Add the specified label to this {@link Version}.
     * @param label The label to add.
     */
    public void doAddLabel(String label) throws WvcmException {
        ((VersionAccessor)accessor()).doAddLabel( label );
    }
    
    /**
     * Return the CheckinFork property, which determines whether
     * this {@link Version} can be given more than one successor.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.CHECKIN_FORK</code> as a wanted property.
     */
    public int getCheckinFork() throws WvcmException {
        Integer cf = (Integer)loadedProperties().get( PropertyName.CHECKIN_FORK );
        return cf.intValue();
    }
    
    /**
     * Return a list of {@link Version} objects that identify
     * the predecessors of this {@link Version}.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.PREDECESSOR_LIST</code> as a wanted property.
     */
    public List getPredecessorList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.PREDECESSOR_LIST );
    }
    
    /**
     * Set the CheckinFork property.
     * @param val The new CheckinFork value for this {@link Version}.
     */
    public void setCheckinFork(int val) {
        loadedProperties().set( PropertyName.CHECKIN_FORK, new Integer(val) );
    }
    
    /**
     * Return the CheckoutFork property, which determines whether
     * a version-controlled resource selecting this {@link Version}
     * can be checked out when it already has a successor version.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.CHECKOUT_FORK</code> as a wanted property.
     */
    public int getCheckoutFork() throws WvcmException {
        Integer cf = (Integer)loadedProperties().get( PropertyName.CHECKOUT_FORK );
        return cf.intValue();
    }
    
    /**
     * Return a list of {@link Activity} objects that identify the
     * activities to which this {@link Version} contributes, and on which
     * lines of descent this version appears.
     * @throws WvcmException if this {@link Version} was not created with
     * <code>PropertyName.ACTIVITY_LIST</code> as a wanted property.
     */
    public List getActivityList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.ACTIVITY_LIST );
    }
}

