/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/WorkspaceImpl.java,v 1.15 2004/07/30 06:52:25 ozeigermann Exp $
 * $Revision: 1.15 $
 * $Date: 2004/07/30 06:52:25 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm;

import java.util.Iterator;
import java.util.List;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.wvcm.store.WorkspaceAccessor;

/**
 * Implementation of Workspace.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.15 $
 */
public class WorkspaceImpl extends ControllableFolderImpl implements Workspace {
    
    /**
     * Constructor
     */
    public WorkspaceImpl( Location location ) {
        super (location);
    }

    // overwrites ControllableResourceImpl.doCreateResource
    public void doCreateResource() throws WvcmException {
        ((WorkspaceAccessor)accessor()).doCreateResource();
    }
    
    /**
     * When this {@link Workspace} is located on the client,
     * this routine is used to specify the {@link Workspace}
     * on the server that maintains the server state for
     * this {@link Workspace}
     * This property must be set before creating a workspace that
     * is located on the client.
     * @param serverState The {@link Workspace} located
     * on the server that maintains the server state
     * for this {@link Workspace}.
     * @see ControllableResource#getServerState
     */
    public void setServerState(Workspace workspace) {
        loadedProperties().set( PropertyName.SERVER_STATE, workspace );
    }
    
    /**
     * Return a list of {@link ControllableResource} objects
     * that identify the members of this {@link Workspace} that are checked-out
     * version-controlled resources.
     * @throws WvcmException if this {@link Workspace} was not created with
     * <code>PropertyName.WORKSPACE_CHECKOUT_LIST</code> as a wanted property.
     */
    public List getWorkspaceCheckoutList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.WORKSPACE_CHECKOUT_LIST );
    }
    
    /**
     * Return a list of {@link Folder} objects that identify folders that
     * can contain activities for this {@link Workspace}.
     * This list is empty if this {@link Workspace}
     * does not provide activity support.
     * @throws WvcmException if this {@link Workspace} was not created with
     * <code>PropertyName.ACTIVITY_FOLDER_LIST</code>
     * as a wanted property.
     */
    public List getActivityFolderList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.ACTIVITY_FOLDER_LIST );
    }
    
    /**
     * Merge the versions specified in the <code>sourceList</code> into
     * this {@link ControllableResource}.
     * The "target" of a particular source version is the version-controlled
     * member of the workspace identified by this {@link Workspace}
     * that is associated with the version history for that version.
     * @return An iterator of {@link ControllableResource} objects that
     * identifies the resources modified by the merge.
     * @param sourceList A list of {@link Resource} objects that
     * identifies the versions to be merged.
     * If a member of sourceList is an activity,
     * each version in the ActivityVersionList is a source version.
     * If a member of sourceList is a version-controlled resource,
     * the checked-in version of the member is a source version.
     * If a member of sourceList is a folder, all members of the configuration
     * rooted at that folder are considered members of the sourceList.
     * @param checkinActivity If a member of the sourceList is an activity,
     * apply doCheckin to that activity before performing the merge.
     * @param noAutoMerge See ControllableResource#doMerge.
     * @param noCheckout See ControllableResource#doMerge.
     * @param forkOK See ControllableResource#doMerge.
     * @param unreserved See ControllableResource#doMerge.
     * @param activityList See ControllableResource#doMerge.
     * @param newActivity See ControllableResource#doMerge.
     * @param wantedPropertyList See ControllableResource#doMerge.
     */
    public Iterator doMerge(List sourceList, boolean checkinActivity, boolean noAutoMerge, boolean noCheckout, boolean forkOK, boolean unreserved, List activityList, boolean newActivity, PropertyNameList wantedPropertyList) throws WvcmException {
        // TODO: prio=m, effort=1.0, descr=(merge)
        return null;
    }
    
    /**
     * Return a list of {@link Folder} objects that identify folders that
     * can contain version histories for this {@link Workspace}.
     * This list is empty if this {@link Workspace}
     * does not provide versioning support.
     * @throws WvcmException if this {@link Workspace} was not created with
     * <code>PropertyName.VERSION_HISTORY_FOLDER_LIST</code>
     * as a wanted property.
     */
    public List getVersionHistoryFolderList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.VERSION_HISTORY_FOLDER_LIST );
    }
    
    /**
     * Return a list of {@link Folder} objects that identify the folders
     * that are the roots of the baseline-controlled
     * configurations in that workspace.
     * @throws WvcmException if this {@link Workspace} was not created with
     * <code>PropertyName.BASELINE_CONTROLLED_FOLDER_LIST</code>
     * as a wanted property.
     */
    public List getBaselineControlledFolderList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.BASELINE_CONTROLLED_FOLDER_LIST );
    }
    
    /**
     * Return a list of {@link Activity} objects that identify
     * the activities that will initialize the ActivityList property
     * of a version-controlled member of this {@link Workspace} when that member
     * is checked out and no explicit ActivityList is
     * specified in the checkout request.
     * @throws WvcmException if this {@link Workspace} was not created with
     * <code>PropertyName.CURRENT_ACTIVITY_LIST</code> as a wanted property.
     */
    public List getCurrentActivityList() throws WvcmException {
        return (List)loadedProperties().get( PropertyName.CURRENT_ACTIVITY_LIST );
    }
    
    /**
     * Set the CurrentActivityList property.
     * @param activityList The list of {@link Activity} objects that
     * identify the new CurrentActivityList for this {@link Workspace}.
     */
    public void setCurrentActivityList(List activityList) {
        loadedProperties().set( PropertyName.CURRENT_ACTIVITY_LIST, activityList );
    }
    
    /**
     * Return an iterator of MergePreviewReport objects,
     * indicating what resources would be modified by a
     * {@link #doMerge doMerge}.
     * @param sourceList A list of {@link Resource} objects that identify
     * the versions to be merged.
     */
    public Iterator doMergePreviewReport(List sourceList) throws WvcmException {
        // TODO: prio=m, effort=1.0, descr=(merge-preview report)
        return null;
    }
}

