/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/sample/SimpleExample.java,v 1.8 2004/07/30 06:52:26 ozeigermann Exp $
 * $Revision: 1.8 $
 * $Date: 2004/07/30 06:52:26 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */
package org.apache.wvcm.sample;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.ProviderFactory.Callback;
import javax.wvcm.Resource;
import org.apache.wvcm.sample.util.ReportFormat;
import org.apache.wvcm.sample.util.WvcmTypes;

/**
 * Sample WVCM Application: Basic Command-line Client.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.8 $
 */
public class SimpleExample {
    
    private static Properties javaprops = new Properties();
    static {
        try {
            javaprops.load( SimpleExample.class.getResourceAsStream("/org/apache/wvcm/sample/sample.properties") );
        } catch (java.io.IOException e) {}
    }
    
    private Provider provider;
    private String host;
    private String port;
    private String context;
    private String realm;
    
    private SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm");
    private ReportFormat rf = new ReportFormat( new int[]{20,20,14}, 1 );
    private String[] rheaders = {"Binding Name", "Type", "Last Modified"};
    
    /**
     *
     */
    public static void main(String[] args) {
        try {
            new SimpleExample().run( args );
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * This method is called after start up.
     */
    public void run(String[] args) throws Exception {
        // Print application prompt to console.
        System.out.println("Simple Example");
        
        // create the provider
        host = (String)javaprops.get("host");
        port = (String)javaprops.get("port");
        context = (String)javaprops.get("context");
        realm = (String)javaprops.get("realm");
        Callback callback = new CallbackImpl();
        Hashtable h = new Hashtable();
        if( host != null ) h.put( "host", host );
        if( port != null ) h.put( "port", port );
        if( realm != null ) h.put( "realm", realm );
        if( context != null ) h.put( "context", context );
        provider = ProviderFactory.createProvider(
            "org.apache.wvcm.ProviderImpl", callback, h );
        
        // read members of context folder
        Location location = provider.location( "/"+context );
        ControllableFolder folder = (ControllableFolder)location.folder();
        PropertyNameList pnl = new PropertyNameList(
            new PropertyName[]
            {PropertyName.LAST_MODIFIED}
        );
        Iterator mlIter = folder.doReadMemberList( pnl, false );
        System.out.println( rf.format(rheaders) );
        System.out.println( rf.separator('-') );
        while (mlIter.hasNext()) {
            Resource r = (Resource)mlIter.next();
            String p = r.location().string();
            System.out.println( rf.format(p.substring(p.lastIndexOf("/") + 1), WvcmTypes.typeName(r), df.format(r.getLastModified())) );
        }
    }
    
    /**
     * Callback implementation
     */
    private class CallbackImpl implements Callback {
        
        Authentication authentication = new AuthenticationImpl();
        
        /**
         * Return authentication information for the current user.
         * @param realm The authentication realm for the provider.
         */
        public Authentication getAuthentication(String realm, Integer retryCount) {
            //            System.out.println("@@@ getAuthentication("+realm+","+retryCount+")");
            return authentication;
        }
        
        class AuthenticationImpl implements Authentication {
            
            /** Return the password of the current user. */
            public String password() {
                return readInput("Password").trim();
            }
            
            /** Return the login name of the current user. */
            public String loginName() {
                return readInput("User").trim();
            }
            
            /**
             * This method reads user input from console.
             */
            private String readInput(String key) {
                try {
                    System.out.print(key+": ");
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int c = System.in.read();
                    while (c >= 0) {
                        if (c == '\n') {
                            break;
                        }
                        out.write( c );
                        c = System.in.read();
                    }
                    String result = out.toString().trim();
                    return result;
                }
                catch (java.io.IOException e) {
                    // An error occured.
                    System.err.println("Error while reading input.");
                    return "";
                }
            }
        }
    }
}
