/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/sample/util/WvcmProperties.java,v 1.8 2004/07/30 06:52:26 ozeigermann Exp $
 * $Revision: 1.8 $
 * $Date: 2004/07/30 06:52:26 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */
package org.apache.wvcm.sample.util;

import java.util.HashMap;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Principal;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;

/**
 * Access Properties by name
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.8 $
 */
public class WvcmProperties {
    
    private static Map properties = new HashMap();
    static {
        properties.put("activity-checkout-list", PropertyName.ACTIVITY_CHECKOUT_LIST);
        properties.put("activity-folder-list", PropertyName.ACTIVITY_FOLDER_LIST);
        properties.put("activity-list", PropertyName.ACTIVITY_LIST);
        properties.put("activity-version-list", PropertyName.ACTIVITY_VERSION_LIST);
        properties.put("auto-merge-list", PropertyName.AUTO_MERGE_LIST);
        properties.put("baseline-controllable", PropertyName.BASELINE_CONTROLLABLE);
        properties.put("baseline-controlled-folder-list", PropertyName.BASELINE_CONTROLLED_FOLDER_LIST);
        properties.put("baseline-folder", PropertyName.BASELINE_FOLDER);
        properties.put("binding-list", PropertyName.BINDING_LIST);
        properties.put("checked-in", PropertyName.CHECKED_IN);
        properties.put("checked-out", PropertyName.CHECKED_OUT);
        properties.put("checkin-fork", PropertyName.CHECKIN_FORK);
        properties.put("checkout-fork", PropertyName.CHECKOUT_FORK);
        properties.put("checkout-list", PropertyName.CHECKOUT_LIST);
        properties.put("comment", PropertyName.COMMENT);
        properties.put("content-character-set", PropertyName.CONTENT_CHARACTER_SET);
        properties.put("content-identifier", PropertyName.CONTENT_IDENTIFIER);
        properties.put("content-language", PropertyName.CONTENT_LANGUAGE);
        properties.put("content-length", PropertyName.CONTENT_LENGTH);
        properties.put("content-type", PropertyName.CONTENT_TYPE);
        properties.put("creation-date", PropertyName.CREATION_DATE);
        properties.put("creator-display-name", PropertyName.CREATOR_DISPLAY_NAME);
        properties.put("current-activity-list", PropertyName.CURRENT_ACTIVITY_LIST);
        properties.put("current-workspace-list", PropertyName.CURRENT_WORKSPACE_LIST);
        properties.put("dirty-property-list", PropertyName.DIRTY_PROPERTY_LIST);
        properties.put("display-name", PropertyName.DISPLAY_NAME);
        properties.put("eclipsed-list", PropertyName.ECLIPSED_LIST);
        properties.put("is-checked-out", PropertyName.IS_CHECKED_OUT);
        properties.put("is-dirty-content", PropertyName.IS_DIRTY_CONTENT);
        properties.put("is-stale-content", PropertyName.IS_STALE_CONTENT);
        properties.put("label-name-list", PropertyName.LABEL_NAME_LIST);
        properties.put("last-modified", PropertyName.LAST_MODIFIED);
        properties.put("merge-list", PropertyName.MERGE_LIST);
        properties.put("parent-binding-list", PropertyName.PARENT_BINDING_LIST);
        properties.put("predecessor-list", PropertyName.PREDECESSOR_LIST);
        properties.put("provider-list", PropertyName.PROVIDER_LIST);
        properties.put("resource-identifier", PropertyName.RESOURCE_IDENTIFIER);
        properties.put("root-folder", PropertyName.ROOT_FOLDER);
        properties.put("root-version", PropertyName.ROOT_VERSION);
        properties.put("server-state", PropertyName.SERVER_STATE);
        properties.put("stale-property-list", PropertyName.STALE_PROPERTY_LIST);
        properties.put("subactivity-list", PropertyName.SUBACTIVITY_LIST);
        properties.put("subbaseline-list", PropertyName.SUBBASELINE_LIST);
        properties.put("successor-list", PropertyName.SUCCESSOR_LIST);
        properties.put("unreserved", PropertyName.UNRESERVED);
        properties.put("version-by-label-folder", PropertyName.VERSION_BY_LABEL_FOLDER);
        properties.put("version-controllable", PropertyName.VERSION_CONTROLLABLE);
        properties.put("version-controlled-configuration", PropertyName.VERSION_CONTROLLED_CONFIGURATION);
        properties.put("version-history", PropertyName.VERSION_HISTORY);
        properties.put("version-history-folder-list", PropertyName.VERSION_HISTORY_FOLDER_LIST);
        properties.put("version-name", PropertyName.VERSION_NAME);
        properties.put("workspace", PropertyName.WORKSPACE);
        properties.put("workspace-checkout-list", PropertyName.WORKSPACE_CHECKOUT_LIST);
        properties.put("workspace-folder-list", PropertyName.WORKSPACE_FOLDER_LIST);
        
        // NOT YET STANDARD: ACL-related properties
        properties.put("group-member-list", PropertyName.GROUP_MEMBER_LIST);
        properties.put("group-membership", PropertyName.GROUP_MEMBERSHIP);
        properties.put("owner", PropertyName.OWNER);
        properties.put("principal-folder-list", PropertyName.PRINCIPAL_FOLDER_LIST);
        properties.put("privilege-folder-list", PropertyName.PRIVILEGE_FOLDER_LIST);
        properties.put("supported-privilege-list", PropertyName.SUPPORTED_PRIVILEGE_LIST);
        properties.put("modification-date", PropertyName.MODIFICATION_DATE);
        properties.put("creation-user", PropertyName.CREATION_USER);
        properties.put("modification-user", PropertyName.MODIFICATION_USER);
    }
    
    public static PropertyName byName( String name ) {
        return (PropertyName)properties.get(name);
    }
    
    public static PropertyNameList allProperties() {
        return new PropertyNameList(
            new PropertyName[]{
                PropertyName.ACTIVITY_CHECKOUT_LIST,
                    PropertyName.ACTIVITY_FOLDER_LIST,
                    PropertyName.ACTIVITY_LIST,
                    PropertyName.ACTIVITY_VERSION_LIST,
                    PropertyName.AUTO_MERGE_LIST,
                    PropertyName.BASELINE_CONTROLLABLE,
                    PropertyName.BASELINE_CONTROLLED_FOLDER_LIST,
                    PropertyName.BASELINE_FOLDER,
                    PropertyName.BINDING_LIST,
                    PropertyName.CHECKED_IN,
                    PropertyName.CHECKED_OUT,
                    PropertyName.CHECKIN_FORK,
                    PropertyName.CHECKOUT_FORK,
                    PropertyName.CHECKOUT_LIST,
                    PropertyName.COMMENT,
                    PropertyName.CONTENT_CHARACTER_SET,
                    PropertyName.CONTENT_IDENTIFIER,
                    PropertyName.CONTENT_LANGUAGE,
                    PropertyName.CONTENT_LENGTH,
                    PropertyName.CONTENT_TYPE,
                    PropertyName.CREATION_DATE,
                    PropertyName.CREATOR_DISPLAY_NAME,
                    PropertyName.CURRENT_ACTIVITY_LIST,
                    PropertyName.CURRENT_WORKSPACE_LIST,
                    PropertyName.DIRTY_PROPERTY_LIST,
                    PropertyName.DISPLAY_NAME,
                    PropertyName.ECLIPSED_LIST,
                    PropertyName.IS_CHECKED_OUT,
                    PropertyName.IS_DIRTY_CONTENT,
                    PropertyName.IS_STALE_CONTENT,
                    PropertyName.LABEL_NAME_LIST,
                    PropertyName.LAST_MODIFIED,
                    PropertyName.MERGE_LIST,
                    PropertyName.PARENT_BINDING_LIST,
                    PropertyName.PREDECESSOR_LIST,
                    PropertyName.PROVIDER_LIST,
                    PropertyName.RESOURCE_IDENTIFIER,
                    PropertyName.ROOT_FOLDER,
                    PropertyName.ROOT_VERSION,
                    PropertyName.SERVER_STATE,
                    PropertyName.STALE_PROPERTY_LIST,
                    PropertyName.SUBACTIVITY_LIST,
                    PropertyName.SUBBASELINE_LIST,
                    PropertyName.SUCCESSOR_LIST,
                    PropertyName.UNRESERVED,
                    PropertyName.VERSION_BY_LABEL_FOLDER,
                    PropertyName.VERSION_CONTROLLABLE,
                    PropertyName.VERSION_CONTROLLED_CONFIGURATION,
                    PropertyName.VERSION_HISTORY,
                    PropertyName.VERSION_HISTORY_FOLDER_LIST,
                    PropertyName.VERSION_NAME,
                    PropertyName.WORKSPACE,
                    PropertyName.WORKSPACE_CHECKOUT_LIST,
                    PropertyName.WORKSPACE_FOLDER_LIST,
                    
                    // NOT YET STANDARD: ACL-related properties
                    PropertyName.GROUP_MEMBER_LIST,
                    PropertyName.GROUP_MEMBERSHIP,
                    PropertyName.OWNER,
                    PropertyName.PRINCIPAL_FOLDER_LIST,
                    PropertyName.PRIVILEGE_FOLDER_LIST,
                    PropertyName.SUPPORTED_PRIVILEGE_LIST
            }
        );
    }
    
    public static PropertyNameList allProperties( Class type, boolean includeInherited ) {
        PropertyNameList pnl;
        
        if (type == Resource.class) {
            return new PropertyNameList(
                new PropertyName[]{
                    PropertyName.COMMENT,
                        PropertyName.CONTENT_CHARACTER_SET,
                        PropertyName.CONTENT_IDENTIFIER,
                        PropertyName.CONTENT_LANGUAGE,
                        PropertyName.CONTENT_LENGTH,
                        PropertyName.CONTENT_TYPE,
                        PropertyName.CREATION_DATE,
                        PropertyName.CREATOR_DISPLAY_NAME,
                        PropertyName.DISPLAY_NAME,
                        PropertyName.LAST_MODIFIED,
                        PropertyName.PARENT_BINDING_LIST,
                        PropertyName.RESOURCE_IDENTIFIER,
                        PropertyName.WORKSPACE_FOLDER_LIST,
                        
                        // NOT YET STANDARD: ACL-related properties
                        PropertyName.OWNER,
                        PropertyName.PRINCIPAL_FOLDER_LIST,
                        PropertyName.PRIVILEGE_FOLDER_LIST,
                        PropertyName.SUPPORTED_PRIVILEGE_LIST
                }
            );
        }
        else if (type == Activity.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.ACTIVITY_CHECKOUT_LIST,
                        PropertyName.ACTIVITY_VERSION_LIST,
                        PropertyName.CURRENT_WORKSPACE_LIST,
                        PropertyName.SUBACTIVITY_LIST
                }
            );
            return includeInherited
                ? concat( allProperties( Resource.class, true ), pnl )
                : pnl;
        }
        else if (type == ControllableResource.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.ACTIVITY_LIST,
                        PropertyName.AUTO_MERGE_LIST,
                        PropertyName.CHECKED_IN,
                        PropertyName.CHECKED_OUT,
                        PropertyName.DIRTY_PROPERTY_LIST,
                        PropertyName.IS_CHECKED_OUT,
                        PropertyName.IS_DIRTY_CONTENT,
                        PropertyName.IS_STALE_CONTENT,
                        PropertyName.MERGE_LIST,
                        PropertyName.PREDECESSOR_LIST,
                        PropertyName.SERVER_STATE,
                        PropertyName.STALE_PROPERTY_LIST,
                        PropertyName.UNRESERVED,
                        PropertyName.VERSION_CONTROLLABLE,
                        PropertyName.VERSION_CONTROLLED_CONFIGURATION,
                        PropertyName.VERSION_HISTORY,
                        PropertyName.WORKSPACE
                }
            );
            return includeInherited
                ? concat( allProperties( Resource.class, true ), pnl )
                : pnl;
        }
        else if (type == Configuration.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.ROOT_FOLDER,
                        PropertyName.SUBBASELINE_LIST
                }
            );
            return includeInherited
                ? concat( allProperties( ControllableResource.class, true ), pnl )
                : pnl;
        }
        else if (type == ControllableFolder.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.BASELINE_CONTROLLABLE,
                        PropertyName.ECLIPSED_LIST
                }
            );
            return includeInherited
                ? concat( allProperties(Folder.class, true),
                         concat(allProperties(ControllableResource.class, true), pnl) )
                : pnl;
        }
        else if (type == Workspace.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.ACTIVITY_FOLDER_LIST,
                        PropertyName.BASELINE_CONTROLLED_FOLDER_LIST,
                        PropertyName.CURRENT_ACTIVITY_LIST,
                        PropertyName.VERSION_HISTORY_FOLDER_LIST,
                        PropertyName.WORKSPACE_CHECKOUT_LIST
                }
            );
            return includeInherited
                ? concat(allProperties( ControllableFolder.class, true ), pnl )
                : pnl;
        }
        else if (type == Folder.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.BINDING_LIST
                }
            );
            return includeInherited
                ? concat( allProperties( Resource.class, true ), pnl )
                : pnl;
        }
        else if (type == Version.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.ACTIVITY_LIST,
                        PropertyName.CHECKIN_FORK,
                        PropertyName.CHECKOUT_FORK,
                        PropertyName.CHECKOUT_LIST,
                        PropertyName.LABEL_NAME_LIST,
                        PropertyName.PREDECESSOR_LIST,
                        PropertyName.SUCCESSOR_LIST,
                        PropertyName.VERSION_HISTORY,
                        PropertyName.VERSION_NAME
                }
            );
            return includeInherited
                ? concat( allProperties( Resource.class, true ), pnl )
                : pnl;
        }
        else if (type == Baseline.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.BASELINE_FOLDER,
                        PropertyName.SUBBASELINE_LIST
                }
            );
            return includeInherited
                ? concat( allProperties( Version.class, true ), pnl )
                : pnl;
        }
        else if (type == FolderVersion.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                }
            );
            return includeInherited
                ? concat( allProperties(Folder.class, true),
                         concat( allProperties(Version.class, true), pnl) )
                : pnl;
        }
        else if (type == VersionHistory.class) {
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.ROOT_VERSION,
                        PropertyName.VERSION_BY_LABEL_FOLDER
                }
            );
            return includeInherited
                ? concat( allProperties( Folder.class, true ), pnl )
                : pnl;
        }
            
        else if (type == Principal.Group.class) {
            // NOT YET STANDARD: ACL-related properties
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.GROUP_MEMBERSHIP
                }
            );
            return includeInherited
                ? concat( allProperties( Resource.class, true ), pnl )
                : pnl;
        }
        else if (type == Principal.class) {
            // NOT YET STANDARD: ACL-related properties
            pnl = new PropertyNameList(
                new PropertyName[]{
                    PropertyName.GROUP_MEMBER_LIST
                }
            );
            return includeInherited
                ? concat( allProperties( Resource.class, true ), pnl )
                : pnl;
        }
        return null;
    }
    
    private static PropertyNameList concat(PropertyNameList pnl1, PropertyNameList pnl2) {
        PropertyName[] pn1 = pnl1.getPropertyNames();
        PropertyName[] pn2 = pnl2.getPropertyNames();
        PropertyName[] pn = new PropertyName[pn1.length + pn2.length];
        for ( int i = 0; i < pn1.length; i++) {
            pn[i] = pn1[i];
        }
        for ( int i = 0; i < pn2.length; i++) {
            pn[pn1.length + i] = pn2[i];
        }
        return new PropertyNameList(pn);
    }
}

