/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/store/AccessorFactory.java,v 1.14 2004/07/30 06:52:26 ozeigermann Exp $
 * $Revision: 1.14 $
 * $Date: 2004/07/30 06:52:26 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store;

import java.util.HashMap;
import java.util.Map;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import org.apache.wvcm.ActivityImpl;
import org.apache.wvcm.BaselineImpl;
import org.apache.wvcm.ConfigurationImpl;
import org.apache.wvcm.ControllableFolderImpl;
import org.apache.wvcm.ControllableResourceImpl;
import org.apache.wvcm.FolderImpl;
import org.apache.wvcm.FolderVersionImpl;
import org.apache.wvcm.LocationImpl;
import org.apache.wvcm.PrincipalImpl;
import org.apache.wvcm.PrivilegeImpl;
import org.apache.wvcm.ProviderImpl;
import org.apache.wvcm.ResourceImpl;
import org.apache.wvcm.VersionHistoryImpl;
import org.apache.wvcm.VersionImpl;
import org.apache.wvcm.WorkspaceImpl;
import org.apache.wvcm.store.webdav.ActivityWebdavAccessor;
import org.apache.wvcm.store.webdav.BaselineWebdavAccessor;
import org.apache.wvcm.store.webdav.ConfigurationWebdavAccessor;
import org.apache.wvcm.store.webdav.ControllableFolderWebdavAccessor;
import org.apache.wvcm.store.webdav.ControllableResourceWebdavAccessor;
import org.apache.wvcm.store.webdav.FolderVersionWebdavAccessor;
import org.apache.wvcm.store.webdav.FolderWebdavAccessor;
import org.apache.wvcm.store.webdav.PrincipalWebdavAccessor;
import org.apache.wvcm.store.webdav.PrivilegeWebdavAccessor;
import org.apache.wvcm.store.webdav.ResourceWebdavAccessor;
import org.apache.wvcm.store.webdav.VersionHistoryWebdavAccessor;
import org.apache.wvcm.store.webdav.VersionWebdavAccessor;
import org.apache.wvcm.store.webdav.WebdavAccessor;
import org.apache.wvcm.store.webdav.WorkspaceWebdavAccessor;

/**
 * Accessor factory.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.14 $
 */
public class AccessorFactory {
    
    private static Map serverAccessors = new HashMap();
    static {
        serverAccessors.put( ProviderImpl.class, WebdavAccessor.class );
        serverAccessors.put( ResourceImpl.class, ResourceWebdavAccessor.class );
        serverAccessors.put( ActivityImpl.class, ActivityWebdavAccessor.class );
        serverAccessors.put( ControllableResourceImpl.class, ControllableResourceWebdavAccessor.class );
        serverAccessors.put( ConfigurationImpl.class, ConfigurationWebdavAccessor.class );
        serverAccessors.put( FolderImpl.class, FolderWebdavAccessor.class );
        serverAccessors.put( ControllableFolderImpl.class, ControllableFolderWebdavAccessor.class );
        serverAccessors.put( WorkspaceImpl.class, WorkspaceWebdavAccessor.class );
        serverAccessors.put( VersionHistoryImpl.class, VersionHistoryWebdavAccessor.class );
        serverAccessors.put( VersionImpl.class, VersionWebdavAccessor.class );
        serverAccessors.put( BaselineImpl.class, BaselineWebdavAccessor.class );
        serverAccessors.put( FolderVersionImpl.class, FolderVersionWebdavAccessor.class );
        serverAccessors.put( PrincipalImpl.class, PrincipalWebdavAccessor.class );
        serverAccessors.put( PrincipalImpl.GroupImpl.class, PrincipalWebdavAccessor.class );
        serverAccessors.put( PrincipalImpl.RoleImpl.class, PrincipalWebdavAccessor.class );
        serverAccessors.put( PrivilegeImpl.class, PrivilegeWebdavAccessor.class );
    }
    
    public static Accessor createServerAccessor( Provider provider ) {
        // create a server accessor
        try {
            Class accessorCls = (Class)serverAccessors.get( provider.getClass() );
            Class[] parmtypes = {Provider.class};
            Object[] initargs = {provider};
            return
                (Accessor)accessorCls.getConstructor(parmtypes).newInstance(initargs);
        }
        catch( Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException( "Cannot create server-side accessor for the provider" );
        }
    }
    
    public static ResourceAccessor createAccessor( Resource resource ) {
        LocationImpl loc = (LocationImpl)resource.location();
        if( loc.isClientSide() ) {
            // TODO: prio=l, effort=15.0, descr=(create a filesystem accessor)
            return null;
        }
        else {
            // create a server accessor
            try {
                Class accessorCls = (Class)serverAccessors.get( resource.getClass() );
                Class[] parmtypes = {Resource.class};
                Object[] initargs = {resource};
                return
                    (ResourceAccessor)accessorCls.getConstructor(parmtypes).newInstance(initargs);
            }
            catch( Throwable e) {
                e.printStackTrace();
                throw new IllegalStateException( "Cannot create server-side accessor for "+loc.string() );
            }
        }
    }
    
    public static FolderAccessor createFolderAccessor( Resource resource ) {
        LocationImpl loc = (LocationImpl)resource.location();
        if( loc.isClientSide() ) {
            // TODO: prio=l, effort=15.0, descr=(create a filesystem accessor)
            return null;
        }
        else {
            // create a folder accessor if needed
            if (resource instanceof ControllableFolderImpl ||
                resource instanceof VersionHistoryImpl     ||
                resource instanceof FolderVersionImpl
               ) {
                
                return new FolderWebdavAccessor(resource);
            }
            else {
                return null;
            }
        }
    }
}

