/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/store/webdav/PrincipalWebdavAccessor.java,v 1.4 2005/03/04 18:14:31 pnever Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/04 18:14:31 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store.webdav;
import org.apache.wvcm.store.webdav.response.*;

import javax.wvcm.Principal;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import javax.wvcm.WvcmException.ReasonCode;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.webdav.methods.MkcolMethod;
import org.apache.wvcm.LocationImpl;
import org.apache.wvcm.store.PrincipalAccessor;

/**
 * WebDAV-based implementation of PrincipalAccessor.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.4 $
 */
public class PrincipalWebdavAccessor extends ResourceWebdavAccessor implements PrincipalAccessor {
    
    /**
     * Constructor.
     */
    public PrincipalWebdavAccessor( Resource resource ) {
        super( resource );
    }
    
    /**
     * Create a new persistent Principal at the location of the associated
     * resource.
     *
     * @throws   WvcmException
     */
    public void doCreateResource() throws WvcmException {
        Principal Principal = (Principal)resource();
        LocationImpl loc = (LocationImpl)Principal.location();
        String resourcepath = loc.path();
        // UGLY: as long as the ACL spec does not cover maintaining users & groups,
        //       i.e. as long as there is no MKPRINCIPAL method, we use MKCOL to
        //       create principals (users, groups and roles).
        HttpMethod method = new MkcolMethod(loc.escapedPath());
        method.addRequestHeader( "Content-Length", "0" );
        
        try {
            method = (MkcolMethod)retryHandler().executeMethod( method );
            int sc = method.getStatusCode();
            String st = method.getStatusText();
            switch( sc ) {
                case HttpStatus.SC_CREATED:
                    break;
                case HttpStatus.SC_FORBIDDEN:
                case HttpStatus.SC_CONFLICT:
                    ErrorResponse errorRsp = new ErrorResponse( method.getResponseBodyAsStream() );
                    throw new WvcmException(
                        st, resourcepath, errorRsp.getWvcmReasonCode(), null);
                case HttpStatus.SC_UNAUTHORIZED:
                    throw new WvcmException(
                        st, resourcepath, ReasonCode.UNAUTHORIZED, null);
                default:
                    throw new WvcmException(
                        st, resourcepath, ReasonCode.CANNOT_INITIALIZE_RESOURCE, null);
            }
        }
        catch (java.io.IOException e) {
            throw new WvcmException(
                "Write failed", resourcepath, ReasonCode.WRITE_FAILED, new Exception[]{e});
        }
        finally {
            method.releaseConnection();
        }
    }
}

