/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/store/webdav/request/AclRequest.java,v 1.3 2004/07/30 06:52:29 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:29 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store.webdav.request;

import java.util.Iterator;
import java.util.List;
import javax.wvcm.AccessControlElement;
import javax.wvcm.AccessControlElement.Privilege;
import javax.wvcm.Principal;
import org.jdom.Document;
import org.jdom.Element;

/**
 * Handler for ACL request bodies.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class AclRequest extends AbstractRequest {
    
    /**
     * Constructor
     */
    public AclRequest( List acl ) {
        Element aclElm = new Element( "acl", dnsp );
        if (acl != null) {
            Iterator i = acl.iterator();
            while (i.hasNext()) {
                AccessControlElement ace = (AccessControlElement)i.next();
                aclElm.addContent( createAceElm(ace) ) ;
            }
        }
        setReqBodyDoc( new Document(aclElm) );
    }
    
    private Element createAceElm( AccessControlElement ace ) {
        Element aceElm = new Element( "ace", dnsp );
        // add the pricipal
        Element princElm = new Element( "principal", dnsp );
        Principal principal = ace.getPrincipal();
        if (principal == Principal.ALL) {
            princElm.addContent(new Element("all", dnsp));
        }
        else if (principal == Principal.SELF) {
            princElm.addContent(new Element("self", dnsp));
        }
        else if (principal == Principal.OWNER) {
            Element propertyElm = new Element("property", dnsp);
            propertyElm.addContent(new Element("owner", dnsp));
            princElm.addContent(propertyElm);
        }
        else if (principal == Principal.AUTHENTICATED) {
            princElm.addContent(new Element("authenticated", dnsp));
        }
        else if (principal == Principal.UNAUTHENTICATED) {
            princElm.addContent(new Element("unauthenticated", dnsp));
        }
        else {
            createHrefElement( princElm, ace.getPrincipal() );
        }
        aceElm.addContent( princElm );
        // add the privileges
        Element grantdenyElm = ace.isGrant()
            ? new Element( "grant", dnsp )
            : new Element( "deny", dnsp );
        if (ace.getPrivileges() != null) {
            Iterator i = ace.getPrivileges().iterator();
            while (i.hasNext()) {
                Privilege p = (Privilege)i.next();
                Element privElm = new Element( "privilege", dnsp );
                Element pElm = new Element( p.location().lastSegment(), dnsp );
                privElm.addContent(pElm);
                grantdenyElm.addContent(privElm);
            }
        }
        aceElm.addContent(grantdenyElm);
        
        return aceElm;
    }
}

