/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/wvcm/src/org/apache/wvcm/store/webdav/request/ProppatchRequest.java,v 1.3 2004/07/30 06:52:29 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:29 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.wvcm.store.webdav.request;
import org.apache.wvcm.store.webdav.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.wvcm.PropertyNameList.AttributeName;
import javax.wvcm.PropertyNameList.PropertyName;
import javax.wvcm.Resource;
import javax.wvcm.AccessControlElement.Privilege;
import org.apache.wvcm.ResourceImpl;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

/**
 * Handler for PROPPATCH request bodies.
 *
 * @author <a href="mailto:peter.nevermann@softwareag.com">Peter Nevermann</a>
 * @version $Revision: 1.3 $
 */
public class ProppatchRequest extends AbstractRequest {
    
    /**
     * Constructor
     */
    public ProppatchRequest( Map propupdates ) {
        Element propupdElm = new Element( "propertyupdate", dnsp );
        Element propSetElm = new Element( "prop", dnsp );
        Element propRemoveElm = new Element( "prop", dnsp );
        
        if( propupdates != null ) {
            Iterator i = propupdates.entrySet().iterator();
            while( i.hasNext() ) {
                Map.Entry e = (Map.Entry)i.next();
                PropertyName pname = (PropertyName)e.getKey();
                PropertyUpdate propupd = (PropertyUpdate)e.getValue();
                Element pElm = null;
                if( pname instanceof AttributeName ) {
                    pElm = new Element( pname.getString(), Namespace.getNamespace(((AttributeName)pname).getNamespace()) );
                }
                else if( pname instanceof PropertyName ) {
                    String webdavname = WebdavProperties.webdavNameForPropertyName(pname);
                    if( webdavname != null ) {
                        pElm = new Element( webdavname, dnsp );
                    }
                }
                
                if( pElm != null ) {
                    if( propupd.remove ){
                        propRemoveElm.addContent( pElm );
                    }
                    else if( propupd.value != null ) {
                        propSetElm.addContent( pElm );
                        if( propupd.value instanceof String ) {
                            String v = (String)propupd.value;
                            if (pname == PropertyName.CONTENT_TYPE) {
                                // check CONTENT_CHARACTER_SET
                                if (propupdates.containsKey(PropertyName.CONTENT_CHARACTER_SET)) {
                                    PropertyUpdate ccsPu = (PropertyUpdate)propupdates.get(PropertyName.CONTENT_CHARACTER_SET);
                                    if (!ccsPu.remove && ccsPu.value != null && ((String)ccsPu.value).length() > 0 ) {
                                        v = v+"; charset=\""+ccsPu.value+"\"";
                                    }
                                }
                            }
                            pElm.addContent( new Text(v) );
                        }
                        else if( propupd.value instanceof Integer ) {
                            pElm.addContent( new Text(((Integer)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Long ) {
                            pElm.addContent( new Text(((Long)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Short ) {
                            pElm.addContent( new Text(((Short)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Byte ) {
                            pElm.addContent( new Text(((Byte)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Character ) {
                            pElm.addContent( new Text(((Character)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Double ) {
                            pElm.addContent( new Text(((Double)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Float ) {
                            pElm.addContent( new Text(((Float)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Locale ) {
                            pElm.addContent( new Text(WebdavProperties.localeToLanguageTag((Locale)propupd.value)) );
                        }
                        else if( propupd.value instanceof Date ) {
                            pElm.addContent( new Text(((Date)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Boolean ) {
                            pElm.addContent( new Text(((Boolean)propupd.value).toString()) );
                        }
                        else if( propupd.value instanceof Resource ) {
                            createHrefElement( pElm, (Resource)propupd.value );
                        }
                        else if( propupd.value instanceof List ) {
                            if (pname.getString().endsWith("privilege-set")) {
                                Iterator j = ((List)propupd.value).iterator();
                                while( j.hasNext() ) {
                                    Privilege p = (Privilege)j.next();
                                    createPrivilegeElement(pElm, p);
                                }
                            }
                            else {
                                // assuming list of Resource instances
                                Iterator j = ((List)propupd.value).iterator();
                                while( j.hasNext() ) {
                                    Resource r = (Resource)j.next();
                                    createHrefElement( pElm, r );
                                }
                            }
                        }
                        else {
                            throw new UnsupportedOperationException("Property value of type '"+propupd.value.getClass().getName()+"' not supported");
                        }
                        
                        if( pname instanceof AttributeName ) {
                            // add a property descriptor element
                            if( !(propupd.value instanceof String) ) {
                                Namespace nsp = Namespace.getNamespace( "s", "http://jakarta.apache.org/slide/" );
                                Element propdescElm = new Element( "propdescriptor", nsp );
                                if( propupd.value instanceof List ) {
                                    propdescElm.setAttribute( "basetype", ResourceImpl.class.getName());
                                    propdescElm.setAttribute( "collectiontype", ArrayList.class.getName());
                                }
                                else {
                                    propdescElm.setAttribute( "basetype", propupd.value.getClass().getName() );
                                }
                                pElm.addContent( propdescElm );
                            }
                        }
                    }
                }
            }
        }
        if( propSetElm.getChildren().size() > 0 ) {
            Element setElm = new Element( "set", dnsp );
            setElm.addContent( propSetElm );
            propupdElm.addContent( setElm );
        }
        if( propRemoveElm.getChildren().size() > 0 ) {
            Element removeElm = new Element( "remove", dnsp );
            removeElm.addContent( propRemoveElm );
            propupdElm.addContent( removeElm );
        }
        setReqBodyDoc( new Document(propupdElm) );
    }
    
    public static class PropertyUpdate {
        Object value;
        boolean remove;
        
        /**
         * Constructor
         *
         * @param    value the value
         * @param    remove if true, the property is to be removed
         */
        public PropertyUpdate(Object value, boolean remove) {
            this.value = value;
            this.remove = remove;
        }
    }
}

